/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.Comparator;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.server.level.TicketType;
import net.minecraft.world.level.ChunkPos;

public class ChunkLoadingUtils {
    public static final TicketType<ChunkPos> WORKSTATION = TicketType.m_9462_((String)"hundred_years_war_workstation", Comparator.comparingLong(ChunkPos::m_45588_));
    public static final TicketType<ChunkPos> WORKER_NPC = TicketType.m_9462_((String)"hundred_years_war_worker", Comparator.comparingLong(ChunkPos::m_45588_));
    private static final int CHUNK_LOAD_LEVEL = 3;
    private static final int WORK_RANGE_LOAD_LEVEL = 2;

    public static void addChunkTicket(ServerLevel level, BlockPos pos, TicketType<ChunkPos> ticketType) {
        if (level == null || pos == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        level.m_7726_().m_8387_(ticketType, chunkPos, 3, (Object)chunkPos);
    }

    public static void removeChunkTicket(ServerLevel level, BlockPos pos, TicketType<ChunkPos> ticketType) {
        if (level == null || pos == null) {
            return;
        }
        ChunkPos chunkPos = new ChunkPos(pos);
        level.m_7726_().m_8438_(ticketType, chunkPos, 3, (Object)chunkPos);
    }

    public static void addWorkstationChunkLoading(ServerLevel level, BlockPos pos) {
        ChunkLoadingUtils.addChunkTicket(level, pos, WORKSTATION);
    }

    public static void removeWorkstationChunkLoading(ServerLevel level, BlockPos pos) {
        ChunkLoadingUtils.removeChunkTicket(level, pos, WORKSTATION);
    }

    public static void addWorkerChunkLoading(ServerLevel level, BlockPos pos) {
        ChunkLoadingUtils.addChunkTicket(level, pos, WORKER_NPC);
    }

    public static void removeWorkerChunkLoading(ServerLevel level, BlockPos pos) {
        ChunkLoadingUtils.removeChunkTicket(level, pos, WORKER_NPC);
    }

    public static void addWorkstationRangeChunkLoading(ServerLevel level, BlockPos minPos, BlockPos maxPos) {
        if (level == null || minPos == null || maxPos == null) {
            return;
        }
        ChunkPos minChunk = new ChunkPos(minPos);
        ChunkPos maxChunk = new ChunkPos(maxPos);
        for (int x = minChunk.f_45578_; x <= maxChunk.f_45578_; ++x) {
            for (int z = minChunk.f_45579_; z <= maxChunk.f_45579_; ++z) {
                ChunkPos chunkPos = new ChunkPos(x, z);
                level.m_7726_().m_8387_(WORKSTATION, chunkPos, 2, (Object)chunkPos);
            }
        }
    }

    public static void removeWorkstationRangeChunkLoading(ServerLevel level, BlockPos minPos, BlockPos maxPos) {
        if (level == null || minPos == null || maxPos == null) {
            return;
        }
        ChunkPos minChunk = new ChunkPos(minPos);
        ChunkPos maxChunk = new ChunkPos(maxPos);
        for (int x = minChunk.f_45578_; x <= maxChunk.f_45578_; ++x) {
            for (int z = minChunk.f_45579_; z <= maxChunk.f_45579_; ++z) {
                ChunkPos chunkPos = new ChunkPos(x, z);
                level.m_7726_().m_8438_(WORKSTATION, chunkPos, 2, (Object)chunkPos);
            }
        }
    }
}

