/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import net.minecraft.util.Mth;
import net.minecraft.world.phys.Vec3;

public class RocketTrajectoryCalculator {
    private static final float GRAVITY = 9.81f;
    private static final float GRAVITY_TICK = 0.024525002f;
    private static final float BURN_TIME_FACTOR = 3.0f;
    private static final float ACCELERATION_FACTOR = 0.01f;
    private static final int MAX_ITERATIONS = 50;
    private static final float VELOCITY_INCREMENT_START = 5.29f;

    public static TrajectoryResult calculateRocketTrajectory(Vec3 startPos, Vec3 targetPos, Float fixedPitch) {
        float dx = (float)(targetPos.f_82479_ - startPos.f_82479_);
        float dy = (float)(targetPos.f_82480_ - startPos.f_82480_);
        float dz = (float)(targetPos.f_82481_ - startPos.f_82481_);
        float horizontalDistance = Mth.m_14116_((float)(dx * dx + dz * dz));
        float yaw = (float)Math.toDegrees(Math.atan2(-dx, dz));
        if (fixedPitch != null) {
            float velocity = RocketTrajectoryCalculator.calculateVelocityForFixedAngle(horizontalDistance, dy, fixedPitch.floatValue());
            if (velocity > 0.0f) {
                Vec3 launchVector = RocketTrajectoryCalculator.createLaunchVector(yaw, fixedPitch.floatValue(), velocity);
                return new TrajectoryResult(velocity, fixedPitch.floatValue(), launchVector, true);
            }
        } else {
            float[] testAngles;
            for (float testPitch : testAngles = new float[]{39.0f, 35.0f, 45.0f, 30.0f, 50.0f, 25.0f, 55.0f, 20.0f, 60.0f, 15.0f}) {
                float velocity = RocketTrajectoryCalculator.calculateVelocityForFixedAngle(horizontalDistance, dy, testPitch);
                if (!(velocity > 0.0f) || !(velocity <= 60.0f)) continue;
                Vec3 launchVector = RocketTrajectoryCalculator.createLaunchVector(yaw, testPitch, velocity);
                return new TrajectoryResult(velocity, testPitch, launchVector, true);
            }
        }
        return TrajectoryResult.failure();
    }

    private static float calculateVelocityForFixedAngle(float horizontalDistance, float verticalDistance, float pitch) {
        float bestVelocity = 0.0f;
        float velocityIncrement = 5.29f;
        float testVelocity = 1.0f;
        float adjustedAngle = 90.0f - pitch;
        for (int iter = 0; iter < 50; ++iter) {
            if (RocketTrajectoryCalculator.simulateRocketTrajectory(horizontalDistance, verticalDistance, adjustedAngle, testVelocity)) {
                bestVelocity = testVelocity;
                break;
            }
            float hitDistance = RocketTrajectoryCalculator.getSimulatedHitDistance(horizontalDistance, verticalDistance, adjustedAngle, testVelocity);
            if (hitDistance < horizontalDistance) {
                bestVelocity = testVelocity;
                testVelocity += velocityIncrement;
            } else {
                bestVelocity = testVelocity -= velocityIncrement;
                testVelocity += (velocityIncrement *= 0.5f);
            }
            if (velocityIncrement < 0.01f) break;
        }
        return bestVelocity > 0.0f ? bestVelocity : -1.0f;
    }

    private static boolean simulateRocketTrajectory(float targetX, float targetY, float angle, float velocity) {
        float hitDistance = RocketTrajectoryCalculator.getSimulatedHitDistance(targetX, targetY, angle, velocity);
        return Math.abs(hitDistance - targetX) < 3.0f;
    }

    private static float getSimulatedHitDistance(float targetX, float targetY, float angle, float velocity) {
        float posX = 0.0f;
        float posY = 0.0f;
        float motionX = Mth.m_14031_((float)((float)Math.toRadians(angle))) * velocity * 0.05f;
        float motionY = Mth.m_14089_((float)((float)Math.toRadians(angle))) * velocity * 0.05f;
        float motionMagnitude = Mth.m_14116_((float)(motionX * motionX + motionY * motionY));
        int rocketBurnTime = (int)(motionMagnitude * 20.0f * 3.0f);
        float accelX = motionX / motionMagnitude * 0.01f;
        float accelY = motionY / motionMagnitude * 0.01f;
        motionX = accelX;
        motionY = accelY;
        int maxTicks = 1000;
        for (int tick = 0; tick < maxTicks; ++tick) {
            posX += motionX;
            posY += motionY;
            if (rocketBurnTime > 0) {
                --rocketBurnTime;
                motionX += accelX;
                motionY += accelY;
            } else {
                motionY -= 0.024525002f;
            }
            if (posY <= targetY && motionY <= 0.0f) {
                float timeFraction = (targetY - (posY - motionY)) / motionY;
                return posX + motionX * timeFraction;
            }
            if (!(posX > targetX * 2.0f)) continue;
            return posX;
        }
        return posX;
    }

    private static Vec3 createLaunchVector(float yaw, float pitch, float velocity) {
        double yawRad = Math.toRadians(yaw);
        double pitchRad = Math.toRadians(pitch);
        double horizontalComponent = (double)velocity * Math.cos(pitchRad);
        double verticalComponent = (double)velocity * Math.sin(pitchRad);
        double vx = horizontalComponent * Math.sin(yawRad);
        double vy = verticalComponent;
        double vz = horizontalComponent * Math.cos(yawRad);
        return new Vec3(vx, vy, vz);
    }

    public static float calculateOptimalLaunchAngle(Vec3 startPos, Vec3 targetPos) {
        double heightDiff = targetPos.f_82480_ - startPos.f_82480_;
        double horizontalDistance = Math.sqrt(Math.pow(targetPos.f_82479_ - startPos.f_82479_, 2.0) + Math.pow(targetPos.f_82481_ - startPos.f_82481_, 2.0));
        float heightRatio = (float)(heightDiff / Math.max(horizontalDistance, 1.0));
        if (heightRatio > 0.5f) {
            return Math.min(75.0f, 55.0f + heightRatio * 20.0f);
        }
        if (heightRatio > 0.2f) {
            return 45.0f + heightRatio * 15.0f;
        }
        if (heightRatio > -0.2f) {
            return 39.0f;
        }
        if (heightRatio > -0.5f) {
            return 35.0f + heightRatio * 10.0f;
        }
        return Math.max(25.0f, 30.0f + heightRatio * 8.0f);
    }

    public static TrajectoryResult calculateForRocketLauncher(Vec3 startPos, Vec3 targetPos, boolean addRandomSpread) {
        float optimalAngle = RocketTrajectoryCalculator.calculateOptimalLaunchAngle(startPos, targetPos);
        TrajectoryResult result = RocketTrajectoryCalculator.calculateRocketTrajectory(startPos, targetPos, Float.valueOf(optimalAngle));
        if (!result.success) {
            float[] fallbackAngles;
            for (float angle : fallbackAngles = RocketTrajectoryCalculator.generateFallbackAngles(optimalAngle)) {
                result = RocketTrajectoryCalculator.calculateRocketTrajectory(startPos, targetPos, Float.valueOf(angle));
                if (result.success) break;
            }
        }
        if (result.success && addRandomSpread) {
            float accuracy = 0.25f;
            float yawSpread = (float)(Math.random() - 0.5) * 2.0f * (1.0f - accuracy) * 10.0f;
            float pitchSpread = (float)(Math.random() - 0.5) * 2.0f * (1.0f - accuracy) * 15.0f;
            float velocityAdjustment = result.velocity / 50.0f;
            float newYaw = (float)Math.toDegrees(Math.atan2(-result.launchVector.f_82479_, result.launchVector.f_82481_)) + yawSpread;
            float newPitch = Math.max(15.0f, Math.min(75.0f, result.pitch + pitchSpread));
            float newVelocity = Math.max(1.0f, result.velocity + velocityAdjustment);
            Vec3 adjustedVector = RocketTrajectoryCalculator.createLaunchVector(newYaw, newPitch, newVelocity);
            return new TrajectoryResult(newVelocity, newPitch, adjustedVector, true);
        }
        return result;
    }

    private static float[] generateFallbackAngles(float optimalAngle) {
        return new float[]{optimalAngle + 5.0f, optimalAngle - 5.0f, optimalAngle + 10.0f, optimalAngle - 10.0f, 45.0f, 39.0f, 55.0f, 30.0f, 65.0f, 25.0f};
    }

    public static class TrajectoryResult {
        public final float velocity;
        public final float pitch;
        public final Vec3 launchVector;
        public final boolean success;

        public TrajectoryResult(float velocity, float pitch, Vec3 launchVector, boolean success) {
            this.velocity = velocity;
            this.pitch = pitch;
            this.launchVector = launchVector;
            this.success = success;
        }

        public static TrajectoryResult failure() {
            return new TrajectoryResult(0.0f, 0.0f, Vec3.f_82478_, false);
        }
    }
}

