/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.util.UUID;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.TamableAnimal;
import net.minecraft.world.entity.player.Player;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class ServerRelationHelper {
    private static boolean canParticipateInRelation(Entity entity) {
        TamableAnimal tamable;
        return entity instanceof Player || entity instanceof BaseCombatSupport || entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_();
    }

    private static UUID resolveRelationUUID(Entity entity) {
        TamableAnimal tamable;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            return player.m_20148_();
        }
        if (entity instanceof BaseCombatSupport) {
            BaseCombatSupport support = (BaseCombatSupport)entity;
            return support.m_21805_();
        }
        if (entity instanceof TamableAnimal && (tamable = (TamableAnimal)entity).m_21824_()) {
            return tamable.m_21805_();
        }
        return null;
    }

    public static boolean isEnemyRelation(Entity entity1, Entity entity2) {
        if (!(entity1 instanceof LivingEntity) || !(entity2 instanceof LivingEntity)) {
            return false;
        }
        UUID uuid1 = ServerRelationHelper.resolveRelationUUID(entity1);
        UUID uuid2 = ServerRelationHelper.resolveRelationUUID(entity2);
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return true;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        RelationSystem.RelationType relation2 = RelationSystem.getRelation(uuid2, uuid1);
        return relation1 == RelationSystem.RelationType.HOSTILE || relation2 == RelationSystem.RelationType.HOSTILE;
    }

    public static boolean hasControlOver(Player player, Entity entity) {
        if (CreativeModeSettings.canControlAllUnits(player)) {
            return true;
        }
        if (!(entity instanceof BaseCombatSupport)) {
            return false;
        }
        UUID playerUUID = player.m_20148_();
        BaseCombatSupport equipmentEntity = (BaseCombatSupport)entity;
        UUID entityOwnerUUID = equipmentEntity.m_21805_();
        if (entityOwnerUUID != null && entityOwnerUUID.equals(playerUUID)) {
            return true;
        }
        if (entityOwnerUUID == null) {
            return false;
        }
        RelationSystem.RelationType ownerToPlayer = RelationSystem.getRelation(entityOwnerUUID, playerUUID);
        return ownerToPlayer == RelationSystem.RelationType.CONTROL;
    }

    public static boolean isNeutralRelation(Entity entity1, Entity entity2) {
        if (!(entity1 instanceof LivingEntity) || !(entity2 instanceof LivingEntity)) {
            return true;
        }
        UUID uuid1 = ServerRelationHelper.resolveRelationUUID(entity1);
        UUID uuid2 = ServerRelationHelper.resolveRelationUUID(entity2);
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.NEUTRAL;
    }

    public static boolean isFriendlyRelation(Entity entity1, Entity entity2) {
        if (!(entity1 instanceof LivingEntity) || !(entity2 instanceof LivingEntity)) {
            return false;
        }
        UUID uuid1 = ServerRelationHelper.resolveRelationUUID(entity1);
        UUID uuid2 = ServerRelationHelper.resolveRelationUUID(entity2);
        if (uuid1 == null && uuid2 == null) {
            return ServerRelationHelper.canParticipateInRelation(entity1) && ServerRelationHelper.canParticipateInRelation(entity2);
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.FRIENDLY;
    }

    public static boolean isControlRelation(Entity entity1, Entity entity2) {
        UUID uuid1 = ServerRelationHelper.resolveRelationUUID(entity1);
        UUID uuid2 = ServerRelationHelper.resolveRelationUUID(entity2);
        if (uuid1 == null || uuid2 == null || uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        RelationSystem.RelationType relation2 = RelationSystem.getRelation(uuid2, uuid1);
        return relation1 == RelationSystem.RelationType.CONTROL || relation2 == RelationSystem.RelationType.CONTROL;
    }

    public static boolean isEnemyRelationByUUID(UUID uuid1, UUID uuid2) {
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return true;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        RelationSystem.RelationType relation2 = RelationSystem.getRelation(uuid2, uuid1);
        return relation1 == RelationSystem.RelationType.HOSTILE || relation2 == RelationSystem.RelationType.HOSTILE;
    }

    public static boolean isNeutralRelationByUUID(UUID uuid1, UUID uuid2) {
        if (uuid1 == null && uuid2 == null) {
            return false;
        }
        if (uuid1 == null || uuid2 == null) {
            return false;
        }
        if (uuid1.equals(uuid2)) {
            return false;
        }
        RelationSystem.RelationType relation1 = RelationSystem.getRelation(uuid1, uuid2);
        return relation1 == RelationSystem.RelationType.NEUTRAL;
    }
}

