/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.shadow.zstd;

import java.nio.ByteBuffer;
import ydmsama.hundred_years_war.shadow.zstd.SharedDictBase;
import ydmsama.hundred_years_war.shadow.zstd.Zstd;
import ydmsama.hundred_years_war.shadow.zstd.util.Native;

public class ZstdDictCompress
extends SharedDictBase {
    private long nativePtr = 0L;
    private int level = Zstd.defaultCompressionLevel();

    private native void init(byte[] var1, int var2, int var3, int var4);

    private native void initDirect(ByteBuffer var1, int var2, int var3, int var4);

    private native void free();

    public ZstdDictCompress(byte[] byArray, int n) {
        this(byArray, 0, byArray.length, n);
    }

    public ZstdDictCompress(byte[] byArray, int n, int n2, int n3) {
        this.level = n3;
        if (byArray.length - n < 0) {
            throw new IllegalArgumentException("Dictionary buffer is to short");
        }
        this.init(byArray, n, n2, n3);
        if (0L == this.nativePtr) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        this.storeFence();
    }

    public ZstdDictCompress(ByteBuffer byteBuffer, int n) {
        this.level = n;
        int n2 = byteBuffer.limit() - byteBuffer.position();
        if (!byteBuffer.isDirect()) {
            throw new IllegalArgumentException("dict must be a direct buffer");
        }
        if (n2 < 0) {
            throw new IllegalArgumentException("dict cannot be empty.");
        }
        this.initDirect(byteBuffer, byteBuffer.position(), n2, n);
        if (this.nativePtr == 0L) {
            throw new IllegalStateException("ZSTD_createCDict failed");
        }
        this.storeFence();
    }

    int level() {
        return this.level;
    }

    @Override
    void doClose() {
        if (this.nativePtr != 0L) {
            this.free();
            this.nativePtr = 0L;
        }
    }

    static {
        Native.load();
    }
}

