/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.ui;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_332;
import net.minecraft.class_757;
import org.lwjgl.glfw.GLFW;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.keys.HotKeyManager;

@Environment(value=EnvType.CLIENT)
public class CustomCrosshairHandler {
    private static CustomCrosshairHandler instance;
    private static boolean isCursorHidden;
    private static final float CROSSHAIR_SIZE = 2.0f;
    private static final float CROSSHAIR_GAP = 0.4f;
    private static final int EXTRA_THICKNESS = 4;
    private static final float THICKNESS_OFFSET = 0.05f;
    private static final float MID_LINE_LENGTH = 1.2f;
    private static final float END_LINE_LENGTH = 2.4f;

    private CustomCrosshairHandler() {
    }

    public static CustomCrosshairHandler getInstance() {
        if (instance == null) {
            instance = new CustomCrosshairHandler();
        }
        return instance;
    }

    private static boolean shouldShowCustomCrosshair() {
        return !Objects.equals(HotKeyManager.getCurrentActive(), "") && !Freecam.isRotateCamera();
    }

    private static boolean shouldHideCursor() {
        if (Freecam.MC.field_1755 != null) {
            return false;
        }
        return Freecam.isRotateCamera() || CustomCrosshairHandler.shouldShowCustomCrosshair();
    }

    private static void hideCursor() {
        GLFW.glfwSetInputMode((long)Freecam.MC.method_22683().method_4490(), (int)208897, (int)212994);
        isCursorHidden = true;
    }

    private static void showCursor() {
        GLFW.glfwSetInputMode((long)Freecam.MC.method_22683().method_4490(), (int)208897, (int)212993);
        isCursorHidden = false;
    }

    private static float[] getCrosshairColor() {
        float[] fArray;
        String currentActive;
        switch (currentActive = HotKeyManager.getCurrentActive()) {
            case "attack": {
                float[] fArray2 = new float[4];
                fArray2[0] = 1.0f;
                fArray2[1] = 0.2f;
                fArray2[2] = 0.2f;
                fArray = fArray2;
                fArray2[3] = 1.0f;
                break;
            }
            case "patrol": {
                float[] fArray3 = new float[4];
                fArray3[0] = 0.2f;
                fArray3[1] = 0.2f;
                fArray3[2] = 1.0f;
                fArray = fArray3;
                fArray3[3] = 1.0f;
                break;
            }
            case "bombard": {
                float[] fArray4 = new float[4];
                fArray4[0] = 1.0f;
                fArray4[1] = 0.2f;
                fArray4[2] = 0.2f;
                fArray = fArray4;
                fArray4[3] = 1.0f;
                break;
            }
            case "unload": {
                float[] fArray5 = new float[4];
                fArray5[0] = 1.0f;
                fArray5[1] = 1.0f;
                fArray5[2] = 0.2f;
                fArray = fArray5;
                fArray5[3] = 1.0f;
                break;
            }
            default: {
                float[] fArray6 = new float[4];
                fArray6[0] = 1.0f;
                fArray6[1] = 1.0f;
                fArray6[2] = 1.0f;
                fArray = fArray6;
                fArray6[3] = 1.0f;
            }
        }
        return fArray;
    }

    public void renderCustomCrosshair(class_332 guiGraphics) {
        if (Freecam.isRotateCamera()) {
            return;
        }
        boolean shouldShow = CustomCrosshairHandler.shouldShowCustomCrosshair();
        boolean shouldHide = CustomCrosshairHandler.shouldHideCursor();
        if (shouldHide) {
            CustomCrosshairHandler.hideCursor();
        } else {
            CustomCrosshairHandler.showCursor();
        }
        if (!shouldShow) {
            return;
        }
        int screenWidth = Freecam.MC.method_22683().method_4480();
        int screenHeight = Freecam.MC.method_22683().method_4507();
        int guiScreenWidth = Freecam.MC.method_22683().method_4486();
        int guiScreenHeight = Freecam.MC.method_22683().method_4502();
        double mouseX = Freecam.MC.field_1729.method_1603() / ((double)screenWidth / (double)guiScreenWidth);
        double mouseY = Freecam.MC.field_1729.method_1604() / ((double)screenHeight / (double)guiScreenHeight);
        RenderSystem.setShader(class_757::method_34540);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        float[] color = CustomCrosshairHandler.getCrosshairColor();
        float r = color[0];
        float g = color[1];
        float b = color[2];
        float a = color[3];
        CustomCrosshairHandler.drawCrosshairLines(mouseX, mouseY, r, g, b, a);
        RenderSystem.disableBlend();
    }

    private static void drawCrosshairLines(double mouseX, double mouseY, float r, float g, float b, float a) {
        CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, 0.0f, 0.0f, r, g, b, a);
        for (int thickness = 1; thickness <= 4; ++thickness) {
            float offset = (float)thickness * 0.05f;
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, offset, 0.0f, r, g, b, a);
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, -offset, 0.0f, r, g, b, a);
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, 0.0f, offset, r, g, b, a);
            CustomCrosshairHandler.drawCrosshairAtOffset(mouseX, mouseY, 0.0f, -offset, r, g, b, a);
        }
    }

    private static void drawCrosshairAtOffset(double mouseX, double mouseY, float offsetX, float offsetY, float r, float g, float b, float a) {
        double x = mouseX + (double)offsetX;
        double y = mouseY + (double)offsetY;
        class_289 tesselator = class_289.method_1348();
        class_287 bufferBuilder = tesselator.method_1349();
        bufferBuilder.method_1328(class_293.class_5596.field_29344, class_290.field_1576);
        bufferBuilder.method_22912(x - 2.0 - (double)0.4f, y, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - (double)0.4f, y, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + (double)0.4f, y, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + 2.0 + (double)0.4f, y, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x, y - 2.0 - (double)0.4f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x, y - (double)0.4f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x, y + (double)0.4f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x, y + 2.0 + (double)0.4f, 0.0).method_22915(r, g, b, a).method_1344();
        double midPos = 1.4000000059604645;
        bufferBuilder.method_22912(x - midPos, y - (double)0.6f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - midPos, y + (double)0.6f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + midPos, y - (double)0.6f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + midPos, y + (double)0.6f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - (double)0.6f, y - midPos, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + (double)0.6f, y - midPos, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - (double)0.6f, y + midPos, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + (double)0.6f, y + midPos, 0.0).method_22915(r, g, b, a).method_1344();
        double endPos = 2.4f;
        bufferBuilder.method_22912(x - endPos, y - (double)1.2f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - endPos, y + (double)1.2f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + endPos, y - (double)1.2f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + endPos, y + (double)1.2f, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - (double)1.2f, y - endPos, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + (double)1.2f, y - endPos, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x - (double)1.2f, y + endPos, 0.0).method_22915(r, g, b, a).method_1344();
        bufferBuilder.method_22912(x + (double)1.2f, y + endPos, 0.0).method_22915(r, g, b, a).method_1344();
        tesselator.method_1350();
    }

    static {
        isCursorHidden = false;
    }
}

