/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.freecam.util;

import com.mojang.authlib.GameProfile;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1702;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2596;
import net.minecraft.class_2680;
import net.minecraft.class_3486;
import net.minecraft.class_3619;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4050;
import net.minecraft.class_4184;
import net.minecraft.class_634;
import net.minecraft.class_743;
import net.minecraft.class_746;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.freecam.config.ClientModConfig;
import ydmsama.hundred_years_war.client.freecam.mixins.ClientLevelAccessor;
import ydmsama.hundred_years_war.client.freecam.selection.SelectionHandler;
import ydmsama.hundred_years_war.client.freecam.util.FreecamPosition;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
public class FreeCamera
extends class_746 {
    private static final class_634 NETWORK_HANDLER = new class_634(Freecam.MC, Freecam.MC.field_1755, Objects.requireNonNull(Freecam.MC.method_1562()).method_48296(), Freecam.MC.method_1558(), new GameProfile(UUID.randomUUID(), "FreeCamera"), Freecam.MC.method_47601().method_47706(false, null, null)){

        public void method_2883(class_2596<?> packet) {
        }
    };

    public FreeCamera(int id) {
        super(Freecam.MC, Freecam.MC.field_1687, NETWORK_HANDLER, Freecam.MC.field_1724.method_3143(), Freecam.MC.field_1724.method_3130(), false, false);
        this.method_5838(id);
        this.method_18380(class_4050.field_18079);
        this.method_31549().field_7479 = true;
        this.field_3913 = new class_743(Freecam.MC.field_1690);
    }

    public void method_5719(class_1297 entity) {
        this.applyPosition(new FreecamPosition(entity));
    }

    public void applyPosition(FreecamPosition position) {
        this.method_5808(position.x, position.y, position.z, position.yaw, position.pitch);
        this.field_3916 = this.method_36455();
        this.field_3932 = this.method_36454();
        this.field_3914 = this.field_3916;
        this.field_3931 = this.field_3932;
    }

    public void applyPerspective(ClientModConfig.Perspective perspective, boolean checkCollision) {
        FreecamPosition position = new FreecamPosition((class_1297)this);
        switch (perspective) {
            case INSIDE: {
                break;
            }
            case FIRST_PERSON: {
                this.moveForwardUntilCollision(position, 0.4, checkCollision);
                break;
            }
            case THIRD_PERSON_MIRROR: {
                position.mirrorRotation();
            }
            case THIRD_PERSON: {
                this.moveUpwardUntilCollision(position, 0.0, checkCollision);
                this.moveForwardUntilCollision(position, -4.0, checkCollision);
            }
        }
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveForward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveForwardUntilCollision(position, distance);
    }

    private boolean moveForwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((class_1297)this);
            position.moveForward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.wouldNotSuffocateAtTargetPose(this.method_18376())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    protected boolean wouldNotSuffocateAtTargetPose(class_4050 pose) {
        class_238 boundingBox = this.method_18377(pose).method_30757(this.method_19538());
        return ((EntityAccessor)((Object)this)).getLevel().method_8587((class_1297)this, boundingBox);
    }

    public boolean moveUpwardUntilCollision(FreecamPosition position, double distance, boolean checkCollision) {
        if (!checkCollision) {
            position.moveUpward(distance);
            this.applyPosition(position);
            return true;
        }
        return this.moveUpwardUntilCollision(position, distance);
    }

    private boolean moveUpwardUntilCollision(FreecamPosition position, double maxDistance) {
        boolean negative = maxDistance < 0.0;
        maxDistance = negative ? -1.0 * maxDistance : maxDistance;
        double increment = 0.1;
        for (double distance = 0.0; distance < maxDistance; distance += increment) {
            FreecamPosition oldPosition = new FreecamPosition((class_1297)this);
            position.moveUpward(negative ? -1.0 * increment : increment);
            this.applyPosition(position);
            if (this.wouldNotSuffocateAtTargetPose(this.method_18376())) continue;
            this.applyPosition(oldPosition);
            return distance > 0.0;
        }
        return true;
    }

    public void spawn() {
        if (this.field_17892 != null) {
            ClientLevelAccessor accessor = (ClientLevelAccessor)this.field_17892;
            accessor.callAddEntity(this.method_5628(), (class_1297)this);
        }
    }

    public void despawn() {
        if (this.field_17892 != null && this.field_17892.method_8469(this.method_5628()) != null) {
            this.field_17892.method_2945(this.method_5628(), class_1297.class_5529.field_26999);
        }
    }

    protected void method_5623(double heightDifference, boolean onGround, class_2680 landedState, class_2338 landedPosition) {
    }

    public float method_6055(float tickDelta) {
        return Freecam.MC.field_1724.method_6055(tickDelta);
    }

    public int method_6014() {
        return Freecam.MC.field_1724.method_6014();
    }

    public boolean method_6115() {
        return Freecam.MC.field_1724.method_6115();
    }

    public boolean method_6101() {
        return false;
    }

    public boolean method_5799() {
        return false;
    }

    public class_1293 method_6112(class_1291 effect) {
        return Freecam.MC.field_1724.method_6112(effect);
    }

    public class_3619 method_5657() {
        return ClientModConfig.INSTANCE.collision.ignoreAll ? class_3619.field_15975 : class_3619.field_15974;
    }

    public boolean method_30949(class_1297 other) {
        return false;
    }

    public void method_18380(class_4050 pose) {
        super.method_18380(class_4050.field_18079);
    }

    public boolean method_20303() {
        return false;
    }

    protected boolean method_7295() {
        this.field_7490 = this.method_5777(class_3486.field_15517);
        return this.field_7490;
    }

    protected void method_5746() {
    }

    public void method_6007() {
        if (ClientModConfig.INSTANCE.movement.flightMode.equals((Object)ClientModConfig.FlightMode.DEFAULT)) {
            this.method_31549().method_7248(0.0f);
            Freecam.doEdgeMotion();
        } else {
            this.method_31549().method_7248((float)ClientModConfig.INSTANCE.movement.verticalSpeed / 10.0f);
        }
        super.method_6007();
        this.method_31549().field_7479 = true;
        this.method_24830(false);
    }

    @NotNull
    public class_239 camPick(double d, float f, boolean bl, boolean ent) {
        return this.performRaycast(d, f, bl, ent, PuppetSelectionStrategy.NORMAL, false);
    }

    @NotNull
    public class_239 camPick(double d, float f, boolean bl, boolean ent, boolean ignoreControlledEntities) {
        return this.performRaycast(d, f, bl, ent, PuppetSelectionStrategy.NORMAL, ignoreControlledEntities);
    }

    @NotNull
    public class_239 camPickPrioritizePuppet(double d, float f) {
        return this.performRaycast(d, f, false, true, PuppetSelectionStrategy.PRIORITIZE, false);
    }

    @NotNull
    public class_239 camPickPrioritizePuppet(double d, float f, boolean ignoreControlledEntities) {
        return this.performRaycast(d, f, false, true, PuppetSelectionStrategy.PRIORITIZE, ignoreControlledEntities);
    }

    @NotNull
    public class_239 camPickIgnorePuppet(double d, float f) {
        return this.performRaycast(d, f, false, true, PuppetSelectionStrategy.IGNORE, false);
    }

    @NotNull
    public class_239 camPickIgnorePuppet(double d, float f, boolean ignoreControlledEntities) {
        return this.performRaycast(d, f, false, true, PuppetSelectionStrategy.IGNORE, ignoreControlledEntities);
    }

    @NotNull
    private class_239 performRaycast(double distance, float partialTicks, boolean includeFluid, boolean includeEntities, PuppetSelectionStrategy puppetStrategy, boolean ignoreControlledEntities) {
        class_239 blockHitResult;
        class_243 eyePos = this.method_5836(partialTicks);
        class_243 direction = SelectionHandler.getInstance().screenToWorld(Freecam.MC.field_1729.method_1603(), Freecam.MC.field_1729.method_1604(), Freecam.MC);
        class_243 endPos = eyePos.method_1031(direction.field_1352 * distance, direction.field_1351 * distance, direction.field_1350 * distance);
        if (includeEntities) {
            class_239 entityHitResult = this.performEntityRaycast(eyePos, endPos, puppetStrategy, ignoreControlledEntities);
            if (entityHitResult != null) {
                return entityHitResult;
            }
            class_239 blockEntityHitResult = this.performBlockEntityRaycast(eyePos, endPos, direction);
            if (blockEntityHitResult != null) {
                return blockEntityHitResult;
            }
        }
        if ((blockHitResult = this.performBlockRaycast(eyePos, endPos, includeFluid)).method_17783() != class_239.class_240.field_1333) {
            return blockHitResult;
        }
        return class_3965.method_17778((class_243)endPos, (class_2350)class_2350.method_10142((double)direction.field_1352, (double)direction.field_1351, (double)direction.field_1350), (class_2338)new class_2338((int)endPos.field_1352, (int)endPos.field_1351, (int)endPos.field_1350));
    }

    private class_239 performEntityRaycast(class_243 eyePos, class_243 endPos, PuppetSelectionStrategy puppetStrategy, boolean ignoreControlledEntities) {
        EntityHitResults results = new EntityHitResults();
        List entities = this.method_37908().method_8335((class_1297)this, new class_238(eyePos, endPos).method_1014(1.0));
        for (class_1297 entity : entities) {
            class_238 entityBoundingBox;
            Optional hitPoint;
            if (!this.shouldConsiderEntity(entity) || ignoreControlledEntities && this.shouldIgnoreControlledEntity(entity) || !(hitPoint = (entityBoundingBox = entity.method_5829()).method_992(eyePos, endPos)).isPresent()) continue;
            double distance = eyePos.method_1022((class_243)hitPoint.get());
            if (entity instanceof IPuppet) {
                IPuppet puppet = (IPuppet)entity;
                this.handlePuppetEntity(puppet, (class_243)hitPoint.get(), distance, puppetStrategy, results, eyePos, endPos);
                continue;
            }
            if (!(distance < results.nearestOtherEntityDistance)) continue;
            results.nearestOtherEntityDistance = distance;
            results.nearestOtherEntityHitResult = new class_3966(entity, (class_243)hitPoint.get());
        }
        return this.selectEntityHitResult(puppetStrategy, results.nearestPuppetHitResult, results.nearestOtherEntityHitResult);
    }

    private boolean shouldConsiderEntity(class_1297 entity) {
        if (!(entity instanceof class_1309)) {
            return false;
        }
        if (entity == this) {
            return false;
        }
        if (entity == Freecam.MC.field_1724 && ClientModConfig.INSTANCE.visual.showPlayer) {
            double minDistance;
            double thresholdSquared;
            class_243 playerPos;
            class_243 cameraPos = Freecam.MC.field_1773.method_19418().method_19326();
            double distanceSquared = cameraPos.method_1025(playerPos = Freecam.MC.field_1724.method_33571());
            return distanceSquared > (thresholdSquared = (minDistance = ClientModConfig.INSTANCE.visual.playerRenderMinDistance) * minDistance);
        }
        return true;
    }

    private void handlePuppetEntity(IPuppet puppet, class_243 hitPoint, double distance, PuppetSelectionStrategy strategy, EntityHitResults results, class_243 eyePos, class_243 endPos) {
        switch (strategy) {
            case PRIORITIZE: {
                if (!(distance < results.nearestPuppetDistance)) break;
                results.nearestPuppetDistance = distance;
                results.nearestPuppetHitResult = new class_3966((class_1297)puppet, hitPoint);
                break;
            }
            case IGNORE: {
                double playerDistance;
                class_238 playerBoundingBox;
                Optional playerHitPoint;
                class_1297 firstPassenger = puppet.method_31483();
                if (!(firstPassenger instanceof class_1657) || !(playerHitPoint = (playerBoundingBox = firstPassenger.method_5829()).method_992(eyePos, endPos)).isPresent() || !((playerDistance = eyePos.method_1022((class_243)playerHitPoint.get())) < results.nearestOtherEntityDistance)) break;
                results.nearestOtherEntityDistance = playerDistance;
                results.nearestOtherEntityHitResult = new class_3966(firstPassenger, (class_243)playerHitPoint.get());
                break;
            }
            default: {
                if (!(distance < results.nearestOtherEntityDistance)) break;
                results.nearestOtherEntityDistance = distance;
                results.nearestOtherEntityHitResult = new class_3966((class_1297)puppet, hitPoint);
            }
        }
    }

    private boolean shouldIgnoreControlledEntity(class_1297 entity) {
        if (entity instanceof BaseCombatEntity) {
            RelationSystem.RelationType relation = ClientRelationHelper.getInstance().getRelationWithPlayer(entity);
            return relation == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    private class_239 selectEntityHitResult(PuppetSelectionStrategy strategy, class_239 puppetResult, class_239 otherResult) {
        switch (strategy) {
            case PRIORITIZE: {
                return puppetResult != null ? puppetResult : otherResult;
            }
        }
        return otherResult;
    }

    private class_239 performBlockEntityRaycast(class_243 eyePos, class_243 endPos, class_243 direction) {
        class_239 nearestBlockEntityHitResult = null;
        double nearestBlockEntityDistance = Double.MAX_VALUE;
        return nearestBlockEntityHitResult;
    }

    private class_239 performBlockRaycast(class_243 eyePos, class_243 endPos, boolean includeFluid) {
        class_3959 clipContext = new class_3959(eyePos, endPos, class_3959.class_3960.field_17558, includeFluid ? class_3959.class_242.field_1347 : class_3959.class_242.field_1348, (class_1297)this);
        return this.method_37908().method_17742(clipContext);
    }

    public float method_6032() {
        return Freecam.MC.field_1724 != null ? Freecam.MC.field_1724.method_6032() : super.method_6032();
    }

    public int method_5669() {
        return Freecam.MC.field_1724 != null ? Freecam.MC.field_1724.method_5669() : super.method_5669();
    }

    public int method_6096() {
        return Freecam.MC.field_1724 != null ? Freecam.MC.field_1724.method_6096() : super.method_6096();
    }

    public class_1702 method_7344() {
        return Freecam.MC.field_1724 != null ? Freecam.MC.field_1724.method_7344() : super.method_7344();
    }

    public float method_6067() {
        return Freecam.MC.field_1724 != null ? Freecam.MC.field_1724.method_6067() : super.method_6067();
    }

    public void syncToCamera(class_4184 cam) {
        class_243 pos = cam.method_19326();
        this.method_5808(pos.field_1352, pos.field_1351 - 0.4, pos.field_1350, cam.method_19330(), cam.method_19329());
        this.field_3916 = this.method_36455();
        this.field_3932 = this.method_36454();
        this.field_3914 = this.field_3916;
        this.field_3931 = this.field_3932;
    }

    @Environment(value=EnvType.CLIENT)
    public static enum PuppetSelectionStrategy {
        NORMAL,
        PRIORITIZE,
        IGNORE;

    }

    @Environment(value=EnvType.CLIENT)
    private static class EntityHitResults {
        class_239 nearestPuppetHitResult = null;
        class_239 nearestOtherEntityHitResult = null;
        double nearestPuppetDistance = Double.MAX_VALUE;
        double nearestOtherEntityDistance = Double.MAX_VALUE;

        private EntityHitResults() {
        }
    }
}

