/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.handler;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_437;
import net.minecraft.class_746;
import ydmsama.hundred_years_war.client.gui.BuildingPlaceScreen;
import ydmsama.hundred_years_war.client.gui.BuildingSaveScreen;
import ydmsama.hundred_years_war.client.gui.PlaceholderFillScreen;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.network.packets.BuildingToolActionPacket;

@Environment(value=EnvType.CLIENT)
public class BuildingToolClientHandler {
    public static void handleRightClick(class_1799 stack) {
        if (!(stack.method_7909() instanceof BuildingToolItem)) {
            return;
        }
        BuildingToolItem.Mode mode = BuildingToolItem.getMode(stack);
        if (mode == BuildingToolItem.Mode.SAVE) {
            BuildingToolClientHandler.handleSaveUndo(stack);
        } else if (mode == BuildingToolItem.Mode.PLACE) {
            BuildingToolClientHandler.openBuildingSelectionUI(stack);
        } else if (mode == BuildingToolItem.Mode.FILL) {
            BuildingToolClientHandler.handleFillUndoRightClick(stack);
        }
    }

    public static void switchMode(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() instanceof BuildingToolItem) {
            ClientPacketHandler.sendBuildingToolSwitchMode();
            BuildingToolItem.Mode currentMode = BuildingToolItem.getMode(stack);
            BuildingToolItem.Mode newMode = currentMode.next();
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.mode_switched").method_27692(class_124.field_1054).method_10852((class_2561)newMode.getDisplayName().method_27692(newMode.getColor())), true);
            }
        }
    }

    public static void handleKeyPress(class_1799 stack) {
        if (!stack.method_7960() && stack.method_7909() instanceof BuildingToolItem) {
            BuildingToolItem.Mode mode = BuildingToolItem.getMode(stack);
            if (mode == BuildingToolItem.Mode.SAVE) {
                BuildingToolClientHandler.handleSaveMode(stack);
            } else if (mode == BuildingToolItem.Mode.PLACE) {
                BuildingToolClientHandler.handlePlaceMode(stack);
            } else if (mode == BuildingToolItem.Mode.FILL) {
                BuildingToolClientHandler.handleFillMode(stack);
            }
        }
    }

    private static void handleSaveMode(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        BuildingToolItem.SaveState state = BuildingToolItem.getSaveState(stack);
        class_239 hitResult = player.method_5745(5.0, 0.0f, false);
        class_2338 pos = null;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            pos = ((class_3965)hitResult).method_17777();
        } else if (hitResult.method_17783() == class_239.class_240.field_1333) {
            pos = new class_2338((int)Math.floor(hitResult.method_17784().field_1352), (int)Math.floor(hitResult.method_17784().field_1351), (int)Math.floor(hitResult.method_17784().field_1350));
        }
        if (pos != null) {
            switch (state) {
                case NONE: {
                    ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_FIRST_POS, pos);
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_tool.set_first_pos", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1060), true);
                    break;
                }
                case FIRST_POS: {
                    ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_SECOND_POS, pos);
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_tool.set_second_pos", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1061), true);
                    break;
                }
                case SECOND_POS: {
                    ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_ENTRANCE_POS, pos);
                    player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_tool.set_entrance_pos", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1078), true);
                    break;
                }
                case READY_TO_SAVE: {
                    BuildingToolClientHandler.openSaveUI(stack);
                }
            }
        }
    }

    private static void handleFillMode(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        BuildingToolItem.FillState state = BuildingToolItem.getFillState(stack);
        class_239 hitResult = player.method_5745(5.0, 0.0f, false);
        class_2338 pos = null;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            pos = ((class_3965)hitResult).method_17777();
        } else if (hitResult.method_17783() == class_239.class_240.field_1333) {
            pos = new class_2338((int)Math.floor(hitResult.method_17784().field_1352), (int)Math.floor(hitResult.method_17784().field_1351), (int)Math.floor(hitResult.method_17784().field_1350));
        }
        if (pos == null) {
            return;
        }
        switch (state) {
            case NONE: {
                ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_FILL_FIRST_POS, pos);
                player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_tool.fill_set_first_pos", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1065), true);
                break;
            }
            case FIRST_POS: {
                ClientPacketHandler.sendBuildingToolSetPos(BuildingToolActionPacket.Action.SET_FILL_SECOND_POS, pos);
                player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_tool.fill_set_second_pos", (Object[])new Object[]{pos.method_23854()}).method_27692(class_124.field_1065), true);
                break;
            }
            case SECOND_POS: {
                BuildingToolClientHandler.openFillUI(stack);
            }
        }
    }

    private static void handleSaveUndo(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        BuildingToolItem.SaveState state = BuildingToolItem.getSaveState(stack);
        switch (state) {
            case NONE: {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.nothing_to_undo").method_27692(class_124.field_1054), true);
                break;
            }
            case FIRST_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_FIRST_POS);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.undo_first_pos").method_27692(class_124.field_1054), true);
                break;
            }
            case SECOND_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_SECOND_POS);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.undo_second_pos").method_27692(class_124.field_1054), true);
                break;
            }
            case READY_TO_SAVE: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_ENTRANCE_POS);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.undo_entrance_pos").method_27692(class_124.field_1054), true);
            }
        }
    }

    private static void handleFillUndoRightClick(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        BuildingToolItem.FillState state = BuildingToolItem.getFillState(stack);
        switch (state) {
            case NONE: {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.fill_nothing_to_undo").method_27692(class_124.field_1054), true);
                break;
            }
            case FIRST_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_FILL_FIRST_POS);
                BuildingToolItem.resetFillState(stack);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.fill_undo_first").method_27692(class_124.field_1054), true);
                break;
            }
            case SECOND_POS: {
                ClientPacketHandler.sendBuildingToolUndo(BuildingToolActionPacket.Action.UNDO_FILL_SECOND_POS);
                BuildingToolItem.setFillSecondPos(stack, null);
                BuildingToolItem.setFillState(stack, BuildingToolItem.FillState.FIRST_POS);
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.fill_undo_second").method_27692(class_124.field_1054), true);
            }
        }
    }

    private static void handlePlaceMode(class_1799 stack) {
        class_746 player = class_310.method_1551().field_1724;
        if (player == null) {
            return;
        }
        String selectedTemplateData = BuildingToolItem.getSelectedTemplate(stack);
        if (selectedTemplateData == null || selectedTemplateData.isEmpty()) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.building_tool.no_template_selected").method_27692(class_124.field_1061), true);
            return;
        }
        String[] parts = selectedTemplateData.split("\\|");
        String templateName = parts[0];
        int rotation = 0;
        long buildTime = 0L;
        boolean generateConnectionLayer = false;
        boolean terrainCheck = false;
        try {
            rotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
            buildTime = parts.length > 2 ? Long.parseLong(parts[2]) : 0L;
            generateConnectionLayer = parts.length > 3 && Boolean.parseBoolean(parts[3]);
            terrainCheck = parts.length > 4 && Boolean.parseBoolean(parts[4]);
        }
        catch (NumberFormatException numberFormatException) {
            // empty catch block
        }
        class_239 hitResult = player.method_5745(200.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            class_2338 pos = ((class_3965)hitResult).method_17777();
            ClientPacketHandler.sendBuildingToolPlaceBuilding(pos, templateName, rotation, buildTime, generateConnectionLayer, terrainCheck);
            player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.building_tool.placing_template", (Object[])new Object[]{templateName}).method_27692(class_124.field_1060), true);
        }
    }

    private static void openBuildingSelectionUI(class_1799 stack) {
        class_310 minecraft = class_310.method_1551();
        minecraft.execute(() -> minecraft.method_1507((class_437)new BuildingPlaceScreen(stack)));
    }

    private static void openSaveUI(class_1799 stack) {
        class_310 minecraft = class_310.method_1551();
        minecraft.execute(() -> minecraft.method_1507((class_437)new BuildingSaveScreen(stack)));
    }

    private static void openFillUI(class_1799 stack) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft != null) {
            minecraft.method_1507((class_437)new PlaceholderFillScreen(stack));
        }
    }
}

