/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import java.util.List;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_312;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_4184;
import net.minecraft.class_5250;
import net.minecraft.class_746;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.freecam.Freecam;
import ydmsama.hundred_years_war.client.item.CommandStaffHandler;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.utils.ClientCreativeModeSettings;
import ydmsama.hundred_years_war.client.utils.ClientRelationHelper;
import ydmsama.hundred_years_war.client.utils.TraceHelper;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_312.class})
public class CommandStaffMouseHandlerMixin {
    @Shadow
    @Final
    private class_310 field_1779;
    @Unique
    private static final int PICK_DISTANCE = 200;
    @Unique
    private static final long LONG_PRESS_THRESHOLD_MS = 500L;
    @Unique
    private static final double AREA_SELECT_RADIUS = 10.0;
    @Unique
    private long rightMousePressStartTime = 0L;
    @Unique
    private boolean rightMouseLongPressHandled = false;
    @Unique
    private class_239 lastHitResult = null;

    @Unique
    private boolean isLookingDown() {
        class_4184 camera = this.field_1779.field_1773.method_19418();
        return camera.method_19329() > 80.0f;
    }

    @Inject(method={"onPress"}, at={@At(value="HEAD")}, cancellable=true)
    private void onCommandStaffPress(long window, int button, int action, int mods, CallbackInfo ci) {
        if (this.field_1779.method_22683().method_4490() != window || this.field_1779.field_1724 == null || this.field_1779.field_1755 != null || Freecam.isEnabled()) {
            return;
        }
        class_1799 mainHandItem = this.field_1779.field_1724.method_6047();
        if (mainHandItem.method_7960() || !(mainHandItem.method_7909() instanceof CommandStaffItem)) {
            return;
        }
        UUID staffUUID = CommandStaffItem.getItemUUID(mainHandItem);
        if (button == 2 && action == 1) {
            this.field_1779.field_1724.method_6104(class_1268.field_5808);
            CommandStaffHandler handler = CommandStaffHandler.getInstance();
            String formationId = handler.toggleFormationMode();
            class_5250 message = class_2561.method_43471((String)"msg.hyw.formation_switched").method_10852((class_2561)class_2561.method_43471((String)("wheel.hundred_years_war.formation." + formationId)).method_27692(class_124.field_1054));
            this.field_1779.field_1724.method_7353((class_2561)message, true);
            ci.cancel();
        } else if (button == 0 && action == 1) {
            this.field_1779.field_1724.method_6104(class_1268.field_5808);
            this.handleLeftClick(staffUUID, mainHandItem);
            ci.cancel();
        } else if (button == 1) {
            if (action == 1) {
                this.rightMousePressStartTime = System.currentTimeMillis();
                this.rightMouseLongPressHandled = false;
                this.lastHitResult = this.performStaffRayTrace(mainHandItem);
                this.field_1779.field_1724.method_6104(class_1268.field_5808);
                ci.cancel();
            } else if (action == 0) {
                long pressDuration = System.currentTimeMillis() - this.rightMousePressStartTime;
                if (this.lastHitResult != null) {
                    if (pressDuration >= 500L) {
                        if (this.field_1779.field_1724.method_5715()) {
                            this.handleClearSelection(staffUUID, mainHandItem);
                        } else {
                            this.handleAreaSelection(staffUUID, mainHandItem, this.lastHitResult);
                        }
                    } else if (!this.rightMouseLongPressHandled) {
                        this.handleRightClick(staffUUID, mainHandItem, this.field_1779.field_1724.method_5715());
                    }
                }
                this.rightMousePressStartTime = 0L;
                this.rightMouseLongPressHandled = false;
                this.lastHitResult = null;
                ci.cancel();
            }
        }
    }

    @Unique
    private class_239 performStaffRayTrace(class_1799 staffItem) {
        return this.performStaffRayTrace(staffItem, false);
    }

    @Unique
    private class_239 performStaffRayTrace(class_1799 staffItem, boolean ignoreControlledEntities) {
        class_746 player = this.field_1779.field_1724;
        if (player == null) {
            return null;
        }
        class_4184 camera = this.field_1779.field_1773.method_19418();
        class_243 eyePos = camera.method_19326();
        class_243 lookVec = class_243.method_1030((float)camera.method_19329(), (float)camera.method_19330());
        class_243 targetPos = eyePos.method_1031(lookVec.field_1352 * 200.0, lookVec.field_1351 * 200.0, lookVec.field_1350 * 200.0);
        class_3965 blockResult = this.field_1779.field_1687.method_17742(new class_3959(eyePos, targetPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)player));
        double blockDistance = Double.MAX_VALUE;
        if (blockResult.method_17783() != class_239.class_240.field_1333) {
            blockDistance = eyePos.method_1025(blockResult.method_17784());
        }
        class_1297 closestEntity = null;
        class_243 closestHitPos = null;
        double closestDistance = Double.MAX_VALUE;
        class_238 searchBox = new class_238(eyePos.field_1352 - 200.0, eyePos.field_1351 - 200.0, eyePos.field_1350 - 200.0, eyePos.field_1352 + 200.0, eyePos.field_1351 + 200.0, eyePos.field_1350 + 200.0);
        List entities = this.field_1779.field_1687.method_8335((class_1297)player, searchBox);
        boolean isShiftDown = player.method_5715();
        for (class_1297 entity : entities) {
            double distance;
            class_238 entityBox;
            Optional hitPos;
            if (entity == player || !entity.method_5805() || !entity.method_5863() || ignoreControlledEntities && this.shouldIgnoreControlledEntity(entity) || !isShiftDown && entity instanceof BaseCombatEntity && this.isEntityInTeam(staffItem, entity.method_5667()) || !(hitPos = (entityBox = entity.method_5829().method_1014(0.3)).method_992(eyePos, targetPos)).isPresent() || !((distance = eyePos.method_1025((class_243)hitPos.get())) < closestDistance) || !(distance < blockDistance)) continue;
            closestEntity = entity;
            closestHitPos = (class_243)hitPos.get();
            closestDistance = distance;
        }
        if (closestEntity != null) {
            return new class_3966(closestEntity, closestHitPos);
        }
        if (blockResult.method_17783() != class_239.class_240.field_1333) {
            return blockResult;
        }
        class_2338 targetBlockPos = new class_2338((int)targetPos.field_1352, (int)targetPos.field_1351, (int)targetPos.field_1350);
        return class_3965.method_17778((class_243)targetPos, (class_2350)class_2350.method_10142((double)lookVec.field_1352, (double)lookVec.field_1351, (double)lookVec.field_1350), (class_2338)targetBlockPos);
    }

    @Unique
    private boolean shouldIgnoreControlledEntity(class_1297 entity) {
        if (entity instanceof BaseCombatEntity) {
            RelationSystem.RelationType relation = ClientRelationHelper.getInstance().getRelationWithPlayer(entity);
            return relation == RelationSystem.RelationType.CONTROL;
        }
        return false;
    }

    @Unique
    private boolean isEntityInTeam(class_1799 staffItem, UUID entityUUID) {
        class_2487 nbt = staffItem.method_7969();
        if (nbt != null && nbt.method_10573("TeamEntityUUIDs", 9)) {
            class_2499 uuidList = nbt.method_10554("TeamEntityUUIDs", 8);
            String entityUUIDString = entityUUID.toString();
            for (int i = 0; i < uuidList.size(); ++i) {
                if (!uuidList.method_10608(i).equals(entityUUIDString)) continue;
                return true;
            }
        }
        return false;
    }

    @Unique
    private void handleLeftClick(UUID staffUUID, class_1799 staffItem) {
        class_746 player = this.field_1779.field_1724;
        boolean ignoreControlledEntities = !player.method_7337() || !ClientCreativeModeSettings.canControlAllUnits();
        class_239 hitResult = this.performStaffRayTrace(staffItem, ignoreControlledEntities);
        if (hitResult == null) {
            return;
        }
        CommandStaffHandler handler = CommandStaffHandler.getInstance();
        boolean isFormationMode = handler.isFormationMode();
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            class_3966 entityHit = (class_3966)hitResult;
            class_1297 target = entityHit.method_17782();
            if (target instanceof class_1309) {
                handler.setAttackTargetEntity(target);
                ClientPacketHandler.sendCommandStaffAttackPacket(staffUUID, target.method_5667());
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.attack"), true);
            }
        } else if (hitResult.method_17783() == class_239.class_240.field_1332 || hitResult.method_17783() == class_239.class_240.field_1333) {
            class_3965 blockHit = (class_3965)hitResult;
            handler.setAttackMoveBlockPos(blockHit.method_17777());
            ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, blockHit.method_17777(), 3, isFormationMode);
            if (isFormationMode) {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.formation_move_attack"), true);
            } else {
                player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.move_attack"), true);
            }
        }
    }

    @Unique
    private void handleRightClick(UUID staffUUID, class_1799 staffItem, boolean isShiftDown) {
        class_239 originalHitResult = this.lastHitResult;
        if (originalHitResult == null) {
            return;
        }
        class_746 player = this.field_1779.field_1724;
        CommandStaffHandler handler = CommandStaffHandler.getInstance();
        boolean isFormationMode = handler.isFormationMode();
        if (this.isLookingDown()) {
            handler.clearRenderData();
            ClientPacketHandler.sendCommandStaffFollowPacket(staffUUID);
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.follow"), true);
            return;
        }
        if (isShiftDown) {
            if (originalHitResult.method_17783() == class_239.class_240.field_1331) {
                BaseCombatEntity baseCombatEntity;
                BaseCombatEntity entityToProcess;
                class_1297 targetEntity = ((class_3966)originalHitResult).method_17782();
                handler.setTargetEntity(targetEntity);
                if (targetEntity instanceof BaseCombatEntity && this.canPlayerControl((class_1657)player, entityToProcess = this.getActualEntity(baseCombatEntity = (BaseCombatEntity)targetEntity)) && this.isEntityInTeam(staffItem, entityToProcess.method_5667())) {
                    ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, entityToProcess.method_5667(), false);
                    return;
                }
            }
            class_2338 movePos = this.getBlockPosFromHitResult(originalHitResult);
            handler.setTargetBlockPos(movePos);
            ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, movePos, 1, isFormationMode);
            this.displayStandardMoveMessage((class_1657)player, isFormationMode);
            return;
        }
        if (originalHitResult.method_17783() == class_239.class_240.field_1331) {
            BaseCombatEntity baseCombatEntity;
            BaseCombatEntity entityToProcess;
            class_1297 targetEntity = ((class_3966)originalHitResult).method_17782();
            handler.setTargetEntity(targetEntity);
            if (targetEntity instanceof BaseCombatEntity && this.canPlayerControl((class_1657)player, entityToProcess = this.getActualEntity(baseCombatEntity = (BaseCombatEntity)targetEntity)) && !this.isEntityInTeam(staffItem, entityToProcess.method_5667())) {
                ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, entityToProcess.method_5667(), true);
                return;
            }
        }
        class_239 blockOnlyHit = TraceHelper.blockRayTrace(200.0);
        class_2338 movePos = this.getBlockPosFromHitResult(blockOnlyHit);
        handler.setTargetBlockPos(movePos);
        ClientPacketHandler.sendCommandStaffMovePacket(staffUUID, movePos, 1, isFormationMode);
        this.displayStandardMoveMessage((class_1657)player, isFormationMode);
    }

    @Unique
    private BaseCombatEntity getActualEntity(BaseCombatEntity entity) {
        class_1297 class_12972;
        if (entity.method_5854() != null && (class_12972 = entity.method_5854()) instanceof BaseCombatEntity) {
            BaseCombatEntity vehicle = (BaseCombatEntity)class_12972;
            return vehicle;
        }
        return entity;
    }

    @Unique
    private boolean canPlayerControl(class_1657 player, BaseCombatEntity entity) {
        return ClientRelationHelper.getInstance().getRelationWithPlayer((class_1297)entity) == RelationSystem.RelationType.CONTROL || player.method_7337() && ClientCreativeModeSettings.canControlAllUnits();
    }

    @Unique
    private class_2338 getBlockPosFromHitResult(class_239 hitResult) {
        if (hitResult.method_17783() == class_239.class_240.field_1331) {
            return ((class_3966)hitResult).method_17782().method_24515();
        }
        return ((class_3965)hitResult).method_17777();
    }

    @Unique
    private void displayStandardMoveMessage(class_1657 player, boolean isFormationMode) {
        if (isFormationMode) {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.formation_move"), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43471((String)"message.hundred_years_war.command_staff.move"), true);
        }
    }

    @Inject(method={"turnPlayer"}, at={@At(value="HEAD")})
    private void onCommandStaffTurnPlayer(CallbackInfo ci) {
        if (this.rightMousePressStartTime > 0L && !this.rightMouseLongPressHandled) {
            class_746 player = this.field_1779.field_1724;
            if (player == null || this.field_1779.field_1755 != null || player.method_6047().method_7960() || !(player.method_6047().method_7909() instanceof CommandStaffItem)) {
                this.rightMousePressStartTime = 0L;
                this.rightMouseLongPressHandled = false;
                this.lastHitResult = null;
                return;
            }
            long pressDuration = System.currentTimeMillis() - this.rightMousePressStartTime;
            if (pressDuration >= 500L) {
                this.rightMouseLongPressHandled = true;
                class_1799 mainHandItem = player.method_6047();
                UUID staffUUID = CommandStaffItem.getItemUUID(mainHandItem);
                if (player.method_5715()) {
                    this.handleClearSelection(staffUUID, mainHandItem);
                } else if (this.lastHitResult != null) {
                    this.handleAreaSelection(staffUUID, mainHandItem, this.lastHitResult);
                }
            }
        }
    }

    @Unique
    private void handleAreaSelection(UUID staffUUID, class_1799 staffItem, class_239 hitResult) {
        class_746 player = this.field_1779.field_1724;
        if (player == null || hitResult == null) {
            return;
        }
        class_243 centerPos = hitResult.method_17783() == class_239.class_240.field_1331 ? ((class_3966)hitResult).method_17782().method_19538() : hitResult.method_17784();
        int selectionCount = 0;
        class_238 searchBox = new class_238(centerPos.field_1352 - 10.0, centerPos.field_1351 - 10.0, centerPos.field_1350 - 10.0, centerPos.field_1352 + 10.0, centerPos.field_1351 + 10.0, centerPos.field_1350 + 10.0);
        List entities = this.field_1779.field_1687.method_8335((class_1297)player, searchBox);
        for (class_1297 entity : entities) {
            boolean isInTeam;
            class_1297 class_12972;
            if (!(entity instanceof BaseCombatEntity)) continue;
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)entity;
            if (baseCombatEntity.method_5854() != null && (class_12972 = baseCombatEntity.method_5854()) instanceof BaseCombatEntity) {
                BaseCombatEntity vehicle;
                baseCombatEntity = vehicle = (BaseCombatEntity)class_12972;
            }
            if (ClientRelationHelper.getInstance().getRelationWithPlayer((class_1297)baseCombatEntity) != RelationSystem.RelationType.CONTROL && (!player.method_7337() || !ClientCreativeModeSettings.canControlAllUnits()) || (isInTeam = this.isEntityInTeam(staffItem, baseCombatEntity.method_5667()))) continue;
            ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, baseCombatEntity.method_5667(), true);
            ++selectionCount;
        }
        if (selectionCount > 0) {
            player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.command_staff.area_selection", (Object[])new Object[]{selectionCount}), true);
        }
    }

    @Unique
    private void handleClearSelection(UUID staffUUID, class_1799 staffItem) {
        class_746 player = this.field_1779.field_1724;
        if (player == null) {
            return;
        }
        class_2487 nbt = staffItem.method_7969();
        if (nbt != null && nbt.method_10573("TeamEntityUUIDs", 9)) {
            class_2499 uuidList = nbt.method_10554("TeamEntityUUIDs", 8);
            int entityCount = uuidList.size();
            for (int i = 0; i < uuidList.size(); ++i) {
                String uuidString = uuidList.method_10608(i);
                try {
                    UUID entityUUID = UUID.fromString(uuidString);
                    ClientPacketHandler.sendCommandStaffAddEntityPacket(staffUUID, entityUUID, false);
                    continue;
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (entityCount > 0) {
                player.method_7353((class_2561)class_2561.method_43469((String)"message.hundred_years_war.command_staff.clear_selection", (Object[])new Object[]{entityCount}), true);
            }
        }
    }
}

