/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_572;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_572.class})
public class HumanoidModelMixin {
    private boolean originalRidingState = false;
    private boolean ridingStateModified = false;

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="HEAD")})
    private void onSetupAnimStart(class_1309 livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        class_572 self = (class_572)this;
        this.originalRidingState = self.field_3449;
        this.ridingStateModified = false;
        if (this.shouldUseStandingPose(livingEntity)) {
            self.field_3449 = false;
            this.ridingStateModified = true;
        }
    }

    @Inject(method={"setupAnim(Lnet/minecraft/world/entity/LivingEntity;FFFFF)V"}, at={@At(value="RETURN")})
    private void onSetupAnimEnd(class_1309 livingEntity, float f, float g, float h, float i, float j, CallbackInfo ci) {
        if (this.ridingStateModified) {
            ((class_572)this).field_3449 = this.originalRidingState;
        }
    }

    private boolean shouldUseStandingPose(class_1309 livingEntity) {
        class_1297 vehicle = livingEntity.method_5854();
        if (vehicle instanceof MultiSeatVehicle) {
            MultiSeatVehicle multiSeatVehicle = (MultiSeatVehicle)vehicle;
            MultiSeatVehicle.SeatPose pose = multiSeatVehicle.getSeatForEntity((class_1297)livingEntity).map(MultiSeatVehicle.Seat::getPose).orElse(MultiSeatVehicle.SeatPose.SITTING);
            return pose == MultiSeatVehicle.SeatPose.STANDING;
        }
        return false;
    }
}

