/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.mixins;

import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1058;
import net.minecraft.class_1087;
import net.minecraft.class_1799;
import net.minecraft.class_2350;
import net.minecraft.class_310;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5819;
import net.minecraft.class_777;
import net.minecraft.class_918;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import ydmsama.hundred_years_war.client.utils.RenderingEntityTracker;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;

@Environment(value=EnvType.CLIENT)
@Mixin(value={class_918.class})
public abstract class ItemRendererMixin {
    @Shadow
    private class_310 field_42073;
    @Unique
    private static final float DISTANCE_THRESHOLD_SQ = 225.0f;
    @Unique
    private final Map<class_777, class_777> flippedQuadCache = new WeakHashMap<class_777, class_777>();

    @Shadow
    protected abstract void method_23180(class_4587 var1, class_4588 var2, List<class_777> var3, class_1799 var4, int var5, int var6);

    @Unique
    private class_777 createFlippedQuad(class_777 orig) {
        class_777 cached = this.flippedQuadCache.get(orig);
        if (cached != null) {
            return cached;
        }
        int[] vertices = orig.method_3357();
        int stride = vertices.length / 4;
        int[] flipped = new int[vertices.length];
        for (int i = 0; i < 4; ++i) {
            System.arraycopy(vertices, (3 - i) * stride, flipped, i * stride, stride);
        }
        class_2350 face = orig.method_3358();
        class_2350 flippedFace = face == null ? null : face.method_10153();
        class_1058 sprite = orig.method_35788();
        int tint = orig.method_3359();
        boolean shade = orig.method_24874();
        class_777 newQuad = new class_777(flipped, tint, flippedFace, sprite, shade);
        this.flippedQuadCache.put(orig, newQuad);
        return newQuad;
    }

    @Unique
    private boolean shouldOptimizeRendering() {
        if (this.field_42073 == null || this.field_42073.field_1724 == null || this.field_42073.field_1719 == null) {
            return false;
        }
        if (RenderingEntityTracker.isOptimizationSuppressed()) {
            return false;
        }
        Object renderingEntity = RenderingEntityTracker.getCurrentRenderingEntity();
        if (renderingEntity instanceof BaseCombatEntity) {
            double dz;
            double dy;
            BaseCombatEntity combatEntity = (BaseCombatEntity)renderingEntity;
            double dx = combatEntity.method_23317() - this.field_42073.field_1719.method_23317();
            double distanceSq = dx * dx + (dy = combatEntity.method_23318() - this.field_42073.field_1719.method_23318()) * dy + (dz = combatEntity.method_23321() - this.field_42073.field_1719.method_23321()) * dz;
            return distanceSq > 225.0;
        }
        return false;
    }

    @Inject(method={"renderQuadList"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeQuadRendering(class_4587 poseStack, class_4588 vertexConsumer, List<class_777> list, class_1799 itemStack, int lightColor, int overlayColor, CallbackInfo ci) {
        if (!this.shouldOptimizeRendering()) {
            return;
        }
        if (!list.isEmpty()) {
            class_4587.class_4665 pose = poseStack.method_23760();
            class_777 mainQuad = list.get(0);
            float r = 1.0f;
            float g = 1.0f;
            float b = 1.0f;
            vertexConsumer.method_22919(pose, mainQuad, r, g, b, lightColor, overlayColor);
            class_777 flipped = this.createFlippedQuad(mainQuad);
            vertexConsumer.method_22919(pose, flipped, r, g, b, lightColor, overlayColor);
            ci.cancel();
        }
    }

    @Inject(method={"renderModelLists"}, at={@At(value="HEAD")}, cancellable=true)
    private void optimizeDirectionalRendering(class_1087 bakedModel, class_1799 itemStack, int lightColor, int overlayColor, class_4587 poseStack, class_4588 vertexConsumer, CallbackInfo ci) {
        if (!this.shouldOptimizeRendering()) {
            return;
        }
        class_5819 randomSource = class_5819.method_43047();
        long seed = 42L;
        randomSource.method_43052(seed);
        List generalQuads = bakedModel.method_4707(null, null, randomSource);
        if (!generalQuads.isEmpty()) {
            this.method_23180(poseStack, vertexConsumer, generalQuads, itemStack, lightColor, overlayColor);
        }
        ci.cancel();
    }
}

