/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.render;

import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.client.rendering.v1.WorldRenderEvents;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1921;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3965;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_761;
import ydmsama.hundred_years_war.client.render.BuildingPreviewRenderer;
import ydmsama.hundred_years_war.client.render.PlacedBuildingRenderer;
import ydmsama.hundred_years_war.main.blocks.ModBlocks;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;

@Environment(value=EnvType.CLIENT)
public class BuildingToolRenderer {
    public static void register() {
        WorldRenderEvents.AFTER_TRANSLUCENT.register(context -> BuildingToolRenderer.render(context.matrixStack(), context.consumers(), context.tickDelta()));
    }

    private static void render(class_4587 poseStack, class_4597 bufferSource, float tickDelta) {
        boolean holdingSpawnPoint;
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1724 == null || minecraft.field_1687 == null) {
            return;
        }
        class_243 cameraPos = minecraft.field_1773.method_19418().method_19326();
        PlacedBuildingRenderer.getInstance().renderBuildings(poseStack, bufferSource, cameraPos);
        class_1799 mainHand = minecraft.field_1724.method_6047();
        class_1799 offHand = minecraft.field_1724.method_6079();
        boolean holdingBuildingTool = mainHand.method_7909() instanceof BuildingToolItem;
        boolean holdingPlaceholder = mainHand.method_31574(ModBlocks.PLACEHOLDER_BLOCK.method_8389()) || offHand.method_31574(ModBlocks.PLACEHOLDER_BLOCK.method_8389());
        boolean bl = holdingSpawnPoint = mainHand.method_31574(ModBlocks.SPAWN_POINT.method_8389()) || offHand.method_31574(ModBlocks.SPAWN_POINT.method_8389());
        if (holdingBuildingTool) {
            BuildingToolItem.Mode mode = BuildingToolItem.getMode(mainHand);
            if (mode == BuildingToolItem.Mode.SAVE) {
                BuildingToolRenderer.renderSaveMode(poseStack, bufferSource, mainHand, (class_1657)minecraft.field_1724, cameraPos);
            } else if (mode == BuildingToolItem.Mode.PLACE) {
                BuildingToolRenderer.renderPlaceMode(poseStack, bufferSource, mainHand, (class_1657)minecraft.field_1724, cameraPos);
            } else if (mode == BuildingToolItem.Mode.FILL) {
                BuildingToolRenderer.renderFillMode(poseStack, bufferSource, mainHand, (class_1657)minecraft.field_1724, cameraPos);
            }
        }
        if (holdingBuildingTool || holdingPlaceholder) {
            BuildingToolRenderer.renderPlaceholderMarkers(poseStack, bufferSource, (class_1657)minecraft.field_1724, cameraPos, holdingBuildingTool);
        }
        if (bufferSource instanceof class_4597.class_4598) {
            ((class_4597.class_4598)bufferSource).method_22993();
        }
    }

    private static void renderFillMode(class_4587 poseStack, class_4597 bufferSource, class_1799 stack, class_1657 player, class_243 cameraPos) {
        BuildingToolItem.FillState state = BuildingToolItem.getFillState(stack);
        class_239 hitResult = player.method_5745(5.0, 0.0f, false);
        class_2338 currentPos = null;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            currentPos = ((class_3965)hitResult).method_17777();
        } else if (hitResult.method_17783() == class_239.class_240.field_1333) {
            currentPos = new class_2338((int)Math.floor(hitResult.method_17784().field_1352), (int)Math.floor(hitResult.method_17784().field_1351), (int)Math.floor(hitResult.method_17784().field_1350));
        }
        class_2338 firstPos = BuildingToolItem.getFillFirstPos(stack);
        class_2338 secondPos = BuildingToolItem.getFillSecondPos(stack);
        switch (state) {
            case NONE: {
                if (currentPos == null) break;
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                break;
            }
            case FIRST_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                }
                if (currentPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 1.0f, 0.6f, 0.0f, 1.0f);
                }
                if (firstPos == null || currentPos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, currentPos, cameraPos, 1.0f, 1.0f, 0.0f, 0.6f);
                break;
            }
            case SECOND_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                }
                if (secondPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, secondPos, cameraPos, 1.0f, 1.0f, 0.0f, 1.0f);
                }
                if (firstPos == null || secondPos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, secondPos, cameraPos, 1.0f, 1.0f, 0.0f, 0.6f);
            }
        }
    }

    private static void renderPlaceholderMarkers(class_4587 poseStack, class_4597 bufferSource, class_1657 player, class_243 cameraPos, boolean holdingBuildingTool) {
        class_310 minecraft = class_310.method_1551();
        if (minecraft.field_1687 == null) {
            return;
        }
        int radius = holdingBuildingTool ? 16 : 12;
        class_2338 center = player.method_24515();
        class_2338.class_2339 mutablePos = new class_2338.class_2339();
        boolean rendered = false;
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        for (int x = -radius; x <= radius; ++x) {
            for (int y = -radius; y <= radius; ++y) {
                for (int z = -radius; z <= radius; ++z) {
                    mutablePos.method_10103(center.method_10263() + x, center.method_10264() + y, center.method_10260() + z);
                    if (!minecraft.field_1687.method_8320((class_2338)mutablePos).method_27852(ModBlocks.PLACEHOLDER_BLOCK)) continue;
                    rendered = true;
                    double minX = (double)mutablePos.method_10263() + 0.35;
                    double minY = (double)mutablePos.method_10264() + 0.35;
                    double minZ = (double)mutablePos.method_10260() + 0.35;
                    double maxX = (double)mutablePos.method_10263() + 0.65;
                    double maxY = (double)mutablePos.method_10264() + 0.65;
                    double maxZ = (double)mutablePos.method_10260() + 0.65;
                    class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ, (float)1.0f, (float)1.0f, (float)1.0f, (float)0.85f);
                }
            }
        }
        poseStack.method_22909();
    }

    private static void renderSaveMode(class_4587 poseStack, class_4597 bufferSource, class_1799 stack, class_1657 player, class_243 cameraPos) {
        BuildingToolItem.SaveState state = BuildingToolItem.getSaveState(stack);
        class_239 hitResult = player.method_5745(5.0, 0.0f, false);
        class_2338 currentPos = null;
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            currentPos = ((class_3965)hitResult).method_17777();
        } else if (hitResult.method_17783() == class_239.class_240.field_1333) {
            currentPos = new class_2338((int)Math.floor(hitResult.method_17784().field_1352), (int)Math.floor(hitResult.method_17784().field_1351), (int)Math.floor(hitResult.method_17784().field_1350));
        }
        class_2338 firstPos = BuildingToolItem.getFirstPos(stack);
        class_2338 secondPos = BuildingToolItem.getSecondPos(stack);
        class_2338 entrancePos = BuildingToolItem.getEntrancePos(stack);
        switch (state) {
            case NONE: {
                if (currentPos == null) break;
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
                break;
            }
            case FIRST_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (currentPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (firstPos == null || currentPos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, currentPos, cameraPos, 1.0f, 1.0f, 1.0f, 0.8f);
                break;
            }
            case SECOND_POS: {
                if (firstPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, firstPos, cameraPos, 0.0f, 1.0f, 0.0f, 1.0f);
                }
                if (secondPos != null) {
                    BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, secondPos, cameraPos, 1.0f, 0.0f, 0.0f, 1.0f);
                }
                if (firstPos != null && secondPos != null) {
                    BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, secondPos, cameraPos, 1.0f, 1.0f, 1.0f, 0.8f);
                }
                if (currentPos == null) break;
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, currentPos, cameraPos, 0.0f, 0.0f, 1.0f, 1.0f);
                break;
            }
            case READY_TO_SAVE: {
                if (firstPos == null || secondPos == null || entrancePos == null) break;
                BuildingToolRenderer.renderSelectionBox(poseStack, bufferSource, firstPos, secondPos, cameraPos, 1.0f, 1.0f, 1.0f, 0.8f);
                BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, entrancePos, cameraPos, 0.0f, 0.0f, 1.0f, 1.0f);
            }
        }
    }

    private static void renderPlaceMode(class_4587 poseStack, class_4597 bufferSource, class_1799 stack, class_1657 player, class_243 cameraPos) {
        String selectedTemplateData = BuildingToolItem.getSelectedTemplate(stack);
        class_239 hitResult = player.method_5745(200.0, 0.0f, false);
        if (hitResult.method_17783() == class_239.class_240.field_1332) {
            String[] parts;
            class_2338 pos = ((class_3965)hitResult).method_17777();
            BuildingToolRenderer.renderBlockOutline(poseStack, bufferSource, pos, cameraPos, 0.0f, 0.0f, 1.0f, 1.0f);
            if (selectedTemplateData != null && !selectedTemplateData.isEmpty() && (parts = selectedTemplateData.split("\\|")).length > 0) {
                String templateId = parts[0];
                int rotation = parts.length > 1 ? Integer.parseInt(parts[1]) : 0;
                boolean mirror = parts.length > 2 && Boolean.parseBoolean(parts[2]);
                BuildingPreviewRenderer.setTemplate(templateId);
                BuildingPreviewRenderer.setPreviewPosition(pos);
                BuildingPreviewRenderer.setRotation(rotation);
                BuildingPreviewRenderer.render(poseStack, bufferSource, cameraPos);
            }
        } else {
            BuildingPreviewRenderer.setTemplate(null);
        }
    }

    private static void renderBlockOutline(class_4587 poseStack, class_4597 bufferSource, class_2338 pos, class_243 cameraPos, float r, float g, float b, float a) {
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        class_238 box = new class_238(pos).method_1014(0.002);
        class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)r, (float)g, (float)b, (float)a);
        poseStack.method_22909();
    }

    private static void renderSelectionBox(class_4587 poseStack, class_4597 bufferSource, class_2338 pos1, class_2338 pos2, class_243 cameraPos, float r, float g, float b, float a) {
        int y;
        int z;
        int x;
        class_4588 consumer = bufferSource.getBuffer(class_1921.method_23594());
        poseStack.method_22903();
        poseStack.method_22904(-cameraPos.field_1352, -cameraPos.field_1351, -cameraPos.field_1350);
        int minX = Math.min(pos1.method_10263(), pos2.method_10263());
        int maxX = Math.max(pos1.method_10263(), pos2.method_10263()) + 1;
        int minY = Math.min(pos1.method_10264(), pos2.method_10264());
        int maxY = Math.max(pos1.method_10264(), pos2.method_10264()) + 1;
        int minZ = Math.min(pos1.method_10260(), pos2.method_10260());
        int maxZ = Math.max(pos1.method_10260(), pos2.method_10260()) + 1;
        class_238 box = new class_238((double)minX, (double)minY, (double)minZ, (double)maxX, (double)maxY, (double)maxZ).method_1014(0.002);
        class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)box.field_1323, (double)box.field_1322, (double)box.field_1321, (double)box.field_1320, (double)box.field_1325, (double)box.field_1324, (float)r, (float)g, (float)b, (float)a);
        float gridAlpha = a * 0.3f;
        int gridSpacing = 2;
        for (x = minX + gridSpacing; x < maxX; x += gridSpacing) {
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)x, (double)minY, (double)minZ, (double)x, (double)minY, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)x, (double)maxY, (double)minZ, (double)x, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = minZ + gridSpacing; z < maxZ; z += gridSpacing) {
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)minY, (double)z, (double)maxX, (double)minY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)maxY, (double)z, (double)maxX, (double)maxY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (y = minY + gridSpacing; y < maxY; y += gridSpacing) {
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)y, (double)minZ, (double)minX, (double)y, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)maxX, (double)y, (double)minZ, (double)maxX, (double)y, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (z = minZ + gridSpacing; z < maxZ; z += gridSpacing) {
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)minY, (double)z, (double)minX, (double)maxY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)maxX, (double)minY, (double)z, (double)maxX, (double)maxY, (double)z, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (y = minY + gridSpacing; y < maxY; y += gridSpacing) {
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)y, (double)minZ, (double)maxX, (double)y, (double)minZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)minX, (double)y, (double)maxZ, (double)maxX, (double)y, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        for (x = minX + gridSpacing; x < maxX; x += gridSpacing) {
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)x, (double)minY, (double)minZ, (double)x, (double)maxY, (double)minZ, (float)r, (float)g, (float)b, (float)gridAlpha);
            class_761.method_22980((class_4587)poseStack, (class_4588)consumer, (double)x, (double)minY, (double)maxZ, (double)x, (double)maxY, (double)maxZ, (float)r, (float)g, (float)b, (float)gridAlpha);
        }
        poseStack.method_22909();
    }
}

