/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1299;
import net.minecraft.class_1311;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7923;
import ydmsama.hundred_years_war.client.screen.SpawnPointScreen;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

@Environment(value=EnvType.CLIENT)
public class EntitySelectionScreen
extends class_437 {
    private final SpawnPointScreen parent;
    private final int entryIndex;
    private final SpawnPointBlockEntity.SpawnEntry existingEntry;
    private class_342 searchBox;
    private class_4185 confirmButton;
    private class_4185 cancelButton;
    private class_2960 selectedEntityId;
    private final List<class_2960> allEntities = new ArrayList<class_2960>();
    private final List<class_2960> filteredEntities = new ArrayList<class_2960>();
    private int scrollOffset = 0;
    private int maxScroll = 0;
    private boolean isScrolling = false;
    private static final int WINDOW_WIDTH = 300;
    private static final int WINDOW_HEIGHT = 200;
    private static final int LIST_WIDTH = 260;
    private static final int LIST_HEIGHT = 130;
    private static final int ENTRY_HEIGHT = 24;
    private static final int SCROLL_BAR_WIDTH = 6;

    public EntitySelectionScreen(SpawnPointScreen parent, int entryIndex, SpawnPointBlockEntity.SpawnEntry existingEntry) {
        super((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.select_entity"));
        this.parent = parent;
        this.entryIndex = entryIndex;
        this.existingEntry = existingEntry;
        this.selectedEntityId = existingEntry != null ? existingEntry.entityId() : new class_2960("minecraft", "zombie");
        this.loadEntities();
    }

    private void loadEntities() {
        for (class_1299 entityType : class_7923.field_41177) {
            class_2960 id = class_7923.field_41177.method_10221((Object)entityType);
            if (id == null || entityType.method_5891() != class_1311.field_6294 && entityType.method_5891() != class_1311.field_6302 && entityType.method_5891() != class_1311.field_6303 && entityType.method_5891() != class_1311.field_34447 && entityType.method_5891() != class_1311.field_30092 && entityType.method_5891() != class_1311.field_6300 && entityType.method_5891() != class_1311.field_24460) continue;
            this.allEntities.add(id);
        }
        this.allEntities.sort((a, b) -> a.toString().compareTo(b.toString()));
        this.filteredEntities.addAll(this.allEntities);
        this.calculateMaxScroll();
    }

    protected void method_25426() {
        super.method_25426();
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        this.searchBox = new class_342(this.field_22793, startX + 20, startY + 5, 240, 16, (class_2561)class_2561.method_43471((String)"gui.hundred_years_war.spawn_point.search"));
        this.searchBox.method_47404((class_2561)class_2561.method_43470((String)"Enter entity name..."));
        this.searchBox.method_1863(this::onSearchChanged);
        this.method_37063((class_364)this.searchBox);
        this.confirmButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Confirm"), button -> this.confirm()).method_46433(startX + 300 - 110, startY + 200 - 25).method_46437(50, 20).method_46431();
        this.method_37063((class_364)this.confirmButton);
        this.cancelButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)"Cancel"), button -> this.method_25419()).method_46433(startX + 300 - 55, startY + 200 - 25).method_46437(50, 20).method_46431();
        this.method_37063((class_364)this.cancelButton);
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float partialTick) {
        this.method_25420(graphics);
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        graphics.method_25294(startX, startY, startX + 300, startY + 200, -533712848);
        graphics.method_25294(startX + 1, startY + 1, startX + 300 - 1, startY + 200 - 1, -535818224);
        int listX = startX + 20;
        int listY = startY + 25;
        graphics.method_25294(listX, listY, listX + 260, listY + 130, -14671840);
        graphics.method_25294(listX + 1, listY + 1, listX + 260 - 1, listY + 130 - 1, -16777216);
        int scrollBarX = listX + 260 - 6 - 2;
        graphics.method_25294(scrollBarX, listY + 2, scrollBarX + 6, listY + 130 - 2, -12566464);
        if (this.maxScroll > 0) {
            int totalHeight = this.filteredEntities.size() * 24;
            int scrollBarHeight = Math.max(10, (int)(130.0f / (float)totalHeight * 130.0f));
            int scrollBarY = listY + 2 + (int)((float)this.scrollOffset / (float)this.maxScroll * (float)(126 - scrollBarHeight));
            graphics.method_25294(scrollBarX, scrollBarY, scrollBarX + 6, scrollBarY + scrollBarHeight, -8355712);
        }
        graphics.method_44379(listX + 2, listY + 2, listX + 260 - 6 - 4, listY + 130 - 2);
        int currentY = listY + 2 - this.scrollOffset;
        for (class_2960 entityId : this.filteredEntities) {
            if (currentY + 24 > listY && currentY < listY + 130) {
                boolean hover;
                boolean isSelected = this.selectedEntityId != null && this.selectedEntityId.equals((Object)entityId);
                boolean bl = hover = mouseX >= listX + 2 && mouseX <= listX + 260 - 6 - 4 && mouseY >= currentY && mouseY <= currentY + 24;
                int bgColor = isSelected ? -11513776 : (hover ? -13290187 : -14342875);
                graphics.method_25294(listX + 2, currentY, listX + 260 - 6 - 4, currentY + 24, bgColor);
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
                class_2561 displayName = entityType != null ? entityType.method_5897() : class_2561.method_43470((String)entityId.toString());
                int nameColor = isSelected ? 65280 : 0xFFFFFF;
                graphics.method_27535(this.field_22793, displayName, listX + 5, currentY + 2, nameColor);
                int idColor = isSelected ? 43520 : 0xAAAAAA;
                graphics.method_25303(this.field_22793, entityId.toString(), listX + 5, currentY + 13, idColor);
            }
            currentY += 24;
        }
        graphics.method_44380();
        super.method_25394(graphics, mouseX, mouseY, partialTick);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int scrollBarX;
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        int listX = startX + 20;
        int listY = startY + 25;
        if (mouseX >= (double)(listX + 2) && mouseX <= (double)(listX + 260 - 6 - 4) && mouseY >= (double)(listY + 2) && mouseY <= (double)(listY + 130 - 2)) {
            int currentY = listY + 2 - this.scrollOffset;
            for (class_2960 entityId : this.filteredEntities) {
                if (mouseY >= (double)currentY && mouseY <= (double)(currentY + 24)) {
                    this.selectedEntityId = entityId;
                    return true;
                }
                currentY += 24;
            }
        }
        if (mouseX >= (double)(scrollBarX = listX + 260 - 6 - 2) && mouseX <= (double)(scrollBarX + 6) && mouseY >= (double)listY && mouseY <= (double)(listY + 130)) {
            this.isScrolling = true;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling && this.maxScroll > 0) {
            int centerX = this.field_22789 / 2;
            int centerY = this.field_22790 / 2;
            int startX = centerX - 150;
            int startY = centerY - 100;
            int listX = startX + 20;
            int listY = startY + 25;
            int totalHeight = this.filteredEntities.size() * 24;
            int scrollBarHeight = Math.max(10, (int)(130.0f / (float)totalHeight * 130.0f));
            int usableScrollSpace = 126 - scrollBarHeight;
            int relativeY = (int)(mouseY - (double)listY - 2.0 - (double)(scrollBarHeight / 2));
            if (usableScrollSpace > 0) {
                this.scrollOffset = (int)Math.max(0.0f, Math.min((float)this.maxScroll, (float)relativeY / (float)usableScrollSpace * (float)this.maxScroll));
            }
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        int centerX = this.field_22789 / 2;
        int centerY = this.field_22790 / 2;
        int startX = centerX - 150;
        int startY = centerY - 100;
        int listX = startX + 20;
        int listY = startY + 25;
        if (mouseX >= (double)listX && mouseX <= (double)(listX + 260) && mouseY >= (double)listY && mouseY <= (double)(listY + 130)) {
            this.scrollOffset = (int)Math.max(0.0, Math.min((double)this.maxScroll, (double)this.scrollOffset - delta * 10.0));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void onSearchChanged(String search) {
        this.filteredEntities.clear();
        String searchLower = search.toLowerCase();
        if (searchLower.isEmpty()) {
            this.filteredEntities.addAll(this.allEntities);
        } else {
            for (class_2960 entityId : this.allEntities) {
                if (entityId.toString().toLowerCase().contains(searchLower)) {
                    this.filteredEntities.add(entityId);
                    continue;
                }
                class_1299 entityType = (class_1299)class_7923.field_41177.method_10223(entityId);
                if (entityType == null) continue;
                String translationKey = entityType.method_5882().toLowerCase();
                if (translationKey.contains(searchLower)) {
                    this.filteredEntities.add(entityId);
                    continue;
                }
                String displayName = entityType.method_5897().getString().toLowerCase();
                if (!displayName.contains(searchLower)) continue;
                this.filteredEntities.add(entityId);
            }
        }
        this.calculateMaxScroll();
        this.scrollOffset = 0;
    }

    private void calculateMaxScroll() {
        int totalHeight = this.filteredEntities.size() * 24;
        this.maxScroll = Math.max(0, totalHeight - 130);
    }

    private void confirm() {
        this.parent.updateEntityEntry(this.entryIndex, this.selectedEntityId);
        this.method_25419();
    }

    public void method_25419() {
        if (this.field_22787 != null) {
            this.field_22787.method_1507((class_437)this.parent);
        }
    }

    public boolean method_25421() {
        return false;
    }
}

