/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.client.screen;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2561;
import net.minecraft.class_332;
import net.minecraft.class_342;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_465;
import ydmsama.hundred_years_war.client.network.ClientPacketHandler;
import ydmsama.hundred_years_war.client.screen.WarehouseControlRangeScreen;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;

@Environment(value=EnvType.CLIENT)
public class WarehouseControlScreen
extends class_465<WarehouseControlScreenHandler> {
    private class_342 searchBox;
    private class_4185 sortButton;
    private class_4185 orderButton;
    private class_4185 rangeButton;
    private float scrollOffset = 0.0f;
    private boolean isScrolling = false;
    private int scrollMouseY = 0;
    private static final int ITEMS_PER_ROW = 9;
    private static final int VISIBLE_ROWS = 5;
    private static final int ITEM_SIZE = 18;
    private List<class_1799> filteredItems = new ArrayList<class_1799>();
    private String lastSearchText = "";
    private boolean justClickedWarehouseItem = false;

    public WarehouseControlScreen(WarehouseControlScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
        this.field_2792 = 195;
        this.field_2779 = 256;
        this.field_25270 = this.field_2779 - 94;
    }

    protected void method_25426() {
        super.method_25426();
        this.searchBox = new class_342(this.field_22793, this.field_2776 + 8, this.field_2800 + 20, 110, 12, (class_2561)class_2561.method_43470((String)""));
        this.searchBox.method_1880(50);
        this.searchBox.method_1858(false);
        this.searchBox.method_1868(0xFFFFFF);
        this.searchBox.method_1863(text -> this.updateFilteredItems());
        this.method_37063((class_364)this.searchBox);
        this.sortButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)("gui.hundred_years_war.warehouse.sort." + this.getCurrentSortType())), button -> {
            ClientPacketHandler.sendWarehouseSortChange(((WarehouseControlScreenHandler)this.field_2797).getBlockPos(), true, false);
            this.updateSortButton();
        }).method_46433(this.field_2776 + 122, this.field_2800 + 18).method_46437(50, 16).method_46431();
        this.method_37063((class_364)this.sortButton);
        this.orderButton = class_4185.method_46430((class_2561)class_2561.method_43470((String)(this.isAscending() ? "\u25b2" : "\u25bc")), button -> {
            ClientPacketHandler.sendWarehouseSortChange(((WarehouseControlScreenHandler)this.field_2797).getBlockPos(), false, true);
            this.updateOrderButton();
        }).method_46433(this.field_2776 + 174, this.field_2800 + 18).method_46437(16, 16).method_46431();
        this.method_37063((class_364)this.orderButton);
        this.rangeButton = class_4185.method_46430((class_2561)class_2561.method_43471((String)"gui.hundred_years_war.warehouse.range"), button -> {
            if (((WarehouseControlScreenHandler)this.field_2797).getBlockEntity() != null) {
                this.field_22787.method_1507((class_437)new WarehouseControlRangeScreen(((WarehouseControlScreenHandler)this.field_2797).getBlockEntity()));
            }
        }).method_46433(this.field_2776 + 60, this.field_2800 + 152).method_46437(60, 16).method_46431();
        this.method_37063((class_364)this.rangeButton);
        this.updateFilteredItems();
    }

    public void method_25394(class_332 graphics, int mouseX, int mouseY, float delta) {
        int itemIndex;
        this.method_25420(graphics);
        super.method_25394(graphics, mouseX, mouseY, delta);
        this.method_2380(graphics, mouseX, mouseY);
        int startX = this.field_2776 + 8;
        int startY = this.field_2800 + 38;
        for (int i = 0; i < this.getVisibleItemCount() && (itemIndex = i + (int)(this.scrollOffset * 9.0f)) < this.filteredItems.size(); ++i) {
            int x = startX + i % 9 * 18;
            int y = startY + i / 9 * 18;
            if (mouseX < x || mouseX >= x + 18 || mouseY < y || mouseY >= y + 18) continue;
            class_1799 stack = this.filteredItems.get(itemIndex);
            graphics.method_51446(this.field_22793, stack, mouseX, mouseY);
        }
        if (!((WarehouseControlScreenHandler)this.field_2797).method_34255().method_7960()) {
            int endX = this.field_2776 + 170;
            int endY = this.field_2800 + 130;
            if (mouseX >= startX && mouseX <= endX && mouseY >= startY && mouseY <= endY) {
                graphics.method_25294(startX, startY, endX, endY, 1082195840);
            }
        }
    }

    protected void method_2389(class_332 graphics, float delta, int mouseX, int mouseY) {
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -3750202);
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + 1, -13158601);
        graphics.method_25294(this.field_2776, this.field_2800 + this.field_2779 - 1, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -13158601);
        graphics.method_25294(this.field_2776, this.field_2800, this.field_2776 + 1, this.field_2800 + this.field_2779, -13158601);
        graphics.method_25294(this.field_2776 + this.field_2792 - 1, this.field_2800, this.field_2776 + this.field_2792, this.field_2800 + this.field_2779, -13158601);
        graphics.method_25294(this.field_2776 + 1, this.field_2800 + 1, this.field_2776 + this.field_2792 - 1, this.field_2800 + this.field_2779 - 1, -2039584);
        graphics.method_25294(this.field_2776 + 7, this.field_2800 + 19, this.field_2776 + 120, this.field_2800 + 33, -13158601);
        graphics.method_25294(this.field_2776 + 8, this.field_2800 + 20, this.field_2776 + 119, this.field_2800 + 32, -986896);
        graphics.method_25294(this.field_2776 + 7, this.field_2800 + 37, this.field_2776 + 171, this.field_2800 + 131, -7631989);
        graphics.method_25294(this.field_2776 + 8, this.field_2800 + 38, this.field_2776 + 170, this.field_2800 + 130, -13158601);
        int scrollbarX = this.field_2776 + 175;
        int scrollbarY = this.field_2800 + 38;
        int scrollbarHeight = 92;
        graphics.method_25294(scrollbarX, scrollbarY, scrollbarX + 12, scrollbarY + scrollbarHeight, -5592406);
        graphics.method_25294(scrollbarX + 1, scrollbarY + 1, scrollbarX + 11, scrollbarY + scrollbarHeight - 1, -10461088);
        if (this.canScroll()) {
            boolean hovered;
            float scrollPos = this.scrollOffset * (float)(scrollbarHeight - 15);
            int sliderY = scrollbarY + (int)scrollPos;
            boolean bl = hovered = mouseX >= scrollbarX && mouseX < scrollbarX + 12 && mouseY >= sliderY && mouseY < sliderY + 15;
            int sliderColor = this.isScrolling ? -12566464 : (hovered ? -11513776 : -8355712);
            graphics.method_25294(scrollbarX, sliderY, scrollbarX + 12, sliderY + 15, sliderColor);
            graphics.method_25294(scrollbarX + 1, sliderY + 1, scrollbarX + 11, sliderY + 14, -3355444);
        } else {
            graphics.method_25294(scrollbarX, scrollbarY, scrollbarX + 12, scrollbarY + 15, -8355712);
            graphics.method_25294(scrollbarX + 1, scrollbarY + 1, scrollbarX + 11, scrollbarY + 14, -6710887);
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                int x = this.field_2776 + 8 + col * 18;
                int y = this.field_2800 + 174 + row * 18;
                graphics.method_25294(x - 1, y - 1, x + 17, y + 17, -7631989);
                graphics.method_25294(x, y, x + 16, y + 16, -13158601);
            }
        }
        for (int col = 0; col < 9; ++col) {
            int x = this.field_2776 + 8 + col * 18;
            int y = this.field_2800 + 232;
            graphics.method_25294(x - 1, y - 1, x + 17, y + 17, -7631989);
            graphics.method_25294(x, y, x + 16, y + 16, -13158601);
        }
        this.renderItems(graphics);
        graphics.method_25294(this.field_2776 + 50, this.field_2800 + 135, this.field_2776 + 130, this.field_2800 + 149, -13158601);
        graphics.method_25294(this.field_2776 + 51, this.field_2800 + 136, this.field_2776 + 129, this.field_2800 + 148, -986896);
        String capacityText = String.format("%d/%d", ((WarehouseControlScreenHandler)this.field_2797).getUsedCapacity(), ((WarehouseControlScreenHandler)this.field_2797).getTotalCapacity());
        graphics.method_25300(this.field_22793, capacityText, this.field_2776 + 90, this.field_2800 + 138, 0x404040);
    }

    private void renderItems(class_332 graphics) {
        int itemIndex;
        int startX = this.field_2776 + 8;
        int startY = this.field_2800 + 38;
        for (int i = 0; i < this.getVisibleItemCount() && (itemIndex = i + (int)(this.scrollOffset * 9.0f)) < this.filteredItems.size(); ++i) {
            class_1799 stack = this.filteredItems.get(itemIndex);
            int x = startX + i % 9 * 18;
            int y = startY + i / 9 * 18;
            graphics.method_51427(stack, x, y);
            int actualCount = this.getActualItemCount(stack);
            Object countText = actualCount > 999 ? actualCount / 1000 + "k" : (actualCount > stack.method_7914() ? String.valueOf(actualCount) : null);
            if (countText != null) {
                graphics.method_51448().method_22903();
                graphics.method_51448().method_46416(0.0f, 0.0f, 200.0f);
                graphics.method_51433(this.field_22793, (String)countText, x + 17 - this.field_22793.method_1727((String)countText), y + 9, 0xFFFFFF, true);
                graphics.method_51448().method_22909();
                continue;
            }
            graphics.method_51431(this.field_22793, stack, x, y);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        int itemIndex;
        this.justClickedWarehouseItem = false;
        int startX = this.field_2776 + 8;
        int startY = this.field_2800 + 38;
        for (int i = 0; i < this.getVisibleItemCount() && (itemIndex = i + (int)(this.scrollOffset * 9.0f)) < this.filteredItems.size(); ++i) {
            int x = startX + i % 9 * 18;
            int y = startY + i / 9 * 18;
            if (!(mouseX >= (double)x) || !(mouseX < (double)(x + 18)) || !(mouseY >= (double)y) || !(mouseY < (double)(y + 18))) continue;
            class_1799 stack = this.filteredItems.get(itemIndex);
            boolean rightClick = button == 1;
            boolean shiftClick = WarehouseControlScreen.method_25442();
            this.justClickedWarehouseItem = true;
            ClientPacketHandler.sendWarehouseItemRequest(((WarehouseControlScreenHandler)this.field_2797).getBlockPos(), stack, shiftClick, rightClick);
            return true;
        }
        int scrollbarX = this.field_2776 + 175;
        int scrollbarY = this.field_2800 + 38;
        if (mouseX >= (double)scrollbarX && mouseX < (double)(scrollbarX + 12) && mouseY >= (double)scrollbarY && mouseY < (double)(scrollbarY + 90) && this.canScroll()) {
            this.isScrolling = true;
            this.scrollMouseY = (int)mouseY;
            return true;
        }
        return super.method_25402(mouseX, mouseY, button);
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isScrolling = false;
        if (button == 0 && !this.justClickedWarehouseItem && ((WarehouseControlScreenHandler)this.field_2797).method_34255() != null && !((WarehouseControlScreenHandler)this.field_2797).method_34255().method_7960()) {
            int startX = this.field_2776 + 8;
            int startY = this.field_2800 + 38;
            int endX = this.field_2776 + 170;
            int endY = this.field_2800 + 130;
            if (mouseX >= (double)startX && mouseX <= (double)endX && mouseY >= (double)startY && mouseY <= (double)endY) {
                ClientPacketHandler.sendWarehouseItemDeposit(((WarehouseControlScreenHandler)this.field_2797).getBlockPos());
                return true;
            }
        }
        this.justClickedWarehouseItem = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.isScrolling) {
            int scrollbarY = this.field_2800 + 38;
            int scrollbarHeight = 75;
            float newScroll = ((float)mouseY - (float)scrollbarY) / (float)scrollbarHeight;
            this.scrollOffset = Math.max(0.0f, Math.min(1.0f, newScroll));
            return true;
        }
        return super.method_25403(mouseX, mouseY, button, dragX, dragY);
    }

    public boolean method_25401(double mouseX, double mouseY, double delta) {
        if (this.canScroll()) {
            int maxScroll = this.getMaxScroll();
            this.scrollOffset -= (float)(delta / (double)maxScroll);
            this.scrollOffset = Math.max(0.0f, Math.min(1.0f, this.scrollOffset));
            return true;
        }
        return super.method_25401(mouseX, mouseY, delta);
    }

    private void updateFilteredItems() {
        this.filteredItems.clear();
        String searchText = this.searchBox.method_1882().toLowerCase();
        for (class_1799 stack : ((WarehouseControlScreenHandler)this.field_2797).getCachedItems()) {
            if (!searchText.isEmpty() && !stack.method_7964().getString().toLowerCase().contains(searchText) && !stack.method_7909().toString().toLowerCase().contains(searchText)) continue;
            this.filteredItems.add(stack);
        }
        if (!searchText.equals(this.lastSearchText)) {
            this.scrollOffset = 0.0f;
            this.lastSearchText = searchText;
        }
    }

    private boolean canScroll() {
        return this.filteredItems.size() > 45;
    }

    private int getMaxScroll() {
        return Math.max(1, (this.filteredItems.size() - 1) / 9 - 5 + 1);
    }

    private int getVisibleItemCount() {
        return Math.min(this.filteredItems.size(), 45);
    }

    private int getActualItemCount(class_1799 displayStack) {
        return displayStack.method_7947();
    }

    private String getCurrentSortType() {
        return ((WarehouseControlScreenHandler)this.field_2797).getCachedSortType().toLowerCase();
    }

    private boolean isAscending() {
        return ((WarehouseControlScreenHandler)this.field_2797).getCachedSortAscending();
    }

    private void updateSortButton() {
        this.sortButton.method_25355((class_2561)class_2561.method_43471((String)("gui.hundred_years_war.warehouse.sort." + this.getCurrentSortType())));
    }

    private void updateOrderButton() {
        this.orderButton.method_25355((class_2561)class_2561.method_43470((String)(this.isAscending() ? "\u25b2" : "\u25bc")));
    }

    public void updateItemData(List<class_1799> items, int totalCapacity, int usedCapacity) {
        ((WarehouseControlScreenHandler)this.field_2797).updateCachedItems(items, totalCapacity, usedCapacity);
        this.updateFilteredItems();
    }

    public WarehouseControlScreenHandler getMenu() {
        return (WarehouseControlScreenHandler)this.field_2797;
    }

    public void updateSortState(String sortType, boolean ascending) {
        ((WarehouseControlScreenHandler)this.field_2797).updateSortState(sortType, ascending);
        this.updateSortButton();
        this.updateOrderButton();
        this.updateFilteredItems();
    }
}

