/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.warehouse;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1713;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3917;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;

public class WarehouseControlScreenHandler
extends class_1703 {
    public static final class_3917<WarehouseControlScreenHandler> TYPE = new class_3917(WarehouseControlScreenHandler::clientCreate, null);
    private static class_2338 clientBlockPos = null;
    private final WarehouseControlBlockEntity blockEntity;
    private final class_2338 blockPos;
    private final class_1657 player;
    private List<class_1799> cachedItems = new ArrayList<class_1799>();
    private int totalCapacity = 0;
    private int usedCapacity = 0;
    private String cachedSortType = "NAME";
    private boolean cachedSortAscending = true;
    private boolean shouldUpdate = true;

    public WarehouseControlScreenHandler(int syncId, class_1661 playerInventory, WarehouseControlBlockEntity blockEntity) {
        super(TYPE, syncId);
        this.blockEntity = blockEntity;
        this.blockPos = blockEntity.method_11016();
        this.player = playerInventory.field_7546;
        this.addPlayerInventory(playerInventory);
        if (blockEntity != null && !playerInventory.field_7546.method_37908().field_9236) {
            blockEntity.addViewer(this);
        }
    }

    public static WarehouseControlScreenHandler clientCreate(int syncId, class_1661 playerInventory) {
        class_2338 pos = clientBlockPos;
        clientBlockPos = null;
        if (pos != null) {
            WarehouseControlBlockEntity blockEntity = (WarehouseControlBlockEntity)playerInventory.field_7546.method_37908().method_8321(pos);
            return new WarehouseControlScreenHandler(syncId, playerInventory, blockEntity, true);
        }
        throw new IllegalStateException("No BlockPos set for client screen handler creation");
    }

    public static void setClientBlockPos(class_2338 pos) {
        clientBlockPos = pos;
    }

    private WarehouseControlScreenHandler(int syncId, class_1661 playerInventory, WarehouseControlBlockEntity blockEntity, boolean isClient) {
        this(syncId, playerInventory, blockEntity);
        this.cachedItems.clear();
        this.totalCapacity = 0;
        this.usedCapacity = 0;
        if (this.blockEntity != null) {
            this.cachedSortType = blockEntity.getSortType().name();
            this.cachedSortAscending = blockEntity.isSortAscending();
        }
    }

    private void addPlayerInventory(class_1661 playerInventory) {
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 174 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, 232));
        }
    }

    public void method_7593(int slotId, int button, class_1713 actionType, class_1657 player) {
        if (slotId >= 36 && slotId < 36 + this.cachedItems.size()) {
            int itemIndex = slotId - 36;
            if (itemIndex < this.cachedItems.size()) {
                class_1799 clickedItem = this.cachedItems.get(itemIndex);
                if (!player.method_37908().field_9236) {
                    this.handleItemClick(player, clickedItem, button, actionType);
                }
            }
            return;
        }
        super.method_7593(slotId, button, actionType, player);
    }

    private void handleItemClick(class_1657 player, class_1799 requestItem, int button, class_1713 actionType) {
        boolean rightClick;
        if (this.blockEntity == null) {
            return;
        }
        class_1799 cursorStack = this.method_34255();
        boolean shiftClick = actionType == class_1713.field_7794;
        boolean bl = rightClick = button == 1;
        if (!cursorStack.method_7960()) {
            class_1799 remaining = this.blockEntity.tryAddItem(cursorStack);
            this.method_34254(remaining);
            if (player instanceof class_3222) {
                class_3222 serverPlayer = (class_3222)player;
                serverPlayer.field_7512.method_7623();
            }
        } else {
            int requestCount = requestItem.method_7914();
            if (rightClick) {
                int available = this.blockEntity.getItemCount(requestItem);
                requestCount = Math.min(requestCount, (available + 1) / 2);
            }
            class_1799 extractRequest = requestItem.method_7972();
            extractRequest.method_7939(requestCount);
            class_1799 extracted = this.blockEntity.tryExtractItem(extractRequest);
            if (!extracted.method_7960()) {
                if (shiftClick) {
                    if (!this.method_7616(extracted, 0, 36, false)) {
                        this.blockEntity.tryAddItem(extracted);
                    }
                } else {
                    this.method_34254(extracted);
                }
                if (player instanceof class_3222) {
                    class_3222 serverPlayer = (class_3222)player;
                    serverPlayer.field_7512.method_7623();
                }
            }
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            result = slotStack.method_7972();
            if (index < 36) {
                if (this.blockEntity != null) {
                    class_1799 remaining = this.blockEntity.tryAddItem(slotStack);
                    slot.method_7673(remaining);
                    if (remaining.method_7960() || remaining.method_7947() != result.method_7947()) {
                        slot.method_7668();
                        return result;
                    }
                }
                return class_1799.field_8037;
            }
        }
        return result;
    }

    public boolean method_7597(class_1657 player) {
        if (this.blockEntity != null) {
            return this.blockEntity.stillValid(player);
        }
        return false;
    }

    public void updateCachedItems(List<class_1799> items, int totalCapacity, int usedCapacity) {
        this.cachedItems = new ArrayList<class_1799>(items);
        this.totalCapacity = totalCapacity;
        this.usedCapacity = usedCapacity;
    }

    public List<class_1799> getCachedItems() {
        return this.cachedItems;
    }

    public int getTotalCapacity() {
        return this.totalCapacity;
    }

    public int getUsedCapacity() {
        return this.usedCapacity;
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public WarehouseControlBlockEntity getBlockEntity() {
        return this.blockEntity;
    }

    public boolean moveItemStackToPublic(class_1799 stack, int startIndex, int endIndex, boolean reverseDirection) {
        return this.method_7616(stack, startIndex, endIndex, reverseDirection);
    }

    public void markForUpdate() {
        this.shouldUpdate = true;
    }

    public void method_7623() {
        class_1657 class_16572;
        super.method_7623();
        if (this.shouldUpdate && this.blockEntity != null && !this.player.method_37908().field_9236 && (class_16572 = this.player) instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)class_16572;
            this.shouldUpdate = false;
            this.blockEntity.syncToClient(serverPlayer);
        }
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (this.blockEntity != null) {
            this.blockEntity.removeViewer(this);
        }
    }

    public void updateSortState(String sortType, boolean ascending) {
        this.cachedSortType = sortType;
        this.cachedSortAscending = ascending;
    }

    public String getCachedSortType() {
        return this.cachedSortType;
    }

    public boolean getCachedSortAscending() {
        return this.cachedSortAscending;
    }
}

