/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BaseWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.utils.ChunkLoadingUtils;

public abstract class BoundedWorkstationBlockEntity
extends BaseWorkstationBlockEntity {
    protected int workRangeLeft = 2;
    protected int workRangeRight = 2;
    protected int workRangeUp = 2;
    protected int workRangeDown = 0;
    protected boolean showRange = false;
    private boolean chunkLoadingActive = false;
    private boolean rangeChunkLoadingActive = false;
    private class_2338 lastRangeMin = null;
    private class_2338 lastRangeMax = null;
    protected class_2338 workCenter;

    public BoundedWorkstationBlockEntity(class_2591<?> type, class_2338 pos, class_2680 blockState) {
        super(type, pos, blockState);
    }

    public void method_31662(class_1937 level) {
        super.method_31662(level);
        if (level instanceof class_3218) {
            class_3218 serverLevel = (class_3218)level;
            if (!this.chunkLoadingActive) {
                ChunkLoadingUtils.addWorkstationChunkLoading(serverLevel, this.method_11016());
                this.chunkLoadingActive = true;
                if (this.shouldLoadWorkRange() && this.activated) {
                    this.updateRangeChunkLoading();
                }
            }
        }
    }

    public void method_11012() {
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (this.chunkLoadingActive) {
                ChunkLoadingUtils.removeWorkstationChunkLoading(serverLevel, this.method_11016());
                this.chunkLoadingActive = false;
            }
            if (this.rangeChunkLoadingActive && this.lastRangeMin != null && this.lastRangeMax != null) {
                ChunkLoadingUtils.removeWorkstationRangeChunkLoading(serverLevel, this.lastRangeMin, this.lastRangeMax);
                this.rangeChunkLoadingActive = false;
                this.lastRangeMin = null;
                this.lastRangeMax = null;
            }
        }
        super.method_11012();
    }

    public void method_10996() {
        super.method_10996();
        class_1937 class_19372 = this.field_11863;
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            if (!this.chunkLoadingActive) {
                ChunkLoadingUtils.addWorkstationChunkLoading(serverLevel, this.method_11016());
                this.chunkLoadingActive = true;
            }
            if (this.shouldLoadWorkRange() && this.activated) {
                this.updateRangeChunkLoading();
            }
        }
    }

    public int getWorkRangeLeft() {
        return this.workRangeLeft;
    }

    public void setWorkRangeLeft(int range) {
        this.workRangeLeft = Math.max(0, Math.min(range, this.getMaxRangeLeft()));
        this.updateWorkCenter();
        this.method_5431();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public int getWorkRangeRight() {
        return this.workRangeRight;
    }

    public void setWorkRangeRight(int range) {
        this.workRangeRight = Math.max(0, Math.min(range, this.getMaxRangeRight()));
        this.updateWorkCenter();
        this.method_5431();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public int getWorkRangeUp() {
        return this.workRangeUp;
    }

    public void setWorkRangeUp(int range) {
        this.workRangeUp = Math.max(0, Math.min(range, this.getMaxRangeUp()));
        this.updateWorkCenter();
        this.method_5431();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public int getWorkRangeDown() {
        return this.workRangeDown;
    }

    public void setWorkRangeDown(int range) {
        int minRange = 0;
        if (this instanceof MiningWorkstationBlockEntity) {
            minRange = -50;
        } else if (this instanceof FishingWorkstationBlockEntity) {
            minRange = -16;
        } else if (this instanceof WarehouseControlBlockEntity) {
            minRange = -10;
        }
        this.workRangeDown = Math.max(minRange, Math.min(range, this.getMaxRangeDown()));
        this.updateWorkCenter();
        this.method_5431();
        this.syncToClient();
        this.updateRangeChunkLoading();
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        this.method_5431();
        this.syncToClient();
    }

    public int getMaxRangeLeft() {
        return 8;
    }

    public int getMaxRangeRight() {
        return 8;
    }

    public int getMaxRangeUp() {
        return 16;
    }

    public int getMaxRangeDown() {
        return 0;
    }

    public abstract class_2350 getFacing();

    protected void updateWorkCenter() {
        this.workCenter = this.method_11016().method_10079(this.getFacing(), 1);
    }

    public class_238 getWorkArea() {
        int maxY;
        int minY;
        int minZ;
        int maxX;
        int minX;
        class_2338 currentWorkCenter = this.method_11016().method_10079(this.getFacing(), 1);
        class_2350 facing = this.getFacing();
        int maxZ = switch (facing) {
            case class_2350.field_11043 -> {
                minX = currentWorkCenter.method_10263() - this.workRangeLeft;
                maxX = currentWorkCenter.method_10263() + this.workRangeRight;
                minZ = currentWorkCenter.method_10260() - this.workRangeUp;
                yield currentWorkCenter.method_10260();
            }
            case class_2350.field_11035 -> {
                minX = currentWorkCenter.method_10263() - this.workRangeRight;
                maxX = currentWorkCenter.method_10263() + this.workRangeLeft;
                minZ = currentWorkCenter.method_10260();
                yield currentWorkCenter.method_10260() + this.workRangeUp;
            }
            case class_2350.field_11039 -> {
                minX = currentWorkCenter.method_10263() - this.workRangeUp;
                maxX = currentWorkCenter.method_10263();
                minZ = currentWorkCenter.method_10260() - this.workRangeRight;
                yield currentWorkCenter.method_10260() + this.workRangeLeft;
            }
            case class_2350.field_11034 -> {
                minX = currentWorkCenter.method_10263();
                maxX = currentWorkCenter.method_10263() + this.workRangeUp;
                minZ = currentWorkCenter.method_10260() - this.workRangeLeft;
                yield currentWorkCenter.method_10260() + this.workRangeRight;
            }
            default -> {
                minX = currentWorkCenter.method_10263() - this.workRangeLeft;
                maxX = currentWorkCenter.method_10263() + this.workRangeRight;
                minZ = currentWorkCenter.method_10260() - this.workRangeUp;
                yield currentWorkCenter.method_10260();
            }
        };
        if (this.workRangeDown >= 0) {
            minY = currentWorkCenter.method_10264();
            maxY = currentWorkCenter.method_10264() + this.workRangeDown;
        } else {
            minY = currentWorkCenter.method_10264() + this.workRangeDown;
            maxY = currentWorkCenter.method_10264();
        }
        return new class_238((double)minX, (double)minY, (double)minZ, (double)(maxX + 1), (double)(maxY + 1), (double)(maxZ + 1));
    }

    public class_2338 getWorkRangeMin() {
        class_238 area = this.getWorkArea();
        return new class_2338((int)Math.floor(area.field_1323), (int)Math.floor(area.field_1322), (int)Math.floor(area.field_1321));
    }

    public class_2338 getWorkRangeMax() {
        class_238 area = this.getWorkArea();
        return new class_2338((int)Math.floor(area.field_1320 - 0.01), (int)Math.floor(area.field_1325 - 0.01), (int)Math.floor(area.field_1324 - 0.01));
    }

    public boolean isInWorkRange(class_2338 pos) {
        class_238 area = this.getWorkArea();
        return (double)pos.method_10263() >= area.field_1323 && (double)pos.method_10263() < area.field_1320 && (double)pos.method_10264() >= area.field_1322 && (double)pos.method_10264() < area.field_1325 && (double)pos.method_10260() >= area.field_1321 && (double)pos.method_10260() < area.field_1324;
    }

    protected boolean shouldLoadWorkRange() {
        if (this instanceof MiningWorkstationBlockEntity) {
            return false;
        }
        if (this instanceof TransportWorkstationBlockEntity || this instanceof CraftingWorkstationBlockEntity) {
            return false;
        }
        return this.workRangeLeft > 0 || this.workRangeRight > 0 || this.workRangeUp > 0 || this.workRangeDown != 0;
    }

    protected void updateRangeChunkLoading() {
        class_1937 class_19372 = this.field_11863;
        if (!(class_19372 instanceof class_3218)) {
            return;
        }
        class_3218 serverLevel = (class_3218)class_19372;
        if (!this.shouldLoadWorkRange()) {
            return;
        }
        if (!this.activated) {
            return;
        }
        class_2338 newMin = this.getWorkRangeMin();
        class_2338 newMax = this.getWorkRangeMax();
        if (newMin.equals((Object)this.lastRangeMin) && newMax.equals((Object)this.lastRangeMax)) {
            return;
        }
        if (this.rangeChunkLoadingActive && this.lastRangeMin != null && this.lastRangeMax != null) {
            ChunkLoadingUtils.removeWorkstationRangeChunkLoading(serverLevel, this.lastRangeMin, this.lastRangeMax);
        }
        ChunkLoadingUtils.addWorkstationRangeChunkLoading(serverLevel, newMin, newMax);
        this.rangeChunkLoadingActive = true;
        this.lastRangeMin = newMin;
        this.lastRangeMax = newMax;
    }

    @Override
    public void setActivated(boolean activated) {
        boolean wasActivated = this.activated;
        super.setActivated(activated);
        if (wasActivated != activated) {
            if (activated) {
                this.updateRangeChunkLoading();
            } else {
                class_1937 class_19372 = this.field_11863;
                if (class_19372 instanceof class_3218) {
                    class_3218 serverLevel = (class_3218)class_19372;
                    if (this.rangeChunkLoadingActive) {
                        if (this.lastRangeMin != null && this.lastRangeMax != null) {
                            ChunkLoadingUtils.removeWorkstationRangeChunkLoading(serverLevel, this.lastRangeMin, this.lastRangeMax);
                        }
                        this.rangeChunkLoadingActive = false;
                        this.lastRangeMin = null;
                        this.lastRangeMax = null;
                    }
                }
            }
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("workRangeLeft", this.workRangeLeft);
        tag.method_10569("workRangeRight", this.workRangeRight);
        tag.method_10569("workRangeUp", this.workRangeUp);
        tag.method_10569("workRangeDown", this.workRangeDown);
        tag.method_10556("showRange", this.showRange);
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.workRangeLeft = Math.max(0, Math.min(tag.method_10550("workRangeLeft"), this.getMaxRangeLeft()));
        this.workRangeRight = Math.max(0, Math.min(tag.method_10550("workRangeRight"), this.getMaxRangeRight()));
        this.workRangeUp = Math.max(0, Math.min(tag.method_10550("workRangeUp"), this.getMaxRangeUp()));
        int loadedRangeDown = tag.method_10550("workRangeDown");
        int minRange = 0;
        if (this instanceof MiningWorkstationBlockEntity) {
            minRange = -50;
        } else if (this instanceof FishingWorkstationBlockEntity) {
            minRange = -16;
        } else if (this instanceof WarehouseControlBlockEntity) {
            minRange = -10;
        }
        this.workRangeDown = Math.max(minRange, Math.min(loadedRangeDown, this.getMaxRangeDown()));
        this.showRange = tag.method_10577("showRange");
        if (this.field_11863 != null && this.field_11863.field_9236) {
            this.workCenter = null;
        }
    }
}

