/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.blocks.workstation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1747;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2261;
import net.minecraft.class_2320;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2356;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2473;
import net.minecraft.class_2487;
import net.minecraft.class_2488;
import net.minecraft.class_2526;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5819;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.blocks.workstation.InventoryBoundedWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationScreenHandler;

public class LumberWorkstationBlockEntity
extends InventoryBoundedWorkstationBlockEntity {
    private static final int WORK_INTERVAL = 20;
    private static final int TREE_SCAN_RANGE = 3;
    public static final int MAX_RANGE_LEFT = 10;
    public static final int MAX_RANGE_RIGHT = 10;
    public static final int MAX_RANGE_UP = 20;
    public static final int MAX_RANGE_DOWN = 0;
    private int workTimer = 0;
    private boolean selected = false;
    private final Random random = new Random();
    private int nextWorkInterval = 20;
    private WorkPhase currentPhase = WorkPhase.SCANNING;
    private final Set<class_2338> treePositions = new HashSet<class_2338>();
    private final Set<class_2338> plantPositions = new HashSet<class_2338>();
    private final Queue<class_2338> workQueue = new LinkedList<class_2338>();

    public LumberWorkstationBlockEntity(class_2338 pos, class_2680 state) {
        super(ModBlockEntities.LUMBER_WORKSTATION, pos, state);
        this.workRangeLeft = 3;
        this.workRangeRight = 3;
        this.workRangeUp = 3;
        this.workRangeDown = 0;
        this.showRange = true;
    }

    @Override
    public int getMaxRangeLeft() {
        return 10;
    }

    @Override
    public int getMaxRangeRight() {
        return 10;
    }

    @Override
    public int getMaxRangeUp() {
        return 20;
    }

    @Override
    public int getMaxRangeDown() {
        return 0;
    }

    @Override
    @Nullable
    public class_1703 createMenu(int containerId, class_1661 playerInventory, class_1657 player) {
        return new LumberWorkstationScreenHandler(containerId, playerInventory, this);
    }

    @Override
    public class_2561 getDisplayName() {
        return class_2561.method_43471((String)"hundred_years_war.lumber_workstation");
    }

    @Override
    public class_2350 getFacing() {
        class_2680 state = this.method_11010();
        if (state.method_28498((class_2769)LumberWorkstation.FACING)) {
            return (class_2350)state.method_11654((class_2769)LumberWorkstation.FACING);
        }
        return class_2350.field_11043;
    }

    public static void tick(class_1937 world, class_2338 pos, class_2680 state, LumberWorkstationBlockEntity blockEntity) {
        if (world.field_9236) {
            return;
        }
    }

    private void doWork() {
        switch (this.currentPhase) {
            case SCANNING: {
                this.scanWorkArea();
                if (!this.treePositions.isEmpty()) {
                    this.currentPhase = WorkPhase.CHOPPING;
                    break;
                }
                if (!this.plantPositions.isEmpty() && this.hasSaplings()) {
                    this.currentPhase = WorkPhase.PLANTING;
                    break;
                }
                if (!this.hasBoneMeal()) break;
                this.currentPhase = WorkPhase.BONE_MEALING;
                break;
            }
            case CHOPPING: {
                if (this.chopTree()) break;
                this.currentPhase = WorkPhase.SCANNING;
                break;
            }
            case PLANTING: {
                if (this.plantSapling()) break;
                this.currentPhase = WorkPhase.SCANNING;
                break;
            }
            case BONE_MEALING: {
                this.applyBoneMeal();
                this.currentPhase = WorkPhase.SCANNING;
            }
        }
        this.method_5431();
    }

    private void rescanWorkArea() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.scanWorkArea();
            this.currentPhase = !this.treePositions.isEmpty() ? WorkPhase.CHOPPING : (!this.plantPositions.isEmpty() && this.hasSaplings() ? WorkPhase.PLANTING : WorkPhase.SCANNING);
        }
    }

    private void scanWorkArea() {
        int z;
        int x;
        this.treePositions.clear();
        this.plantPositions.clear();
        class_238 workArea = this.getWorkArea();
        class_2338 min = new class_2338((int)workArea.field_1323, (int)workArea.field_1322, (int)workArea.field_1321);
        class_2338 max = new class_2338((int)workArea.field_1320, (int)workArea.field_1325, (int)workArea.field_1324);
        int workY = min.method_10264();
        for (x = min.method_10263(); x < max.method_10263(); ++x) {
            for (z = min.method_10260(); z < max.method_10260(); ++z) {
                class_2338 pos = new class_2338(x, workY, z);
                if (!this.canPlantAt(pos) && !this.canPlantAtAfterClearing(pos)) continue;
                this.plantPositions.add(pos);
            }
        }
        for (x = min.method_10263(); x <= max.method_10263(); ++x) {
            for (z = min.method_10260(); z <= max.method_10260(); ++z) {
                for (int y = min.method_10264(); y <= min.method_10264() + 20; ++y) {
                    class_2338 pos = new class_2338(x, y, z);
                    class_2680 state = this.field_11863.method_8320(pos);
                    if (!state.method_26164(class_3481.field_15475) && !state.method_26164(class_3481.field_15503)) continue;
                    this.scanTreeFrom(pos);
                }
            }
        }
    }

    private void scanTreeFrom(class_2338 startPos) {
        if (this.treePositions.contains(startPos)) {
            return;
        }
        HashSet<class_2338> scannedTree = new HashSet<class_2338>();
        LinkedList<class_2338> scanQueue = new LinkedList<class_2338>();
        scanQueue.add(startPos);
        scannedTree.add(startPos);
        while (!scanQueue.isEmpty() && scannedTree.size() < 200) {
            class_2338 current = (class_2338)scanQueue.poll();
            class_2680 currentState = this.field_11863.method_8320(current);
            if (!currentState.method_26164(class_3481.field_15475) && !currentState.method_26164(class_3481.field_15503)) continue;
            for (int dx = -1; dx <= 1; ++dx) {
                for (int dy = -1; dy <= 1; ++dy) {
                    for (int dz = -1; dz <= 1; ++dz) {
                        class_2680 neighborState;
                        class_2338 neighborPos;
                        if (dx == 0 && dy == 0 && dz == 0 || scannedTree.contains(neighborPos = current.method_10069(dx, dy, dz)) || !(neighborState = this.field_11863.method_8320(neighborPos)).method_26164(class_3481.field_15475) && !neighborState.method_26164(class_3481.field_15503)) continue;
                        scannedTree.add(neighborPos);
                        scanQueue.add(neighborPos);
                    }
                }
            }
        }
        if (scannedTree.size() >= 3) {
            this.treePositions.addAll(scannedTree);
        }
    }

    private boolean chopTree() {
        if (this.treePositions.isEmpty()) {
            return false;
        }
        ArrayList<class_2338> toChop = new ArrayList<class_2338>();
        Iterator<class_2338> iterator = this.treePositions.iterator();
        int maxChop = 10;
        while (iterator.hasNext() && toChop.size() < maxChop) {
            class_2338 pos = iterator.next();
            if (!this.field_11863.method_8320(pos).method_26215()) {
                toChop.add(pos);
            }
            iterator.remove();
        }
        for (class_2338 pos : toChop) {
            class_2680 state = this.field_11863.method_8320(pos);
            if (state.method_26215()) continue;
            if (this.random.nextFloat() < 0.5f) {
                this.field_11863.method_20290(2001, pos, class_2248.method_9507((class_2680)state));
            }
            List drops = class_2248.method_9562((class_2680)state, (class_3218)((class_3218)this.field_11863), (class_2338)pos, null);
            for (class_1799 drop : drops) {
                this.addToInventory(drop);
            }
            this.field_11863.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
        return !this.treePositions.isEmpty();
    }

    private boolean plantSapling() {
        if (this.plantPositions.isEmpty() || !this.hasSaplings()) {
            return false;
        }
        class_1799 sapling = null;
        int saplingSlot = -1;
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (!this.isSapling(stack)) continue;
            sapling = stack;
            saplingSlot = i;
            break;
        }
        if (sapling == null) {
            return false;
        }
        class_2338 plantPos = this.plantPositions.iterator().next();
        this.plantPositions.remove(plantPos);
        this.clearObstaclesAt(plantPos);
        if (this.canPlantAt(plantPos)) {
            class_2680 saplingState = this.getSaplingBlockState(sapling);
            if (saplingState != null) {
                this.field_11863.method_8652(plantPos, saplingState, 3);
                this.field_11863.method_8396(null, plantPos, class_3417.field_14653, class_3419.field_15245, 1.0f, 1.0f);
                sapling.method_7934(1);
                if (sapling.method_7960()) {
                    this.method_5447(saplingSlot, class_1799.field_8037);
                }
                return true;
            }
            return false;
        }
        return !this.plantPositions.isEmpty() && this.hasSaplings();
    }

    private void clearObstaclesAt(class_2338 pos) {
        class_2680 state = this.field_11863.method_8320(pos);
        if (this.isObstacle(state)) {
            this.field_11863.method_8652(pos, class_2246.field_10124.method_9564(), 3);
        }
    }

    private boolean canPlantAt(class_2338 pos) {
        if (!this.field_11863.method_8320(pos).method_26215()) {
            return false;
        }
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = this.field_11863.method_8320(belowPos);
        return belowState.method_27852(class_2246.field_10219) || belowState.method_27852(class_2246.field_10566) || belowState.method_27852(class_2246.field_10253) || belowState.method_27852(class_2246.field_10520) || belowState.method_27852(class_2246.field_10362);
    }

    private boolean canPlantAtAfterClearing(class_2338 pos) {
        class_2680 state = this.field_11863.method_8320(pos);
        if (!this.isObstacle(state)) {
            return false;
        }
        class_2338 belowPos = pos.method_10074();
        class_2680 belowState = this.field_11863.method_8320(belowPos);
        return belowState.method_27852(class_2246.field_10219) || belowState.method_27852(class_2246.field_10566) || belowState.method_27852(class_2246.field_10253) || belowState.method_27852(class_2246.field_10520) || belowState.method_27852(class_2246.field_10362);
    }

    private boolean isObstacle(class_2680 state) {
        if (state.method_26215()) {
            return false;
        }
        class_2248 block = state.method_26204();
        if (block instanceof class_2473) {
            return false;
        }
        return state.method_45474() || block instanceof class_2488 || block instanceof class_2261 || block instanceof class_2526 || block instanceof class_2320 || block instanceof class_2356;
    }

    private boolean hasSaplings() {
        for (int i = 0; i < this.method_5439(); ++i) {
            if (!this.isSapling(this.method_5438(i))) continue;
            return true;
        }
        return false;
    }

    private boolean hasBoneMeal() {
        for (int i = 0; i < this.method_5439(); ++i) {
            class_1799 stack = this.method_5438(i);
            if (stack.method_7909() != class_1802.field_8324) continue;
            return true;
        }
        return false;
    }

    private boolean applyBoneMeal() {
        if (!this.hasBoneMeal()) {
            return false;
        }
        class_238 workArea = this.getWorkArea();
        class_2338 min = new class_2338((int)workArea.field_1323, (int)workArea.field_1322, (int)workArea.field_1321);
        class_2338 max = new class_2338((int)workArea.field_1320, (int)workArea.field_1325, (int)workArea.field_1324);
        ArrayList<class_2338> saplingPositions = new ArrayList<class_2338>();
        int workY = min.method_10264();
        for (int x = min.method_10263(); x < max.method_10263(); ++x) {
            for (int z = min.method_10260(); z < max.method_10260(); ++z) {
                class_2338 pos = new class_2338(x, workY, z);
                class_2680 state = this.field_11863.method_8320(pos);
                if (!(state.method_26204() instanceof class_2473)) continue;
                saplingPositions.add(pos);
            }
        }
        if (saplingPositions.isEmpty()) {
            return false;
        }
        Collections.shuffle(saplingPositions, this.random);
        for (class_2338 pos : saplingPositions) {
            class_2680 state = this.field_11863.method_8320(pos);
            class_2248 class_22482 = state.method_26204();
            if (!(class_22482 instanceof class_2473)) continue;
            class_2473 saplingBlock = (class_2473)class_22482;
            for (int i = 0; i < this.method_5439(); ++i) {
                class_5819 randomSource;
                class_1799 stack = this.method_5438(i);
                if (stack.method_7909() != class_1802.field_8324 || !saplingBlock.method_9650(this.field_11863, randomSource = this.field_11863.method_8409(), pos, state)) continue;
                saplingBlock.method_9652((class_3218)this.field_11863, randomSource, pos, state);
                ((class_3218)this.field_11863).method_14199((class_2394)class_2398.field_11211, (double)pos.method_10263() + 0.5, (double)pos.method_10264() + 0.5, (double)pos.method_10260() + 0.5, 10, 0.5, 0.5, 0.5, 0.1);
                stack.method_7934(1);
                if (stack.method_7960()) {
                    this.method_5447(i, class_1799.field_8037);
                }
                this.method_5431();
                return true;
            }
        }
        return false;
    }

    private boolean isSapling(class_1799 stack) {
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1747) {
            class_1747 blockItem = (class_1747)class_17922;
            class_2248 block = blockItem.method_7711();
            return block instanceof class_2473;
        }
        return false;
    }

    private class_2680 getSaplingBlockState(class_1799 sapling) {
        class_1747 blockItem;
        class_2248 block;
        class_1792 class_17922 = sapling.method_7909();
        if (class_17922 instanceof class_1747 && (block = (blockItem = (class_1747)class_17922).method_7711()) instanceof class_2473) {
            return block.method_9564();
        }
        return null;
    }

    private void addToInventory(class_1799 stack) {
        for (int i = 0; i < this.inventory.method_5439(); ++i) {
            int canAdd;
            class_1799 slotStack = this.inventory.method_5438(i);
            if (slotStack.method_7960()) {
                this.inventory.method_5447(i, stack.method_7972());
                return;
            }
            if (!class_1799.method_31577((class_1799)slotStack, (class_1799)stack) || (canAdd = slotStack.method_7914() - slotStack.method_7947()) <= 0) continue;
            int toAdd = Math.min(canAdd, stack.method_7947());
            slotStack.method_7933(toAdd);
            stack.method_7934(toAdd);
            if (!stack.method_7960()) continue;
            return;
        }
    }

    @Override
    public void setWorkRangeLeft(int range) {
        super.setWorkRangeLeft(range);
        this.rescanWorkArea();
    }

    @Override
    public void setWorkRangeRight(int range) {
        super.setWorkRangeRight(range);
        this.rescanWorkArea();
    }

    @Override
    public void setWorkRangeUp(int range) {
        super.setWorkRangeUp(range);
        this.rescanWorkArea();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
        this.method_5431();
    }

    @Override
    public void triggerWork() {
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.collectDroppedItems();
            this.doWork();
        }
    }

    @Override
    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        tag.method_10569("WorkTimer", this.workTimer);
        tag.method_10569("NextWorkInterval", this.nextWorkInterval);
        tag.method_10582("CurrentPhase", this.currentPhase.name());
        tag.method_10556("Selected", this.selected);
        if (this.workCenter != null) {
            tag.method_10544("WorkCenter", this.workCenter.method_10063());
        }
    }

    @Override
    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.workTimer = tag.method_10550("WorkTimer");
        this.nextWorkInterval = tag.method_10550("NextWorkInterval");
        if (this.nextWorkInterval <= 0) {
            this.nextWorkInterval = 20;
        }
        try {
            this.currentPhase = WorkPhase.valueOf(tag.method_10558("CurrentPhase"));
        }
        catch (IllegalArgumentException e) {
            this.currentPhase = WorkPhase.SCANNING;
        }
        this.selected = tag.method_10577("Selected");
        if (tag.method_10545("WorkCenter")) {
            this.workCenter = class_2338.method_10092((long)tag.method_10537("WorkCenter"));
        } else {
            this.updateWorkCenter();
        }
    }

    private static enum WorkPhase {
        SCANNING,
        CHOPPING,
        PLANTING,
        BONE_MEALING;

    }
}

