/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.data;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;

public class TransportData {
    private final List<TransportRoute> routes = new ArrayList<TransportRoute>();
    private int currentIndex = 0;

    public boolean addRoute(class_2338 sourcePos, class_2338 targetPos, class_2350 side, TransportMode mode) {
        double distance = Math.sqrt(sourcePos.method_10262((class_2382)targetPos));
        if (distance > 50.0) {
            return false;
        }
        this.routes.add(new TransportRoute(targetPos, null, mode));
        return true;
    }

    public void removeRoute(int index) {
        if (index >= 0 && index < this.routes.size()) {
            this.routes.remove(index);
            if (this.routes.isEmpty()) {
                this.currentIndex = 0;
            } else if (this.currentIndex >= this.routes.size()) {
                this.currentIndex = this.routes.size() - 1;
            } else if (this.currentIndex > index && this.currentIndex > 0) {
                --this.currentIndex;
            }
        }
    }

    public void moveRouteUp(int index) {
        if (index > 0 && index < this.routes.size()) {
            TransportRoute route = this.routes.remove(index);
            this.routes.add(index - 1, route);
            if (this.currentIndex == index) {
                this.currentIndex = index - 1;
            } else if (this.currentIndex == index - 1) {
                this.currentIndex = index;
            }
        }
    }

    public void moveRouteDown(int index) {
        if (index >= 0 && index < this.routes.size() - 1) {
            TransportRoute route = this.routes.remove(index);
            this.routes.add(index + 1, route);
            if (this.currentIndex == index) {
                this.currentIndex = index + 1;
            } else if (this.currentIndex == index + 1) {
                this.currentIndex = index;
            }
        }
    }

    public void changeMode(int index, TransportMode mode) {
        if (index >= 0 && index < this.routes.size()) {
            this.routes.get(index).setMode(mode);
        }
    }

    public void setFilter(int routeIndex, int filterIndex, class_1799 stack) {
        if (routeIndex >= 0 && routeIndex < this.routes.size()) {
            this.routes.get(routeIndex).setFilter(filterIndex, stack);
        }
    }

    public void setQuantity(int routeIndex, int quantity) {
        if (routeIndex >= 0 && routeIndex < this.routes.size()) {
            this.routes.get(routeIndex).setQuantity(quantity);
        }
    }

    public List<TransportRoute> getRoutes() {
        return this.routes;
    }

    public TransportRoute getCurrentRoute() {
        if (this.routes.isEmpty()) {
            return null;
        }
        if (this.currentIndex >= this.routes.size()) {
            this.currentIndex = 0;
        }
        return this.routes.get(this.currentIndex);
    }

    public void moveToNext() {
        if (!this.routes.isEmpty()) {
            this.currentIndex = (this.currentIndex + 1) % this.routes.size();
        }
    }

    public boolean isEmpty() {
        return this.routes.isEmpty();
    }

    public void clear() {
        this.routes.clear();
        this.currentIndex = 0;
    }

    public void validateAndUpdateRoutes(class_2338 newSourcePos) {
        this.routes.removeIf(route -> {
            double distance = Math.sqrt(newSourcePos.method_10262((class_2382)route.getTargetPos()));
            return distance > 50.0;
        });
        if (this.routes.isEmpty()) {
            this.currentIndex = 0;
        } else if (this.currentIndex >= this.routes.size()) {
            this.currentIndex = 0;
        }
    }

    public class_2487 serializeNBT() {
        class_2487 tag = new class_2487();
        class_2499 routesList = new class_2499();
        for (TransportRoute route : this.routes) {
            routesList.add((Object)route.serializeNBT());
        }
        tag.method_10566("Routes", (class_2520)routesList);
        tag.method_10569("CurrentIndex", this.currentIndex);
        return tag;
    }

    public void deserializeNBT(class_2487 tag) {
        this.routes.clear();
        class_2499 routesList = tag.method_10554("Routes", 10);
        for (int i = 0; i < routesList.size(); ++i) {
            TransportRoute route = new TransportRoute();
            route.deserializeNBT(routesList.method_10602(i));
            this.routes.add(route);
        }
        this.currentIndex = tag.method_10550("CurrentIndex");
        if (this.currentIndex >= this.routes.size() || this.currentIndex < 0) {
            this.currentIndex = 0;
        }
    }

    public static class TransportRoute {
        private static final int FILTER_SIZE = 9;
        private static final Random RANDOM = new Random();
        private class_2338 targetPos;
        private class_2350 side;
        private TransportMode mode;
        private final class_1799[] filters = new class_1799[9];
        private int quantity = 0;

        public TransportRoute() {
            this.targetPos = class_2338.field_10980;
            this.side = class_2350.field_11033;
            this.mode = TransportMode.DEPOSIT;
            for (int i = 0; i < 9; ++i) {
                this.filters[i] = class_1799.field_8037;
            }
        }

        public TransportRoute(class_2338 pos, class_2350 side, TransportMode mode) {
            this.targetPos = pos;
            this.side = side;
            this.mode = mode;
            for (int i = 0; i < 9; ++i) {
                this.filters[i] = class_1799.field_8037;
            }
        }

        public boolean execute(TransportWorkstationBlockEntity workstation, class_1937 level) {
            boolean result;
            class_2586 targetEntity = level.method_8321(this.targetPos);
            if (targetEntity instanceof WarehouseControlBlockEntity) {
                WarehouseControlBlockEntity warehouse = (WarehouseControlBlockEntity)targetEntity;
                return switch (this.mode) {
                    default -> throw new IncompatibleClassChangeError();
                    case TransportMode.DEPOSIT -> this.depositItemsToWarehouse(workstation, warehouse);
                    case TransportMode.WITHDRAW -> this.withdrawItemsFromWarehouse(warehouse, workstation);
                };
            }
            if (!(targetEntity instanceof class_1263)) {
                return false;
            }
            class_1263 targetContainer = (class_1263)targetEntity;
            switch (this.mode) {
                default: {
                    throw new IncompatibleClassChangeError();
                }
                case DEPOSIT: {
                    boolean bl = this.depositItems((class_1263)workstation, targetContainer);
                    break;
                }
                case WITHDRAW: {
                    boolean bl = result = this.withdrawItems(targetContainer, (class_1263)workstation);
                }
            }
            if (!result) {
                // empty if block
            }
            return result;
        }

        private boolean depositItems(class_1263 from, class_1263 to) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (class_1799 filter : this.filters) {
                if (filter.method_7960()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<class_1799> availableFilters = new ArrayList<class_1799>();
            if (allFiltersEmpty) {
                for (int i = 0; i < from.method_5439(); ++i) {
                    class_1799 stack = from.method_5438(i);
                    if (stack.method_7960()) continue;
                    boolean alreadyAdded = false;
                    for (class_1799 existing : availableFilters) {
                        if (!class_1799.method_31577((class_1799)existing, (class_1799)stack)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    availableFilters.add(stack.method_7972());
                }
            } else {
                for (class_1799 filter : this.filters) {
                    int currentCountInTarget;
                    if (filter.method_7960() || !this.hasItemInContainer(from, filter) || this.quantity > 0 && (currentCountInTarget = this.countItemsInContainer(to, filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            int itemsMovedThisWork = 0;
            for (int i = 0; i < 5; ++i) {
                int currentCountInTarget;
                class_1799 selectedFilter = (class_1799)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                if (!this.hasItemInContainer(from, selectedFilter)) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                if (this.quantity > 0 && (currentCountInTarget = this.countItemsInContainer(to, selectedFilter)) >= this.quantity) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                int moved = this.transferItems(from, to, selectedFilter, 1);
                if (moved <= 0) continue;
                movedAny = true;
                itemsMovedThisWork += moved;
            }
            return movedAny;
        }

        private boolean withdrawItems(class_1263 from, class_1263 to) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (class_1799 filter : this.filters) {
                if (filter.method_7960()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<class_1799> availableFilters = new ArrayList<class_1799>();
            if (allFiltersEmpty) {
                for (int i = 0; i < from.method_5439(); ++i) {
                    class_1799 stack = from.method_5438(i);
                    if (stack.method_7960()) continue;
                    boolean alreadyAdded = false;
                    for (class_1799 existing : availableFilters) {
                        if (!class_1799.method_31577((class_1799)existing, (class_1799)stack)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    availableFilters.add(stack.method_7972());
                }
            } else {
                for (class_1799 filter : this.filters) {
                    int currentCount;
                    if (filter.method_7960() || !this.hasItemInContainer(from, filter) || this.quantity > 0 && (currentCount = this.countItemsInContainer(to, filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            int itemsMovedThisWork = 0;
            for (int i = 0; i < 5; ++i) {
                int currentCount;
                class_1799 selectedFilter = (class_1799)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                if (!this.hasItemInContainer(from, selectedFilter)) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                if (this.quantity > 0 && (currentCount = this.countItemsInContainer(to, selectedFilter)) >= this.quantity) {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                    continue;
                }
                int moved = this.transferItems(from, to, selectedFilter, 1);
                if (moved <= 0) continue;
                movedAny = true;
                itemsMovedThisWork += moved;
            }
            return movedAny;
        }

        private int countItemsInContainer(class_1263 container, class_1799 filter) {
            int count = 0;
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 stack = container.method_5438(i);
                if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)filter)) continue;
                count += stack.method_7947();
            }
            return count;
        }

        private boolean hasItemInContainer(class_1263 container, class_1799 filter) {
            for (int i = 0; i < container.method_5439(); ++i) {
                class_1799 stack = container.method_5438(i);
                if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)filter)) continue;
                return true;
            }
            return false;
        }

        private int transferItems(class_1263 from, class_1263 to, class_1799 filter, int maxAmount) {
            int transferred = 0;
            for (int i = 0; i < from.method_5439(); ++i) {
                class_1799 fromStack = from.method_5438(i);
                if (fromStack.method_7960() || !class_1799.method_31577((class_1799)fromStack, (class_1799)filter)) continue;
                int toTransfer = Math.min(fromStack.method_7947(), maxAmount - transferred);
                class_1799 transferStack = fromStack.method_7972();
                transferStack.method_7939(toTransfer);
                for (int j = 0; j < to.method_5439() && !transferStack.method_7960(); ++j) {
                    if (!to.method_5437(j, transferStack)) continue;
                    class_1799 targetStack = to.method_5438(j);
                    if (targetStack.method_7960()) {
                        to.method_5447(j, transferStack.method_7972());
                        transferred += transferStack.method_7947();
                        fromStack.method_7934(transferStack.method_7947());
                        transferStack.method_7939(0);
                        continue;
                    }
                    if (!class_1799.method_31577((class_1799)targetStack, (class_1799)transferStack)) continue;
                    int space = targetStack.method_7914() - targetStack.method_7947();
                    int toAdd = Math.min(space, transferStack.method_7947());
                    targetStack.method_7933(toAdd);
                    transferred += toAdd;
                    fromStack.method_7934(toAdd);
                    transferStack.method_7934(toAdd);
                }
                if (fromStack.method_7960()) {
                    from.method_5447(i, class_1799.field_8037);
                }
                if (transferred >= maxAmount) break;
            }
            return transferred;
        }

        public class_2338 getTargetPos() {
            return this.targetPos;
        }

        public class_2350 getSide() {
            return this.side;
        }

        public void setSide(class_2350 side) {
            this.side = side;
        }

        public TransportMode getMode() {
            return this.mode;
        }

        public void setMode(TransportMode mode) {
            this.mode = mode;
        }

        public void toggleMode() {
            this.mode = this.mode == TransportMode.DEPOSIT ? TransportMode.WITHDRAW : TransportMode.DEPOSIT;
        }

        public List<class_1799> getFilters() {
            ArrayList<class_1799> filterList = new ArrayList<class_1799>();
            for (int i = 0; i < 9; ++i) {
                filterList.add(this.filters[i]);
            }
            return filterList;
        }

        public class_1799 getFilter(int index) {
            if (index >= 0 && index < 9) {
                return this.filters[index];
            }
            return class_1799.field_8037;
        }

        public void setFilter(int index, class_1799 stack) {
            if (index >= 0 && index < 9) {
                this.filters[index] = stack.method_7972();
            }
        }

        public int getQuantity() {
            return this.quantity;
        }

        public void setQuantity(int quantity) {
            this.quantity = Math.max(0, Math.min(quantity, 999));
        }

        public int getFilterSize() {
            return 9;
        }

        public class_2487 serializeNBT() {
            class_2487 tag = new class_2487();
            tag.method_10544("TargetPos", this.targetPos.method_10063());
            tag.method_10569("Side", this.side != null ? this.side.ordinal() : -1);
            tag.method_10569("Mode", this.mode.ordinal());
            tag.method_10569("Quantity", this.quantity);
            class_2499 filterList = new class_2499();
            for (int i = 0; i < 9; ++i) {
                if (this.filters[i].method_7960()) continue;
                class_2487 filterTag = new class_2487();
                filterTag.method_10569("Slot", i);
                filterTag.method_10566("Item", (class_2520)this.filters[i].method_7953(new class_2487()));
                filterList.add((Object)filterTag);
            }
            tag.method_10566("Filters", (class_2520)filterList);
            return tag;
        }

        public void deserializeNBT(class_2487 tag) {
            this.targetPos = class_2338.method_10092((long)tag.method_10537("TargetPos"));
            int sideOrdinal = tag.method_10550("Side");
            this.side = sideOrdinal >= 0 && sideOrdinal < class_2350.values().length ? class_2350.values()[sideOrdinal] : null;
            this.mode = TransportMode.values()[tag.method_10550("Mode")];
            this.quantity = tag.method_10550("Quantity");
            for (int i = 0; i < 9; ++i) {
                this.filters[i] = class_1799.field_8037;
            }
            class_2499 filterList = tag.method_10554("Filters", 10);
            for (int i = 0; i < filterList.size(); ++i) {
                class_2487 filterTag = filterList.method_10602(i);
                int slot = filterTag.method_10550("Slot");
                if (slot < 0 || slot >= 9) continue;
                this.filters[slot] = class_1799.method_7915((class_2487)filterTag.method_10562("Item"));
            }
        }

        private boolean depositItemsToWarehouse(TransportWorkstationBlockEntity workstation, WarehouseControlBlockEntity warehouse) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (class_1799 filter : this.filters) {
                if (filter.method_7960()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<class_1799> availableFilters = new ArrayList<class_1799>();
            if (allFiltersEmpty) {
                for (int i = 0; i < workstation.method_5439(); ++i) {
                    class_1799 stack = workstation.method_5438(i);
                    if (stack.method_7960() || this.quantity > 0 && warehouse.getItemCount(stack) >= this.quantity) continue;
                    boolean alreadyAdded = false;
                    for (class_1799 existing : availableFilters) {
                        if (!class_1799.method_31577((class_1799)existing, (class_1799)stack)) continue;
                        alreadyAdded = true;
                        break;
                    }
                    if (alreadyAdded) continue;
                    availableFilters.add(stack.method_7972());
                }
            } else {
                for (class_1799 filter : this.filters) {
                    int currentCountInWarehouse;
                    if (filter.method_7960() || !this.hasItemInContainer((class_1263)workstation, filter) || this.quantity > 0 && (currentCountInWarehouse = warehouse.getItemCount(filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            for (int i = 0; i < 5; ++i) {
                class_1799 selectedFilter = (class_1799)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                class_1799 extracted = this.extractOneItem((class_1263)workstation, selectedFilter);
                if (!extracted.method_7960()) {
                    class_1799 remaining = warehouse.tryAddItem(extracted);
                    if (remaining.method_7960()) {
                        movedAny = true;
                    } else if (remaining.method_7947() < extracted.method_7947()) {
                        movedAny = true;
                        remaining = this.addItemToContainer((class_1263)workstation, remaining);
                    } else {
                        remaining = this.addItemToContainer((class_1263)workstation, remaining);
                        availableFilters.remove(selectedFilter);
                        if (availableFilters.isEmpty()) break;
                        --i;
                    }
                }
                if (this.quantity <= 0 || warehouse.getItemCount(selectedFilter) < this.quantity) continue;
                availableFilters.remove(selectedFilter);
                if (availableFilters.isEmpty()) break;
            }
            return movedAny;
        }

        private boolean withdrawItemsFromWarehouse(WarehouseControlBlockEntity warehouse, TransportWorkstationBlockEntity workstation) {
            boolean movedAny = false;
            int MAX_ITEMS_PER_WORK = 5;
            boolean allFiltersEmpty = true;
            for (class_1799 filter : this.filters) {
                if (filter.method_7960()) continue;
                allFiltersEmpty = false;
                break;
            }
            ArrayList<Object> availableFilters = new ArrayList<Object>();
            if (allFiltersEmpty) {
                for (class_1799 type : warehouse.getAvailableItemTypes()) {
                    if (warehouse.getItemCount(type) <= 0 || this.quantity > 0 && this.countItemsInContainer((class_1263)workstation, type) >= this.quantity) continue;
                    availableFilters.add(type);
                }
            } else {
                for (class_1799 filter : this.filters) {
                    int currentCountInWorkstation;
                    if (filter.method_7960() || warehouse.getItemCount(filter) <= 0 || this.quantity > 0 && (currentCountInWorkstation = this.countItemsInContainer((class_1263)workstation, filter)) >= this.quantity) continue;
                    availableFilters.add(filter);
                }
            }
            if (availableFilters.isEmpty()) {
                return false;
            }
            for (int i = 0; i < 5; ++i) {
                class_1799 selectedFilter = (class_1799)availableFilters.get(RANDOM.nextInt(availableFilters.size()));
                class_1799 request = selectedFilter.method_7972();
                request.method_7939(1);
                class_1799 extracted = warehouse.tryExtractItem(request);
                if (!extracted.method_7960()) {
                    class_1799 remaining = this.addItemToContainer((class_1263)workstation, extracted);
                    if (remaining.method_7960()) {
                        movedAny = true;
                    } else if (remaining.method_7947() < extracted.method_7947()) {
                        movedAny = true;
                    }
                    if (!remaining.method_7960()) {
                        warehouse.tryAddItem(remaining);
                        availableFilters.remove(selectedFilter);
                        if (availableFilters.isEmpty()) break;
                        --i;
                    }
                } else {
                    availableFilters.remove(selectedFilter);
                    if (availableFilters.isEmpty()) break;
                    --i;
                }
                if (this.quantity <= 0 || this.countItemsInContainer((class_1263)workstation, selectedFilter) < this.quantity) continue;
                availableFilters.remove(selectedFilter);
                if (availableFilters.isEmpty()) break;
            }
            return movedAny;
        }

        private class_1799 extractOneItem(class_1263 container, class_1799 filter) {
            for (int slot = 0; slot < container.method_5439(); ++slot) {
                class_1799 stack = container.method_5438(slot);
                if (stack.method_7960() || !class_1799.method_31577((class_1799)stack, (class_1799)filter)) continue;
                return container.method_5434(slot, 1);
            }
            return class_1799.field_8037;
        }

        private class_1799 addItemToContainer(class_1263 container, class_1799 itemToAdd) {
            class_1799 remaining = itemToAdd.method_7972();
            for (int slot = 0; slot < container.method_5439() && !remaining.method_7960(); ++slot) {
                int space;
                int toAdd;
                if (!container.method_5437(slot, remaining)) continue;
                class_1799 slotStack = container.method_5438(slot);
                if (slotStack.method_7960()) {
                    container.method_5447(slot, remaining.method_7972());
                    remaining.method_7939(0);
                    continue;
                }
                if (!class_1799.method_31577((class_1799)slotStack, (class_1799)remaining) || (toAdd = Math.min(space = slotStack.method_7914() - slotStack.method_7947(), remaining.method_7947())) <= 0) continue;
                slotStack.method_7933(toAdd);
                remaining.method_7934(toAdd);
            }
            return remaining;
        }
    }

    public static enum TransportMode {
        DEPOSIT("transport.mode.deposit"),
        WITHDRAW("transport.mode.withdraw");

        private final String translationKey;

        private TransportMode(String translationKey) {
            this.translationKey = translationKey;
        }

        public String getTranslationKey() {
            return this.translationKey;
        }

        public TransportMode toggle() {
            return this == DEPOSIT ? WITHDRAW : DEPOSIT;
        }
    }
}

