/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.Random;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1376;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1665;
import net.minecraft.class_1675;
import net.minecraft.class_1738;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CounterRanged;
import ydmsama.hundred_years_war.main.entity.entities.tags.LightUnit;
import ydmsama.hundred_years_war.main.entity.entities.tags.RangedUnit;
import ydmsama.hundred_years_war.main.entity.goals.HywWaterAvoidingRandomStrollGoal;
import ydmsama.hundred_years_war.main.entity.goals.SkyExposedTargetGoal;
import ydmsama.hundred_years_war.main.entity.utils.BackItemHolder;
import ydmsama.hundred_years_war.main.entity.utils.MeleeCapableRangedAttacker;
import ydmsama.hundred_years_war.main.entity.utils.Mountable;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;
import ydmsama.hundred_years_war.main.utils.WeaponTypeHelper;

public class HywSkeletonArcherEntity
extends BaseCombatEntity
implements class_1603,
MeleeCapableRangedAttacker,
BackItemHolder,
LightUnit,
RangedUnit,
CounterRanged,
Mountable {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.5f;
    private float currentSpeed = 0.3f;
    private static final class_2940<Integer> USE_ANGLE = class_2945.method_12791(HywSkeletonArcherEntity.class, (class_2941)class_2943.field_13327);
    private static final class_2940<class_1799> WEAPON_RANGED = class_2945.method_12791(HywSkeletonArcherEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<class_1799> WEAPON_MELEE = class_2945.method_12791(HywSkeletonArcherEntity.class, (class_2941)class_2943.field_13322);
    private static final class_2940<Boolean> IS_USING_RANGED = class_2945.method_12791(HywSkeletonArcherEntity.class, (class_2941)class_2943.field_13323);
    private int noTargetTicks = 0;
    private static final int SWITCH_THRESHOLD = 100;

    public HywSkeletonArcherEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
    }

    @Override
    protected void method_5693() {
        super.method_5693();
        this.field_6011.method_12784(USE_ANGLE, (Object)1);
        this.field_6011.method_12784(WEAPON_RANGED, (Object)new class_1799((class_1935)class_1802.field_8102));
        this.field_6011.method_12784(WEAPON_MELEE, (Object)new class_1799((class_1935)class_1802.field_8371));
        this.field_6011.method_12784(IS_USING_RANGED, (Object)true);
    }

    public class_1799 getRangedWeapon() {
        return (class_1799)this.field_6011.method_12789(WEAPON_RANGED);
    }

    public void setRangedWeapon(class_1799 stack) {
        this.field_6011.method_12778(WEAPON_RANGED, (Object)stack);
    }

    public class_1799 getMeleeWeapon() {
        return (class_1799)this.field_6011.method_12789(WEAPON_MELEE);
    }

    public void setMeleeWeapon(class_1799 stack) {
        this.field_6011.method_12778(WEAPON_MELEE, (Object)stack);
    }

    @Override
    public boolean isUsingRanged() {
        return (Boolean)this.field_6011.method_12789(IS_USING_RANGED);
    }

    @Override
    public void setUsingRanged(boolean usingRanged) {
        boolean wasUsingRanged = this.isUsingRanged();
        this.field_6011.method_12778(IS_USING_RANGED, (Object)usingRanged);
        this.method_5673(class_1304.field_6173, usingRanged ? this.getRangedWeapon() : this.getMeleeWeapon());
    }

    @Override
    public class_1799 getBackItem() {
        return this.isUsingRanged() ? this.getMeleeWeapon() : this.getRangedWeapon();
    }

    @Override
    public void setBackItem(class_1799 itemStack) {
        if (this.isUsingRanged()) {
            this.setMeleeWeapon(itemStack);
        } else {
            this.setRangedWeapon(itemStack);
        }
    }

    @Override
    public boolean shouldRenderBackItem() {
        return !this.getBackItem().method_7960();
    }

    @Override
    public float getMeleeAttackReach() {
        return 2.5f;
    }

    public static class_5132.class_5133 createHywSkeletonArcherAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 2.0).method_26868(class_5134.field_23716, 20.0).method_26868(class_5134.field_23718, 0.4).method_26868(HywAttributes.ATTACK_REACH, 100.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 2.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (this.getHywTarget() != null) {
                this.noTargetTicks = 0;
                double distanceToTarget = this.method_5858((class_1297)this.getHywTarget());
                if (distanceToTarget < 30.0) {
                    if (this.isUsingRanged()) {
                        this.setUsingRanged(false);
                    }
                } else if (distanceToTarget > 35.0 && !this.isUsingRanged()) {
                    this.setUsingRanged(true);
                }
            } else {
                ++this.noTargetTicks;
                if (this.noTargetTicks >= 100 && !this.isUsingRanged()) {
                    this.setUsingRanged(true);
                    this.noTargetTicks = 0;
                }
            }
        }
    }

    @Override
    public float getAttackReach() {
        if (this.isUsingRanged()) {
            return super.getAttackReach();
        }
        return this.getMeleeAttackReach();
    }

    @Override
    protected void setDefaultEquipment() {
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return this.isUsingRanged() ? 15 : 6;
    }

    @Override
    public int getAttackDamageTickDelay() {
        Random random = new Random();
        return this.isUsingRanged() ? Math.max(this.getBaseAttackAnimationTime() - random.nextInt(5), 5) : 5;
    }

    @Override
    public int getAttackCoolDownDuration() {
        Random random = new Random();
        return this.isUsingRanged() ? 3 + random.nextInt(8) : 1 + random.nextInt(5);
    }

    public void method_7105(class_1309 target, float pullProgress) {
        double dy;
        double dz;
        double dx;
        double distance;
        if (!this.isUsingRanged()) {
            return;
        }
        class_1665 arrow = class_1675.method_18813((class_1309)this, (class_1799)new class_1799((class_1935)class_1802.field_8107), (float)pullProgress);
        arrow.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        class_1799 bowStack = this.getRangedWeapon();
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)bowStack);
        int punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)bowStack);
        int flameLevel = class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)bowStack);
        if (powerLevel > 0) {
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        if (punchLevel > 0) {
            arrow.method_7449(punchLevel);
        }
        if (flameLevel > 0) {
            arrow.method_5639(100);
        }
        if ((distance = Math.sqrt((dx = target.method_23317() - this.method_23317()) * dx + (dz = target.method_23321() - this.method_23321()) * dz + (dy = target.method_23323(0.5) - arrow.method_23318()) * dy)) == 0.0) {
            return;
        }
        float speed = 2.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float maxArrowSpeed = 3.0f;
        float miss = 2.5f;
        this.setUseAngle(-1);
        while (speed <= maxArrowSpeed) {
            double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
            if (!(this.isObstructed(target) && !this.method_5765() || Double.isNaN(angles[1]) && !(distance < 5.0))) {
                angle = angles[1];
                this.setUseAngle(1);
                break;
            }
            if (!Double.isNaN(angles[0]) && this.isPathClear(arrow, angles[0], speed, dx, dy, dz, distance, target)) {
                angle = angles[0];
                this.setUseAngle(0);
                break;
            }
            if (!((speed += 0.25f) > maxArrowSpeed)) continue;
            break;
        }
        if (this.getUseAngle() == -1) {
            return;
        }
        double randomSpeedOffset = HywSkeletonArcherEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
        double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.method_23317()) * (predictedX - this.method_23317()) + (predictedZ - this.method_23321()) * (predictedZ - this.method_23321()));
        double[] angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[this.getUseAngle()];
        dx = predictedX - this.method_23317();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.method_23321()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        if (this.getUseAngle() == 0) {
            miss = 3.5f;
            arrow.method_7438(3.0);
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        arrow.method_7485((double)velocityX, (double)velocityY, (double)velocityZ, speed, miss);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
        this.method_6021();
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private boolean isTargetExposedToSky(class_1309 target) {
        class_2338 targetPos = target.method_24515();
        for (int x = -1; x <= 1; ++x) {
            for (int z = -1; z <= 1; ++z) {
                class_2338 posToCheck = targetPos.method_10069(x, 0, z);
                if (!this.method_37908().method_8311(posToCheck)) continue;
                return true;
            }
        }
        return false;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }

    public int getUseAngle() {
        return (Integer)this.field_6011.method_12789(USE_ANGLE);
    }

    public void setUseAngle(int useAngle) {
        this.field_6011.method_12778(USE_ANGLE, (Object)useAngle);
    }

    public static double getRandomInRange(double min, double max) {
        return min + Math.random() * (max - min);
    }

    @Override
    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(5, (class_1352)new HywWaterAvoidingRandomStrollGoal(this, 0.75));
        this.field_6201.method_6277(6, (class_1352)new class_1361((class_1308)this, class_1657.class, 4.0f));
        this.field_6201.method_6277(7, (class_1352)new class_1376((class_1308)this));
    }

    @Override
    public void addTargetSelector() {
        Predicate<class_1309> unifiedPredicate = this::isValidTarget;
        this.field_6185.method_6277(1, (class_1352)new SkyExposedTargetGoal(this, class_1309.class, 10, true, false, unifiedPredicate));
    }

    public boolean isShaking() {
        return false;
    }

    @Override
    public class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_SKELETON_ARCHER;
            case 2 -> HywItemRegistry.SCROLL_SKELETON_ARCHER_1;
            case 3 -> HywItemRegistry.SCROLL_SKELETON_ARCHER_2;
            case 4 -> HywItemRegistry.SCROLL_SKELETON_ARCHER_3;
            default -> null;
        };
    }

    @Override
    protected void setEquipmentFromLevelData(EquipmentLevelData levelData) {
        EquipmentOption meleeWeaponOption;
        EquipmentOption rangedWeaponOption;
        super.setEquipmentFromLevelData(levelData);
        if (levelData.getRangedWeapon() != null && !levelData.getRangedWeapon().isEmpty() && (rangedWeaponOption = this.selectRandomItem(levelData.getRangedWeapon())) != null) {
            class_1799 rangedWeaponStack = this.createItemStack(rangedWeaponOption);
            this.setRangedWeapon(rangedWeaponStack);
        }
        if (levelData.getMeleeWeapon() != null && !levelData.getMeleeWeapon().isEmpty() && (meleeWeaponOption = this.selectRandomItem(levelData.getMeleeWeapon())) != null) {
            class_1799 meleeWeaponStack = this.createItemStack(meleeWeaponOption);
            this.setMeleeWeapon(meleeWeaponStack);
        }
        this.setUsingRanged(true);
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        class_2487 rangedWeaponTag = new class_2487();
        this.getRangedWeapon().method_7953(rangedWeaponTag);
        compound.method_10566("RangedWeapon", (class_2520)rangedWeaponTag);
        class_2487 meleeWeaponTag = new class_2487();
        this.getMeleeWeapon().method_7953(meleeWeaponTag);
        compound.method_10566("MeleeWeapon", (class_2520)meleeWeaponTag);
        compound.method_10556("IsUsingRanged", this.isUsingRanged());
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("RangedWeapon")) {
            class_2487 rangedWeaponTag = compound.method_10562("RangedWeapon");
            class_1799 rangedWeaponStack = class_1799.method_7915((class_2487)rangedWeaponTag);
            this.setRangedWeapon(rangedWeaponStack);
        }
        if (compound.method_10545("MeleeWeapon")) {
            class_2487 meleeWeaponTag = compound.method_10562("MeleeWeapon");
            class_1799 meleeWeaponStack = class_1799.method_7915((class_2487)meleeWeaponTag);
            this.setMeleeWeapon(meleeWeaponStack);
        }
        if (compound.method_10545("IsUsingRanged")) {
            boolean isUsingRanged = compound.method_10577("IsUsingRanged");
            this.setUsingRanged(isUsingRanged);
            this.method_5673(class_1304.field_6173, isUsingRanged ? this.getRangedWeapon() : this.getMeleeWeapon());
        }
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        class_1657 player;
        class_1297 class_12972 = source.method_5529();
        if (class_12972 instanceof class_1657 && (player = (class_1657)class_12972).method_5715() && ServerRelationHelper.hasControlOver(player, (class_1297)this) && ServerModConfig.INSTANCE.isAllowEquipmentChange()) {
            class_1738 armorItem;
            class_1304 slot;
            class_1799 playerItem = player.method_5998(class_1268.field_5808);
            class_1792 class_17922 = playerItem.method_7909();
            if (class_17922 instanceof class_1738 && ((slot = (armorItem = (class_1738)class_17922).method_7685()) == class_1304.field_6172 || slot == class_1304.field_6166)) {
                return false;
            }
            if (WeaponTypeHelper.isBowLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                class_1799 entityItem = this.getRangedWeapon();
                this.setRangedWeapon(playerItem.method_7972());
                if (this.isUsingRanged()) {
                    this.method_5673(class_1304.field_6173, playerItem.method_7972());
                }
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
            if (WeaponTypeHelper.isSwordLikeWeapon(playerItem) || WeaponTypeHelper.isAxeLikeWeapon(playerItem)) {
                long currentTime = System.currentTimeMillis();
                if (currentTime - this.lastWeaponReplaceTime < 1000L) {
                    return false;
                }
                class_1799 entityItem = this.getMeleeWeapon();
                this.setMeleeWeapon(playerItem.method_7972());
                if (!this.isUsingRanged()) {
                    this.method_5673(class_1304.field_6173, playerItem.method_7972());
                }
                player.method_6122(class_1268.field_5808, class_1799.field_8037);
                if (!entityItem.method_7960()) {
                    player.method_6122(class_1268.field_5808, entityItem);
                }
                this.lastWeaponReplaceTime = currentTime;
                return false;
            }
        }
        return super.method_5643(source, amount);
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_15069;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14877;
    }

    protected class_3414 method_5994() {
        return class_3417.field_15200;
    }

    @NotNull
    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        class_1324 rangedAttackDamage = this.method_5996(HywAttributes.RANGED_ATTACK_DAMAGE);
        if (rangedAttackDamage != null) {
            rangedAttackDamage.method_6192(rangedAttackDamage.method_6201() + 0.1);
        }
    }

    @Override
    public double getRangedDamageModifier() {
        return 1.5;
    }
}

