/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import com.google.gson.Gson;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_7923;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentLevelData;
import ydmsama.hundred_years_war.main.entity.utils.json.EquipmentOption;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class HywSkeletonHorseEntity
extends HywHorseEntity {
    private int equipmentLevel = 1;
    private UUID ownerUUID;
    private class_2338 homePosition;
    private static EquipmentData equipmentData;
    private final Random random = new Random();
    private boolean requiresSupply = true;

    public HywSkeletonHorseEntity(class_1299<? extends HywHorseEntity> entityType, class_1937 level) {
        super(entityType, level);
    }

    public static class_5132.class_5133 createSkeletonHorseAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23719, 0.225).method_26868(class_5134.field_23716, 26.0).method_26868(class_5134.field_23728, 0.8).method_26868(class_5134.field_23717, 16.0);
    }

    protected class_3414 method_5994() {
        return class_3417.field_14984;
    }

    protected class_3414 method_6011(class_1282 damageSource) {
        return class_3417.field_14855;
    }

    protected class_3414 method_6002() {
        return class_3417.field_14721;
    }

    @Override
    public class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_SKELETON_HORSE;
            case 2 -> HywItemRegistry.SCROLL_SKELETON_HORSE_1;
            case 3 -> HywItemRegistry.SCROLL_SKELETON_HORSE_2;
            case 4 -> HywItemRegistry.SCROLL_SKELETON_HORSE_3;
            default -> null;
        };
    }

    @Override
    public void setEquipment(int level) {
        this.equipmentLevel = level;
        this.loadEquipmentData();
        this.applyEquipment(level);
    }

    @Override
    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    @Override
    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    @Override
    public void method_6732(UUID uuid) {
        this.ownerUUID = uuid;
    }

    @Override
    public UUID method_6139() {
        return this.ownerUUID;
    }

    @Override
    public void setHomePosition(class_2338 homePosition) {
        this.homePosition = homePosition;
    }

    @Override
    public class_2338 getHomePosition() {
        return this.homePosition;
    }

    @Override
    public class_1309 asLivingEntity() {
        return this;
    }

    @Override
    protected String getEquipmentJsonPath() {
        String entityName = "hyw_horse";
        String equipmentFile = ServerModConfig.getCurrentEquipmentFileName();
        return "hundred_years_war:hyw/npc/" + entityName + "/" + equipmentFile;
    }

    @Override
    protected void loadEquipmentData() {
        String configResourcePath = this.getEquipmentJsonPath();
        if (configResourcePath == null) {
            return;
        }
        String[] parts = configResourcePath.split(":");
        if (parts.length != 2) {
            return;
        }
        String namespace = parts[0];
        String path = parts[1];
        String fullPath = "/assets/" + namespace + "/" + path;
        try (InputStream is = this.getClass().getResourceAsStream(fullPath);){
            if (is == null) {
                return;
            }
            try (InputStreamReader reader = new InputStreamReader(is);){
                Gson gson = new Gson();
                equipmentData = (EquipmentData)gson.fromJson((Reader)reader, EquipmentData.class);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @Override
    protected EquipmentOption selectRandomItem(List<EquipmentOption> options) {
        if (options == null || options.isEmpty()) {
            return null;
        }
        double total = 0.0;
        for (EquipmentOption option : options) {
            total += option.getProbability();
        }
        double value = this.random.nextDouble() * total;
        double cumulative = 0.0;
        for (EquipmentOption option : options) {
            if (!(value <= (cumulative += option.getProbability()))) continue;
            return option;
        }
        return null;
    }

    private void applyEquipment(int level) {
        class_1792 armorItem;
        EquipmentOption armorOption;
        if (equipmentData == null) {
            return;
        }
        EquipmentLevelData levelData = equipmentData.getLevels().get(String.valueOf(level));
        if (levelData == null) {
            return;
        }
        List<EquipmentOption> horseArmor = levelData.getHorseArmor();
        if (horseArmor != null && (armorOption = this.selectRandomItem(horseArmor)) != null && armorOption.getItem() != null && (armorItem = class_7923.field_41178.method_17966(new class_2960(armorOption.getItem())).orElse(class_1802.field_8162)) != class_1802.field_8162 && this.field_6962 != null) {
            this.field_6962.method_5447(1, new class_1799((class_1935)armorItem));
            this.method_6731();
        }
    }

    @Override
    public boolean requiresSupply() {
        return this.requiresSupply;
    }

    @Override
    public void setRequiresSupply(boolean requires) {
        this.requiresSupply = requires;
    }

    @Override
    public double getDailySupplyConsumption() {
        return 2.0;
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10569("EquipmentLevel", this.equipmentLevel);
        if (this.ownerUUID != null) {
            compound.method_25927("OwnerUUID", this.ownerUUID);
        }
        if (this.homePosition != null) {
            compound.method_10569("HomeX", this.homePosition.method_10263());
            compound.method_10569("HomeY", this.homePosition.method_10264());
            compound.method_10569("HomeZ", this.homePosition.method_10260());
        }
        compound.method_10556("RequiresSupply", this.requiresSupply);
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        if (compound.method_10545("EquipmentLevel")) {
            this.equipmentLevel = compound.method_10550("EquipmentLevel");
        }
        if (compound.method_25928("OwnerUUID")) {
            this.ownerUUID = compound.method_25926("OwnerUUID");
        }
        if (compound.method_10545("HomeX")) {
            this.homePosition = new class_2338(compound.method_10550("HomeX"), compound.method_10550("HomeY"), compound.method_10550("HomeZ"));
        }
        this.requiresSupply = compound.method_10577("RequiresSupply");
    }
}

