/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities;

import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1310;
import net.minecraft.class_1314;
import net.minecraft.class_1324;
import net.minecraft.class_1352;
import net.minecraft.class_1400;
import net.minecraft.class_1496;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3218;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.HywHorseEntity;
import ydmsama.hundred_years_war.main.entity.entities.HywSkeletonArcherEntity;
import ydmsama.hundred_years_war.main.entity.entities.tags.CavalryUnit;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;
import ydmsama.hundred_years_war.main.item.BaseScrollItem;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywEntityRegistry;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class HywSkeletonMountedArcherEntity
extends HywSkeletonArcherEntity
implements HorseRider,
CavalryUnit {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.32f;
    private static final float BASE_RANGED_ATTACK_DAMAGE = 2.5f;
    private static final int SWITCH_THRESHOLD = 100;
    private boolean horseSpawned = false;
    private class_1496 mountedHorse;
    private UUID horseUUID;
    private class_2487 savedHorseData;
    private boolean needsHorseSpawn = false;
    private int noTargetTicks = 0;
    private static final double RIDING_OFFSET_FACTOR = 0.4;

    public HywSkeletonMountedArcherEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createSkeletonMountedArcherAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.32f).method_26868(class_5134.field_23721, 8.0).method_26868(class_5134.field_23724, 4.0).method_26868(class_5134.field_23716, 22.0).method_26868(class_5134.field_23718, 0.5).method_26868(HywAttributes.ATTACK_REACH, 100.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 2.5);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().method_8608()) {
            if (this.getHywTarget() != null) {
                this.noTargetTicks = 0;
                this.setUsingRanged(this.method_5858((class_1297)this.getHywTarget()) > 30.0);
            } else if (!this.isUsingRanged()) {
                ++this.noTargetTicks;
                if (this.noTargetTicks >= 100) {
                    this.setUsingRanged(true);
                    this.noTargetTicks = 0;
                }
            }
        }
        if (!this.method_37908().field_9236 && this.needsHorseSpawn && this.method_5805()) {
            this.spawnHorse();
            this.needsHorseSpawn = false;
        } else if (!this.method_37908().field_9236 && !this.horseSpawned && this.method_5805() && !this.method_5765()) {
            this.spawnHorse();
        }
        if (!this.method_37908().field_9236 && this.horseSpawned && this.mountedHorse == null && this.horseUUID != null) {
            for (class_1297 entity : this.method_37908().method_18467(class_1496.class, this.method_5829().method_1014(10.0))) {
                if (!entity.method_5667().equals(this.horseUUID)) continue;
                this.mountedHorse = (class_1496)entity;
                if (this.method_5765()) break;
                this.method_5873((class_1297)this.mountedHorse, true);
                break;
            }
        }
    }

    @Override
    public float getAttackReach() {
        if (this.isUsingRanged()) {
            return super.getAttackReach();
        }
        return this.getMeleeAttackReach();
    }

    @Override
    public double getRidingOffsetFactor() {
        return 0.4;
    }

    private void spawnHorse() {
        this.mountedHorse = this.createHorseEntity();
        if (this.mountedHorse != null) {
            this.mountedHorse.method_5814(this.method_23317(), this.method_23318(), this.method_23321());
            class_1496 class_14962 = this.mountedHorse;
            if (class_14962 instanceof BaseCombatSupport) {
                BaseCombatSupport support = (BaseCombatSupport)class_14962;
                support.method_6732(this.method_6139());
                support.setEquipment(this.getEquipmentLevel());
            }
            if ((class_14962 = this.mountedHorse) instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)class_14962;
                hywHorse.setRiderEntity(this);
                hywHorse.setNpcHorse(true);
            }
            if (this.savedHorseData != null) {
                try {
                    this.mountedHorse.method_5749(this.savedHorseData);
                    this.savedHorseData = null;
                }
                catch (Exception e) {
                    System.err.println("Failed to restore horse data: " + e.getMessage());
                }
            }
            this.method_37908().method_8649((class_1297)this.mountedHorse);
            this.method_5873((class_1297)this.mountedHorse, true);
            this.horseSpawned = true;
            this.horseUUID = this.mountedHorse.method_5667();
        }
    }

    protected class_1496 createHorseEntity() {
        return (class_1496)HywEntityRegistry.HYW_SKELETON_HORSE.method_5883(this.method_37908());
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("HorseSpawned", this.horseSpawned);
        if (this.horseUUID != null) {
            compound.method_25927("HorseUUID", this.horseUUID);
        }
        if (this.savedHorseData != null) {
            compound.method_10566("SavedHorseData", (class_2520)this.savedHorseData);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        super.method_5749(compound);
        this.horseSpawned = compound.method_10577("HorseSpawned");
        if (compound.method_25928("HorseUUID")) {
            this.horseUUID = compound.method_25926("HorseUUID");
        }
        if (compound.method_10545("SavedHorseData")) {
            this.savedHorseData = compound.method_10562("SavedHorseData");
            this.needsHorseSpawn = true;
            this.horseSpawned = false;
        }
    }

    @Override
    public class_1792 getScrollType() {
        return switch (this.getEquipmentLevel()) {
            case 1 -> HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER;
            case 2 -> HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER_1;
            case 3 -> HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER_2;
            case 4 -> HywItemRegistry.SCROLL_SKELETON_MOUNTED_ARCHER_3;
            default -> null;
        };
    }

    @Override
    protected void increaseStatsOnLevelUp() {
        super.increaseStatsOnLevelUp();
        class_1324 rangedAttackDamage = this.method_5996(HywAttributes.RANGED_ATTACK_DAMAGE);
        if (rangedAttackDamage != null) {
            rangedAttackDamage.method_6192(rangedAttackDamage.method_6201() + 0.1);
        }
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (player.method_5715() && hand == class_1268.field_5808) {
            if ((ServerModConfig.INSTANCE.isAllowSoldierRecall() || player.method_7337() && CreativeModeSettings.canControlAllUnits(player)) && this.getScrollType() != null) {
                return this.handleScrollConversion(player);
            }
            return class_1269.field_5811;
        }
        return super.method_5992(player, hand);
    }

    private class_1269 handleScrollConversion(class_1657 player) {
        class_1799 stack = new class_1799((class_1935)this.getScrollType());
        class_2487 entityData = new class_2487();
        if (this.mountedHorse != null && this.mountedHorse.method_5805()) {
            class_2487 horseData = new class_2487();
            this.method_5848();
            class_1496 class_14962 = this.mountedHorse;
            if (class_14962 instanceof HywHorseEntity) {
                HywHorseEntity hywHorse = (HywHorseEntity)class_14962;
                hywHorse.setRiderEntity(null);
            }
            this.mountedHorse.method_5647(horseData);
            entityData.method_10566("SavedHorseData", (class_2520)horseData);
            this.mountedHorse.method_31472();
            this.mountedHorse = null;
        }
        this.method_5647(entityData);
        ((BaseScrollItem)stack.method_7909()).saveEntityDataToItem(stack, entityData);
        if (!player.method_31548().method_7394(stack)) {
            player.method_7328(stack, false);
        }
        this.spawnDespawnParticles();
        this.method_31472();
        return class_1269.field_5812;
    }

    private void spawnDespawnParticles() {
        class_1937 class_19372 = this.method_37908();
        if (class_19372 instanceof class_3218) {
            class_3218 serverLevel = (class_3218)class_19372;
            for (int i = 0; i < 40; ++i) {
                double offsetX = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = this.method_37908().field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (this.method_37908().field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, this.method_23317(), this.method_23318() + 0.5, this.method_23321(), 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    @Override
    public void addTargetSelector() {
        Predicate<class_1309> unifiedPredicate = this::isValidTarget;
        this.field_6185.method_6277(1, (class_1352)new class_1400((class_1308)this, class_1309.class, 10, true, false, unifiedPredicate));
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        if (this.mountedHorse != null && this.mountedHorse.method_5805()) {
            this.mountedHorse.method_5768();
        }
        super.method_6078(damageSource);
    }

    @Override
    public boolean method_5643(class_1282 source, float amount) {
        if (this.mountedHorse != null && this.mountedHorse.method_5805()) {
            this.mountedHorse.method_5643(source, 0.0f);
        }
        return super.method_5643(source, amount);
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    @Override
    public class_1309 asLivingEntity() {
        return this;
    }

    @Override
    public boolean hasValidTarget() {
        return this.getHywTarget() != null;
    }

    @Override
    public class_1310 method_6046() {
        return class_1310.field_6289;
    }

    @Override
    public float getRotationLimit() {
        return 30.0f;
    }
}

