/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.siege;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1352;
import net.minecraft.class_1603;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3481;
import net.minecraft.class_3532;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.action.PositionAttackAction;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.entity.entities.siege.UnloadPassengerable;
import ydmsama.hundred_years_war.main.entity.entities.tags.SiegeUnit;
import ydmsama.hundred_years_war.main.entity.goals.BaseCombatEntityAttackGoal;
import ydmsama.hundred_years_war.main.entity.goals.FollowEntityGoal;
import ydmsama.hundred_years_war.main.entity.goals.PatrolGoal;
import ydmsama.hundred_years_war.main.entity.goals.ReturnToHomeGoal;
import ydmsama.hundred_years_war.main.entity.utils.MultiSeatVehicle;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class BatteringRamEntity
extends BaseCombatEntity
implements SiegeUnit,
class_1603,
PositionAttackable,
MultiSeatVehicle,
UnloadPassengerable {
    private static final float MOVEMENT_SPEED = 0.18f;
    private static final float ATTACK_REACH = 6.0f;
    private static final float MAX_DESTROYABLE_HARDNESS = 50.0f;
    private static final double DESTRUCTION_VALUE_PER_ATTACK = 30.0;
    private static final int MANDATORY_MARGIN = 1;
    private static final int INFLUENCE_MARGIN = 3;
    private static final int EXTRA_HEIGHT_TOP = 2;
    private static final class_2940<class_2338> TARGET_POS = class_2945.method_12791(BatteringRamEntity.class, (class_2941)class_2943.field_13324);
    private static final class_2940<Boolean> HAS_POSITION_TARGET = class_2945.method_12791(BatteringRamEntity.class, (class_2941)class_2943.field_13323);
    private class_243 positionTarget;
    private PositionAttackAction positionAttackAction;
    private final List<MultiSeatVehicle.Seat> seats = new ArrayList<MultiSeatVehicle.Seat>();
    private final Map<class_1297, MultiSeatVehicle.Seat> entitySeatMap = new HashMap<class_1297, MultiSeatVehicle.Seat>();
    private static final int MAX_PASSENGERS = 8;
    private class_243 unloadTarget;
    private static final double MAX_UNLOAD_DISTANCE = 4.0;
    private static final double UNLOAD_HEIGHT_RANGE = 10.0;
    private int unloadInitDelay = 0;
    private int unloadInterval = 0;
    private static final int UNLOAD_INIT_DELAY = 20;
    private static final int UNLOAD_INTERVAL = 15;

    public BatteringRamEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
        this.method_49477(1.0f);
        this.field_6011.method_12784(TARGET_POS, (Object)class_2338.field_10980);
        this.field_6011.method_12784(HAS_POSITION_TARGET, (Object)false);
        this.positionAttackAction = new PositionAttackAction();
        this.positionTarget = null;
        this.initializeSeats();
    }

    private void initializeSeats() {
        this.seats.clear();
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.PLAYER, new class_243(0.0, 0.5, 0.0), false, MultiSeatVehicle.SeatPose.SITTING));
        this.seats.add(new MultiSeatVehicle.Seat(MultiSeatVehicle.SeatType.INTERNAL, new class_243(0.0, 0.5, 0.0), true, MultiSeatVehicle.SeatPose.SITTING));
    }

    @Override
    public List<MultiSeatVehicle.Seat> getAllSeats() {
        return new ArrayList<MultiSeatVehicle.Seat>(this.seats);
    }

    @Override
    public int getMaxPassengers() {
        return 8;
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> assignSeat(class_1297 entity) {
        MultiSeatVehicle.SeatType[] preferredTypes;
        if (this.entitySeatMap.containsKey(entity)) {
            MultiSeatVehicle.Seat currentSeat = this.entitySeatMap.get(entity);
            if (currentSeat.getType() == MultiSeatVehicle.SeatType.INTERNAL && entity instanceof class_1309 && this.isRangedUnit((class_1309)entity)) {
                for (MultiSeatVehicle.Seat seat : this.seats) {
                    if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(entity)) continue;
                    if (!currentSeat.isAllowMultiple()) {
                        currentSeat.setOccupant(null);
                    }
                    if (!seat.isAllowMultiple()) {
                        seat.setOccupant(entity);
                    }
                    this.entitySeatMap.put(entity, seat);
                    return Optional.of(seat);
                }
            }
            return Optional.of(currentSeat);
        }
        for (MultiSeatVehicle.SeatType type : preferredTypes = this.getPreferredSeatTypes(entity)) {
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != type || !seat.canAccept(entity)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(entity);
                }
                this.entitySeatMap.put(entity, seat);
                return Optional.of(seat);
            }
        }
        return Optional.empty();
    }

    @Override
    public void releaseSeat(class_1297 entity) {
        MultiSeatVehicle.Seat seat = this.entitySeatMap.remove(entity);
        if (seat != null && !seat.isAllowMultiple()) {
            seat.setOccupant(null);
        }
    }

    @Override
    public Optional<MultiSeatVehicle.Seat> getSeatForEntity(class_1297 entity) {
        return Optional.ofNullable(this.entitySeatMap.get(entity));
    }

    @Override
    public int getPassengerCount() {
        return this.method_5685().size();
    }

    @Override
    public MultiSeatVehicle.SeatType[] getPreferredSeatTypes(class_1297 entity) {
        if (entity instanceof class_1657 || entity instanceof IPuppet) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.PLAYER, MultiSeatVehicle.SeatType.INTERNAL};
        }
        if (entity instanceof class_1309 && this.isRangedUnit((class_1309)entity)) {
            return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.RANGED, MultiSeatVehicle.SeatType.INTERNAL};
        }
        return new MultiSeatVehicle.SeatType[]{MultiSeatVehicle.SeatType.INTERNAL};
    }

    public static class_5132.class_5133 createBatteringRamAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 20.0).method_26868(class_5134.field_23719, (double)0.18f).method_26868(class_5134.field_23721, 20.0).method_26868(class_5134.field_23724, 15.0).method_26868(class_5134.field_23716, 120.0).method_26868(class_5134.field_23718, 1.0).method_26868(HywAttributes.ATTACK_REACH, 6.0);
    }

    @Override
    public void method_5773() {
        super.method_5773();
        if (!this.method_37908().field_9236) {
            if (this.hasPositionTarget() && this.getPositionTarget() != null) {
                class_2338 targetBlockPos = new class_2338((int)this.getPositionTarget().field_1352, (int)this.getPositionTarget().field_1351, (int)this.getPositionTarget().field_1350);
                this.setTargetPosition(targetBlockPos);
                if (this.shouldClearBombardTarget(targetBlockPos)) {
                    this.setPositionTarget(null);
                }
            } else if (this.getHywTarget() != null) {
                this.setTargetPosition(this.getHywTarget().method_24515());
            } else {
                this.setTargetPosition(class_2338.field_10980);
            }
            this.handleUnloadLogic();
        }
    }

    private boolean shouldClearBombardTarget(class_2338 targetPos) {
        int maxY;
        if (targetPos == null || targetPos.equals((Object)class_2338.field_10980)) {
            return false;
        }
        double centerX = (double)targetPos.method_10263() + 0.5;
        double centerZ = (double)targetPos.method_10260() + 0.5;
        double entityBottomY = this.method_5829().field_1322;
        double halfWidth = (double)this.method_17681() / 2.0 + 1.0;
        int minX = class_3532.method_15357((double)(centerX - halfWidth));
        int maxX = class_3532.method_15357((double)(centerX + halfWidth));
        int minZ = class_3532.method_15357((double)(centerZ - halfWidth));
        int maxZ = class_3532.method_15357((double)(centerZ + halfWidth));
        int minY = class_3532.method_15357((double)entityBottomY);
        return !this.hasDestructibleInBounds(minX, maxX, minY, maxY = class_3532.method_15357((double)(entityBottomY + (double)this.method_17682() + 2.0)), minZ, maxZ);
    }

    @Override
    protected void method_5959() {
        this.field_6201.method_6277(1, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 20.0, 25.0, 50.0));
        this.field_6201.method_6277(2, (class_1352)new BaseCombatEntityAttackGoal(this, 1.0));
        this.field_6201.method_6277(3, (class_1352)new PatrolGoal(this, 1.0, 40));
        this.field_6201.method_6277(3, (class_1352)new FollowEntityGoal(this, 1.0, 5.0, 5.0, Double.MAX_VALUE, 0.0));
        this.field_6201.method_6277(4, (class_1352)new ReturnToHomeGoal(this, 1.0));
        super.addTargetSelector();
    }

    @Override
    public boolean isValidTarget(class_1309 potentialTarget) {
        return false;
    }

    @Override
    public int getBaseAttackAnimationTime() {
        return 25;
    }

    @Override
    public int getAttackDamageTickDelay() {
        return 22;
    }

    @Override
    public int getAttackCoolDownDuration() {
        return 50;
    }

    @Override
    public float getRotationLimit() {
        return 1.5f;
    }

    @Override
    protected void increaseStatsOnLevelUp() {
    }

    @Override
    public double getDesiredDistance() {
        return 3.0;
    }

    @Override
    public double getArrivalThreshold() {
        return 2.0;
    }

    public void method_7105(class_1309 target, float pullProgress) {
        this.PerformRangedAttackBoth(null, target);
    }

    @Override
    public void performPositionAttack(class_243 targetPosition, float pullProgress) {
        this.PerformRangedAttackBoth(targetPosition, null);
    }

    @Override
    public boolean canFireAtPosition(class_243 targetPosition) {
        return targetPosition != null;
    }

    @Override
    public boolean hasPositionTarget() {
        return (Boolean)this.field_6011.method_12789(HAS_POSITION_TARGET);
    }

    @Override
    public class_243 getPositionTarget() {
        return this.positionTarget;
    }

    @Override
    public void setPositionTarget(class_243 targetPosition) {
        this.positionTarget = targetPosition;
        this.field_6011.method_12778(HAS_POSITION_TARGET, (Object)(targetPosition != null ? 1 : 0));
        if (targetPosition != null) {
            if (this.unloadTarget != null) {
                this.unloadTarget = null;
                this.resetUnloadState();
            }
            this.setTargetPosition(class_2338.method_49638((class_2374)targetPosition));
        } else {
            this.setTargetPosition(class_2338.field_10980);
        }
    }

    @Override
    public void PerformRangedAttackBoth(class_243 targetPosition, class_1309 target) {
        if (targetPosition == null && target != null) {
            targetPosition = new class_243(target.method_23317(), target.method_23318(), target.method_23321());
        }
        if (targetPosition == null) {
            return;
        }
        if (!this.canFireAtPosition(targetPosition)) {
            return;
        }
        this.performBlockDestructionAttack(targetPosition);
    }

    public void setTargetPosition(class_2338 pos) {
        this.field_6011.method_12778(TARGET_POS, (Object)pos);
    }

    private void performBlockDestructionAttack(class_243 targetPosition) {
        if (this.method_37908().field_9236) {
            return;
        }
        double centerX = targetPosition.field_1352;
        double centerZ = targetPosition.field_1350;
        double entityBottomY = this.method_5829().field_1322;
        double halfWidth = (double)this.method_17681() / 2.0 + 1.0;
        int minX = class_3532.method_15357((double)(centerX - halfWidth));
        int maxX = class_3532.method_15357((double)(centerX + halfWidth));
        int minZ = class_3532.method_15357((double)(centerZ - halfWidth));
        int maxZ = class_3532.method_15357((double)(centerZ + halfWidth));
        int minY = class_3532.method_15357((double)entityBottomY);
        int maxY = class_3532.method_15357((double)(entityBottomY + (double)this.method_17682() + 2.0));
        double influenceHalfWidth = halfWidth + 3.0;
        int influenceMinX = class_3532.method_15357((double)(centerX - influenceHalfWidth));
        int influenceMaxX = class_3532.method_15357((double)(centerX + influenceHalfWidth));
        int influenceMinZ = class_3532.method_15357((double)(centerZ - influenceHalfWidth));
        int influenceMaxZ = class_3532.method_15357((double)(centerZ + influenceHalfWidth));
        int influenceMaxY = maxY + 3;
        List<class_2338> mandatoryBlocks = this.collectDestructibleBlocks(minX, maxX, minY, maxY, minZ, maxZ);
        if (mandatoryBlocks.isEmpty()) {
            this.setPositionTarget(null);
            return;
        }
        HashSet<class_2338> mandatorySet = new HashSet<class_2338>(mandatoryBlocks);
        HashSet<class_2338> influenceBlocks = new HashSet<class_2338>(this.collectDestructibleBlocks(influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ));
        influenceBlocks.removeIf(pos -> this.isWithinBounds((class_2338)pos, minX, maxX, minY, maxY, minZ, maxZ));
        Set<class_2338> connectedInfluence = this.getConnectedInfluenceBlocks(mandatorySet, influenceBlocks, influenceMinX, influenceMaxX, minY, influenceMaxY, influenceMinZ, influenceMaxZ);
        class_5819 random = this.method_6051();
        List<class_2338> toBreakMandatory = this.selectBlocksByBudget(mandatoryBlocks, 30.0, random);
        this.destroyBlocks(toBreakMandatory);
        if (!connectedInfluence.isEmpty()) {
            List<class_2338> toBreakInfluence = this.selectBlocksByBudget(new ArrayList<class_2338>(connectedInfluence), 15.0, random);
            this.destroyBlocks(toBreakInfluence);
        }
        if (!this.hasDestructibleInBounds(minX, maxX, minY, maxY, minZ, maxZ)) {
            this.setPositionTarget(null);
        }
    }

    private List<class_2338> collectDestructibleBlocks(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        ArrayList<class_2338> result = new ArrayList<class_2338>();
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    class_2338 pos = new class_2338(x, y, z);
                    if (!this.isDestructible(pos)) continue;
                    result.add(pos);
                }
            }
        }
        return result;
    }

    private boolean isDestructible(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        if (state.method_26215()) {
            return false;
        }
        float hardness = state.method_26214((class_1922)this.method_37908(), pos);
        return hardness >= 0.0f && hardness <= 50.0f;
    }

    private boolean isWithinBounds(class_2338 pos, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        return pos.method_10263() >= minX && pos.method_10263() <= maxX && pos.method_10264() >= minY && pos.method_10264() <= maxY && pos.method_10260() >= minZ && pos.method_10260() <= maxZ;
    }

    private Set<class_2338> getConnectedInfluenceBlocks(Set<class_2338> mandatoryBlocks, Set<class_2338> influenceBlocks, int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        HashSet<class_2338> connected = new HashSet<class_2338>(mandatoryBlocks);
        ArrayDeque<class_2338> queue = new ArrayDeque<class_2338>(mandatoryBlocks);
        while (!queue.isEmpty()) {
            class_2338 current = queue.poll();
            for (class_2350 direction : class_2350.values()) {
                class_2338 next = current.method_10093(direction);
                if (!this.isWithinBounds(next, minX, maxX, minY, maxY, minZ, maxZ) || !influenceBlocks.contains(next) || connected.contains(next)) continue;
                connected.add(next);
                queue.add(next);
            }
        }
        connected.removeAll(mandatoryBlocks);
        return connected;
    }

    private double getBlockDestructionCost(class_2338 pos) {
        class_2680 state = this.method_37908().method_8320(pos);
        float hardness = state.method_26214((class_1922)this.method_37908(), pos);
        if (hardness < 0.0f || hardness > 50.0f) {
            return Double.MAX_VALUE;
        }
        double coefficient = 1.0;
        if (state.method_26164(class_3481.field_33715)) {
            coefficient = 3.0;
        } else if (state.method_26164(class_3481.field_33716)) {
            coefficient = 0.5;
        } else if (state.method_26164(class_3481.field_33713)) {
            coefficient = 1.5;
        }
        return (double)hardness * coefficient;
    }

    private List<class_2338> selectBlocksByBudget(List<class_2338> candidates, double budget, class_5819 random) {
        class_2338 pos;
        double cost;
        ArrayList<class_2338> shuffled = new ArrayList<class_2338>(candidates);
        Collections.shuffle(shuffled, new Random(random.method_43055()));
        ArrayList<class_2338> selected = new ArrayList<class_2338>();
        double remaining = budget;
        Iterator iterator = shuffled.iterator();
        while (iterator.hasNext() && !((cost = this.getBlockDestructionCost(pos = (class_2338)iterator.next())) > remaining)) {
            selected.add(pos);
            if (!((remaining -= cost) <= 0.0)) continue;
            break;
        }
        return selected;
    }

    private void destroyBlocks(Collection<class_2338> positions) {
        for (class_2338 pos : positions) {
            this.method_37908().method_22352(pos, true);
        }
    }

    private boolean hasDestructibleInBounds(int minX, int maxX, int minY, int maxY, int minZ, int maxZ) {
        for (int x = minX; x <= maxX; ++x) {
            for (int y = minY; y <= maxY; ++y) {
                for (int z = minZ; z <= maxZ; ++z) {
                    if (!this.isDestructible(new class_2338(x, y, z))) continue;
                    return true;
                }
            }
        }
        return false;
    }

    private void handleUnloadLogic() {
        if (!this.hasUnloadTarget()) {
            this.resetUnloadState();
            return;
        }
        class_243 target = this.getUnloadTarget();
        if (!this.canUnloadAtPosition(target)) {
            this.resetUnloadState();
            return;
        }
        if (this.unloadInitDelay > 0) {
            --this.unloadInitDelay;
            return;
        }
        if (this.unloadInterval > 0) {
            --this.unloadInterval;
            return;
        }
        this.unloadInterval = !this.executeUnload(target) ? 15 : 15;
    }

    private void resetUnloadState() {
        this.unloadInitDelay = 0;
        this.unloadInterval = 0;
    }

    private boolean executeUnload(class_243 target) {
        ArrayList passengers = new ArrayList(this.method_5685());
        if (passengers.isEmpty()) {
            return true;
        }
        passengers.sort((e1, e2) -> Integer.compare(this.getUnloadPriority((class_1297)e1), this.getUnloadPriority((class_1297)e2)));
        class_1297 passenger = (class_1297)passengers.get(0);
        class_243 unloadPos = this.findAvailableUnloadPosition(target);
        if (unloadPos == null) {
            return false;
        }
        passenger.method_5848();
        double offsetX = (this.method_6051().method_43058() - 0.5) * 0.8;
        double offsetZ = (this.method_6051().method_43058() - 0.5) * 0.8;
        double finalX = unloadPos.field_1352 + offsetX;
        double finalZ = unloadPos.field_1350 + offsetZ;
        passenger.method_5859(finalX, unloadPos.field_1351, finalZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(class_2338.method_49637((double)finalX, (double)unloadPos.field_1351, (double)finalZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
        return true;
    }

    private int getUnloadPriority(class_1297 entity) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(entity);
        if (seatOpt.isPresent()) {
            switch (seatOpt.get().getType()) {
                case INTERNAL: {
                    return 0;
                }
                case RANGED: {
                    return 1;
                }
                case PLAYER: {
                    return 2;
                }
            }
        }
        return 3;
    }

    private class_243 findAvailableUnloadPosition(class_243 targetPos) {
        for (int y = 0; y <= 3; ++y) {
            class_243 checkPos = new class_243(targetPos.field_1352, targetPos.field_1351 + (double)y + 1.0, targetPos.field_1350);
            if (!this.isValidUnloadPosition(checkPos)) continue;
            return checkPos;
        }
        return null;
    }

    private boolean isValidUnloadPosition(class_243 pos) {
        class_2338 blockPos = new class_2338((int)pos.field_1352, (int)pos.field_1351, (int)pos.field_1350);
        return this.method_37908().method_22347(blockPos) && this.method_37908().method_22347(blockPos.method_10084());
    }

    protected boolean method_5818(class_1297 entity) {
        return this.canEntityMount(entity);
    }

    protected void method_5627(class_1297 entity) {
        super.method_5627(entity);
        this.assignSeat(entity);
        if (!this.method_37908().field_9236) {
            this.optimizeSeatAssignments();
        }
        if (!this.method_37908().field_9236 && entity instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
            combatEntity.setFollowTarget(null);
            ServerPacketHandler.sendClearFollowTargetToAll(entity.method_5667());
            ServerPacketHandler.sendClearSelectionToAll(entity.method_5667());
        }
    }

    protected void method_5793(class_1297 entity) {
        this.unloadPassengerToGround(entity);
        super.method_5793(entity);
        this.releaseSeat(entity);
    }

    protected void method_5865(class_1297 passenger, class_1297.class_4738 moveFunction) {
        Optional<MultiSeatVehicle.Seat> seatOpt = this.getSeatForEntity(passenger);
        if (seatOpt.isPresent()) {
            BaseCombatEntity combatEntity;
            MultiSeatVehicle.Seat seat = seatOpt.get();
            class_243 seatPos = seat.getPosition();
            float yBodyRot = this.getTrueYBodyRot() + 90.0f;
            float yBodyRotRad = (float)Math.toRadians(yBodyRot);
            double forwardX = Math.cos(yBodyRotRad);
            double forwardZ = Math.sin(yBodyRotRad);
            double rightX = Math.cos((double)yBodyRotRad + 1.5707963267948966);
            double rightZ = Math.sin((double)yBodyRotRad + 1.5707963267948966);
            double offsetX = forwardX * seatPos.field_1350 + rightX * seatPos.field_1352;
            double offsetZ = forwardZ * seatPos.field_1350 + rightZ * seatPos.field_1352;
            moveFunction.accept(passenger, this.method_23317() + offsetX, this.method_23318() + seatPos.field_1351, this.method_23321() + offsetZ);
            if (passenger instanceof BaseCombatEntity && !(combatEntity = (BaseCombatEntity)passenger).getHasTarget()) {
                passenger.method_5847(this.getTrueYBodyRot());
            }
        } else {
            super.method_5865(passenger, moveFunction);
        }
    }

    @Override
    @NotNull
    public class_1269 method_5992(class_1657 player, class_1268 hand) {
        if (!this.method_37908().field_9236 && this.canEntityMount((class_1297)player)) {
            player.method_5804((class_1297)this);
        }
        return super.method_5992(player, hand);
    }

    public MultiSeatVehicle.SeatPose getEntitySeatPose(class_1297 entity) {
        return this.getSeatForEntity(entity).map(MultiSeatVehicle.Seat::getPose).orElse(MultiSeatVehicle.SeatPose.SITTING);
    }

    private void optimizeSeatAssignments() {
        ArrayList passengers = new ArrayList(this.method_5685());
        ArrayList<class_1297> rangedUnits = new ArrayList<class_1297>();
        ArrayList<class_1297> otherUnits = new ArrayList<class_1297>();
        for (class_1297 passenger : passengers) {
            if (passenger instanceof class_1309 && this.isRangedUnit((class_1309)passenger)) {
                rangedUnits.add(passenger);
                continue;
            }
            otherUnits.add(passenger);
        }
        this.entitySeatMap.clear();
        for (MultiSeatVehicle.Seat seat : this.seats) {
            if (seat.isAllowMultiple()) continue;
            seat.setOccupant(null);
        }
        block2: for (class_1297 rangedUnit : rangedUnits) {
            boolean assigned = false;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.RANGED || !seat.canAccept(rangedUnit)) continue;
                if (!seat.isAllowMultiple()) {
                    seat.setOccupant(rangedUnit);
                }
                this.entitySeatMap.put(rangedUnit, seat);
                assigned = true;
                break;
            }
            if (assigned) continue;
            for (MultiSeatVehicle.Seat seat : this.seats) {
                if (seat.getType() != MultiSeatVehicle.SeatType.INTERNAL || !seat.canAccept(rangedUnit)) continue;
                this.entitySeatMap.put(rangedUnit, seat);
                continue block2;
            }
        }
        for (class_1297 otherUnit : otherUnits) {
            this.assignSeat(otherUnit);
        }
    }

    public class_1309 method_5642() {
        return null;
    }

    @Override
    public boolean canUnloadAtPosition(class_243 targetPosition) {
        if (targetPosition == null) {
            return false;
        }
        double horizontalDistance = Math.sqrt(Math.pow(targetPosition.field_1352 - this.method_23317(), 2.0) + Math.pow(targetPosition.field_1350 - this.method_23321(), 2.0));
        if (horizontalDistance > this.getMaxUnloadDistance()) {
            return false;
        }
        double heightDiff = targetPosition.field_1351 - this.method_23318();
        return heightDiff >= -0.5 * this.getUnloadHeightRange() && heightDiff <= this.getUnloadHeightRange();
    }

    @Override
    public boolean hasUnloadTarget() {
        return this.unloadTarget != null;
    }

    @Override
    public class_243 getUnloadTarget() {
        return this.unloadTarget;
    }

    @Override
    public void setUnloadTarget(class_243 targetPosition) {
        this.unloadTarget = targetPosition;
        if (targetPosition != null) {
            if (this.hasPositionTarget()) {
                this.setPositionTarget(null);
            }
            this.resetUnloadState();
            this.unloadInitDelay = 20;
        }
    }

    @Override
    public double getMaxUnloadDistance() {
        return 4.0;
    }

    @Override
    public double getUnloadHeightRange() {
        return 10.0;
    }

    @Override
    public void unloadPassengerToGround(class_1297 passenger) {
        if (this.method_37908().field_9236 || passenger == null) {
            return;
        }
        Random random = new Random();
        double maxDistance = this.getMaxUnloadDistance();
        double angle = random.nextDouble() * 2.0 * Math.PI;
        double distance = random.nextDouble() * maxDistance;
        double offsetX = Math.cos(angle) * distance;
        double offsetZ = Math.sin(angle) * distance;
        double targetX = this.method_23317() + offsetX;
        double targetZ = this.method_23321() + offsetZ;
        class_2338 groundPos = new class_2338((int)targetX, (int)this.method_23318(), (int)targetZ);
        double groundY = this.findGroundLevel(groundPos);
        passenger.method_5848();
        passenger.method_5859(targetX, groundY, targetZ);
        if (passenger instanceof BaseCombatEntity) {
            BaseCombatEntity combatEntity = (BaseCombatEntity)passenger;
            combatEntity.setHomePosition(class_2338.method_49637((double)targetX, (double)groundY, (double)targetZ));
            combatEntity.setHomeReturnRadius(999.0);
            combatEntity.setShouldRender(false);
        }
    }

    private double findGroundLevel(class_2338 startPos) {
        for (int y = startPos.method_10264(); y >= startPos.method_10264() - 10; --y) {
            class_2338 checkPos = new class_2338(startPos.method_10263(), y, startPos.method_10260());
            if (this.method_37908().method_22347(checkPos)) continue;
            class_2338 abovePos = checkPos.method_10084();
            if (!this.method_37908().method_22347(abovePos) || !this.method_37908().method_22347(abovePos.method_10084())) continue;
            return abovePos.method_10264();
        }
        return startPos.method_10264();
    }

    @Override
    public void method_5652(class_2487 compound) {
        super.method_5652(compound);
        compound.method_10556("HasPositionTarget", this.hasPositionTarget());
        if (this.hasPositionTarget() && this.positionTarget != null) {
            compound.method_10549("PositionTargetX", this.positionTarget.field_1352);
            compound.method_10549("PositionTargetY", this.positionTarget.field_1351);
            compound.method_10549("PositionTargetZ", this.positionTarget.field_1350);
        }
        compound.method_10556("HasUnloadTarget", this.hasUnloadTarget());
        if (this.hasUnloadTarget() && this.unloadTarget != null) {
            compound.method_10549("UnloadTargetX", this.unloadTarget.field_1352);
            compound.method_10549("UnloadTargetY", this.unloadTarget.field_1351);
            compound.method_10549("UnloadTargetZ", this.unloadTarget.field_1350);
        }
    }

    @Override
    public void method_5749(class_2487 compound) {
        double z;
        double y;
        double x;
        super.method_5749(compound);
        if (compound.method_10577("HasPositionTarget")) {
            x = compound.method_10574("PositionTargetX");
            y = compound.method_10574("PositionTargetY");
            z = compound.method_10574("PositionTargetZ");
            this.setPositionTarget(new class_243(x, y, z));
        } else {
            this.setPositionTarget(null);
        }
        if (compound.method_10577("HasUnloadTarget")) {
            x = compound.method_10574("UnloadTargetX");
            y = compound.method_10574("UnloadTargetY");
            z = compound.method_10574("UnloadTargetZ");
            this.setUnloadTarget(new class_243(x, y, z));
        } else {
            this.setUnloadTarget(null);
        }
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.BATTERING_RAM;
    }

    @Override
    public void method_6078(class_1282 damageSource) {
        ArrayList passengers = new ArrayList(this.method_5685());
        for (class_1297 passenger : passengers) {
            this.unloadPassengerToGround(passenger);
        }
        super.method_6078(damageSource);
    }

    @Override
    public boolean canFireAtTarget(class_1309 target) {
        return false;
    }
}

