/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.entities.woodelf;

import net.minecraft.class_1268;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1304;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1314;
import net.minecraft.class_1665;
import net.minecraft.class_1667;
import net.minecraft.class_1675;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3417;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import ydmsama.hundred_years_war.main.entity.entities.ArcherEntity;
import ydmsama.hundred_years_war.main.registry.HywAttributes;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;

public class WoodElfArcherEntity
extends ArcherEntity {
    private static final float ATTACK_REACH = 100.0f;
    private static final float MOVEMENT_SPEED = 0.3f;

    public WoodElfArcherEntity(class_1299<? extends class_1314> entityType, class_1937 world) {
        super(entityType, world);
    }

    public static class_5132.class_5133 createWoodElfArcherAttributes() {
        return class_1308.method_26828().method_26868(class_5134.field_23717, 100.0).method_26868(class_5134.field_23719, (double)0.3f).method_26868(class_5134.field_23721, 7.0).method_26868(class_5134.field_23724, 3.0).method_26868(class_5134.field_23716, 36.0).method_26868(class_5134.field_23718, 0.4).method_26868(HywAttributes.ATTACK_REACH, 100.0).method_26868(HywAttributes.RANGED_ATTACK_DAMAGE, 2.5);
    }

    @Override
    protected void setDefaultEquipment() {
        this.method_5673(class_1304.field_6173, new class_1799((class_1935)class_1802.field_8102));
        this.method_5673(class_1304.field_6171, class_1799.field_8037);
        this.method_5673(class_1304.field_6169, class_1799.field_8037);
        this.method_5673(class_1304.field_6174, class_1799.field_8037);
        this.method_5673(class_1304.field_6172, class_1799.field_8037);
        this.method_5673(class_1304.field_6166, class_1799.field_8037);
    }

    @Override
    public class_1792 getScrollType() {
        return HywItemRegistry.SCROLL_WOOD_ELF_ARCHER;
    }

    @Override
    public int getSkinCounts() {
        return 3;
    }

    @Override
    protected boolean allowEquipmentReplacement() {
        return false;
    }

    @Override
    public void method_7105(class_1309 target, float pullProgress) {
        double dy;
        double dz;
        double dx;
        double distance;
        class_1665 arrow = class_1675.method_18813((class_1309)this, (class_1799)new class_1799((class_1935)class_1802.field_8107), (float)pullProgress);
        arrow.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE));
        class_1799 bowStack = this.method_5998(class_1268.field_5808);
        int powerLevel = class_1890.method_8225((class_1887)class_1893.field_9103, (class_1799)bowStack);
        int punchLevel = class_1890.method_8225((class_1887)class_1893.field_9116, (class_1799)bowStack);
        int flameLevel = class_1890.method_8225((class_1887)class_1893.field_9126, (class_1799)bowStack);
        if (powerLevel > 0) {
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        if (punchLevel > 0) {
            arrow.method_7449(punchLevel);
        }
        if (flameLevel > 0) {
            arrow.method_5639(100);
        }
        if (arrow instanceof class_1667) {
            class_1667 tipped = (class_1667)arrow;
            tipped.method_7463(new class_1293(class_1294.field_5899, 120, 0));
        }
        if ((distance = Math.sqrt((dx = target.method_23317() - this.method_23317()) * dx + (dz = target.method_23321() - this.method_23321()) * dz + (dy = target.method_23323(0.5) - arrow.method_23318()) * dy)) == 0.0) {
            return;
        }
        float speed = 2.0f;
        double gravity = 0.05;
        double angle = Double.NaN;
        float maxArrowSpeed = 3.0f;
        float miss = 2.5f;
        this.setUseAngle(-1);
        while (speed <= maxArrowSpeed) {
            double[] angles = this.calculateLaunchAngles(speed, gravity, distance, dy);
            if (!(this.isObstructed(target) && !this.method_5765() && target.method_37908().method_8311(target.method_24515()) || Double.isNaN(angles[1]) && !(distance < 5.0))) {
                angle = angles[1];
                this.setUseAngle(1);
                break;
            }
            if (!Double.isNaN(angles[0]) && this.isPathClear(arrow, angles[0], speed, dx, dy, dz, distance, target)) {
                angle = angles[0];
                this.setUseAngle(0);
                break;
            }
            if (!((speed += 0.25f) > maxArrowSpeed)) continue;
            break;
        }
        if (this.getUseAngle() == -1) {
            return;
        }
        double randomSpeedOffset = ArcherEntity.getRandomInRange(-0.25, 0.75);
        double timeToTarget = distance / (((double)speed - randomSpeedOffset) * Math.cos(angle));
        double targetVelocityX = target.method_18798().method_10216();
        double targetVelocityZ = target.method_18798().method_10215();
        double predictedX = target.method_23317() + targetVelocityX * timeToTarget;
        double predictedZ = target.method_23321() + targetVelocityZ * timeToTarget;
        double predictedDistance = Math.sqrt((predictedX - this.method_23317()) * (predictedX - this.method_23317()) + (predictedZ - this.method_23321()) * (predictedZ - this.method_23321()));
        double[] angles = this.calculateLaunchAngles(speed, gravity, predictedDistance, dy);
        if (Double.isNaN(angles[0]) && Double.isNaN(angles[1])) {
            return;
        }
        angle = angles[this.getUseAngle()];
        dx = predictedX - this.method_23317();
        double horizontalDistance = Math.sqrt(dx * dx + (dz = predictedZ - this.method_23321()) * dz);
        if (horizontalDistance == 0.0) {
            return;
        }
        double horizontalSpeed = (double)speed * Math.cos(angle);
        double verticalSpeed = (double)speed * Math.sin(angle);
        float velocityX = (float)(dx / horizontalDistance * horizontalSpeed);
        float velocityY = (float)verticalSpeed;
        float velocityZ = (float)(dz / horizontalDistance * horizontalSpeed);
        if (this.getUseAngle() == 0) {
            miss = 3.5f;
            arrow.method_7438(this.method_26825(HywAttributes.RANGED_ATTACK_DAMAGE) * 1.5);
            arrow.method_7438(arrow.method_7448() + (double)powerLevel * 0.5 + 0.5);
        }
        arrow.method_7485((double)velocityX, (double)velocityY, (double)velocityZ, speed, miss);
        this.method_5783(class_3417.field_14633, 1.0f, 1.0f / (this.method_6051().method_43057() * 0.4f + 0.8f));
        this.method_37908().method_8649((class_1297)arrow);
        this.method_6021();
    }

    private boolean isPathClear(class_1665 arrow, double angle, float speed, double dx, double dy, double dz, double distance, class_1309 target) {
        class_243 startPos = this.method_33571();
        class_243 direction = new class_243(dx / distance, Math.tan(angle), dz / distance).method_1029();
        class_243 endPos = startPos.method_1019(direction.method_1021(5.0));
        class_3965 hitResult = this.method_37908().method_17742(new class_3959(startPos, endPos, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)arrow));
        return hitResult.method_17783() == class_239.class_240.field_1333;
    }

    private double[] calculateLaunchAngles(double speed, double gravity, double distance, double heightDifference) {
        double discriminant = speed * speed * speed * speed - gravity * (gravity * distance * distance + 2.0 * heightDifference * speed * speed);
        if (discriminant < 0.0) {
            return new double[]{Double.NaN, Double.NaN};
        }
        double angle1 = Math.atan2(speed * speed + Math.sqrt(discriminant), gravity * distance);
        double angle2 = Math.atan2(speed * speed - Math.sqrt(discriminant), gravity * distance);
        return new double[]{angle1, angle2};
    }
}

