/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.Random;
import net.minecraft.class_1268;
import net.minecraft.class_1352;
import net.minecraft.class_1408;
import net.minecraft.class_2338;
import net.minecraft.class_2586;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.entity.entities.CraftsmanEntity;

public class CraftsmanActivateWorkstationGoal
extends class_1352 {
    private final CraftsmanEntity craftsman;
    private final int searchRange;
    private class_2338 targetWorkstation;
    private int workCooldown;
    private int searchCooldown;
    private int armSwingCooldown;
    private static final int MIN_WORK_INTERVAL = 40;
    private static final int MAX_WORK_INTERVAL = 100;
    private static final int SEARCH_COOLDOWN = 40;
    private static final int ARM_SWING_INTERVAL = 10;
    private static final int ARM_SWING_RANDOMNESS = 2;
    private final Random random = new Random();

    public CraftsmanActivateWorkstationGoal(CraftsmanEntity craftsman, int searchRange) {
        this.craftsman = craftsman;
        this.searchRange = searchRange;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
    }

    public boolean method_6264() {
        if (this.craftsman.commandHold() || this.craftsman.isOnStrike()) {
            return false;
        }
        if (this.searchCooldown > 0) {
            --this.searchCooldown;
            return false;
        }
        if (this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation)) {
            return true;
        }
        this.targetWorkstation = this.craftsman.findNearestWorkstation();
        return this.targetWorkstation != null;
    }

    public boolean method_6266() {
        if (this.craftsman.commandHold() || this.craftsman.isOnStrike()) {
            return false;
        }
        return this.targetWorkstation != null && this.isWorkstationValid(this.targetWorkstation);
    }

    private boolean isWorkstationValid(class_2338 pos) {
        if (this.craftsman.method_37908() == null) {
            return false;
        }
        class_2586 blockEntity = this.craftsman.method_37908().method_8321(pos);
        return blockEntity instanceof CraftingWorkstationBlockEntity;
    }

    public void method_6269() {
        if (this.targetWorkstation != null) {
            class_1408 navigation = this.craftsman.method_5942();
            navigation.method_6337((double)this.targetWorkstation.method_10263() + 0.5, (double)this.targetWorkstation.method_10264(), (double)this.targetWorkstation.method_10260() + 0.5, 1.0);
            this.resetWorkCooldown();
            this.armSwingCooldown = 10 + this.random.nextInt(5) - 2;
        }
    }

    public void method_6268() {
        if (this.targetWorkstation == null) {
            return;
        }
        double distanceToWorkstation = this.craftsman.method_5649((double)this.targetWorkstation.method_10263() + 0.5, this.targetWorkstation.method_10264(), (double)this.targetWorkstation.method_10260() + 0.5);
        if (distanceToWorkstation <= 9.0) {
            if (this.armSwingCooldown > 0) {
                --this.armSwingCooldown;
            } else {
                this.craftsman.method_6104(class_1268.field_5808);
                this.armSwingCooldown = 10 + this.random.nextInt(5) - 2;
            }
            if (this.workCooldown > 0) {
                --this.workCooldown;
            } else {
                this.triggerWorkstationWork();
                this.resetWorkCooldown();
            }
            this.craftsman.method_5942().method_6340();
        } else {
            class_1408 navigation = this.craftsman.method_5942();
            if (navigation.method_6357()) {
                navigation.method_6337((double)this.targetWorkstation.method_10263() + 0.5, (double)this.targetWorkstation.method_10264(), (double)this.targetWorkstation.method_10260() + 0.5, 1.0);
            }
        }
    }

    private void resetWorkCooldown() {
        this.workCooldown = this.craftsman.method_6051().method_43048(61) + 40;
    }

    private void triggerWorkstationWork() {
        class_2586 blockEntity = this.craftsman.method_37908().method_8321(this.targetWorkstation);
        if (blockEntity instanceof CraftingWorkstationBlockEntity) {
            CraftingWorkstationBlockEntity workstation = (CraftingWorkstationBlockEntity)blockEntity;
            workstation.triggerWork();
        }
    }

    public void method_6270() {
        this.searchCooldown = 40;
        this.targetWorkstation = null;
        this.craftsman.method_5942().method_6340();
    }
}

