/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.goals;

import java.util.EnumSet;
import java.util.UUID;
import net.minecraft.class_1352;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.CommandedGoal;
import ydmsama.hundred_years_war.main.entity.goals.MoveGoal;
import ydmsama.hundred_years_war.main.entity.utils.FormationManager;
import ydmsama.hundred_years_war.main.entity.utils.PathfindingUtil;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class MoveToBlockGoal
extends class_1352
implements CommandedGoal,
MoveGoal {
    private boolean init = true;
    private final UUID FormationUUID;
    private boolean shouldRemove = false;
    private BaseCombatEntity mob;
    private final double speed;
    private class_2338 targetPos;
    private boolean pathGenerated = false;

    public MoveToBlockGoal(BaseCombatEntity mob, double speed, UUID formationUUID) {
        this.mob = mob;
        this.speed = speed;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405));
        this.FormationUUID = formationUUID;
    }

    public void setTargetPos(class_2338 targetPos) {
        class_2680 blockState = ((EntityAccessor)((Object)this.mob)).getLevel().method_8320(targetPos);
        this.targetPos = !blockState.method_26216((class_1922)((EntityAccessor)((Object)this.mob)).getLevel(), targetPos) || blockState.method_26215() ? targetPos : targetPos.method_10084();
    }

    public boolean method_6264() {
        if (this.targetPos == null) {
            return false;
        }
        return !this.shouldRemove;
    }

    public boolean method_6266() {
        return !this.shouldRemove;
    }

    public void method_6269() {
        if (this.init) {
            this.mob.setHomePosition(this.targetPos);
            this.mob.setFormationUUID(this.FormationUUID);
            this.mob.setCommandHold(false);
            PathfindingUtil.moveTo(this.mob, this.targetPos, this.speed, () -> {
                this.pathGenerated = true;
            });
            this.init = false;
        }
    }

    public void method_6270() {
        this.mob.method_5942().method_6340();
    }

    public void method_6268() {
        if (this.targetPos == null) {
            return;
        }
        class_2338 currentHorizontalPos = new class_2338((int)Math.floor(this.mob.method_23317()), this.targetPos.method_10264(), (int)Math.floor(this.mob.method_23321()));
        double verticalDistance = Math.abs(this.mob.method_23318() - (double)this.targetPos.method_10264());
        class_2680 targetBlockState = ((EntityAccessor)((Object)this.mob)).getLevel().method_8320(this.targetPos.method_10074());
        boolean isTargetAir = targetBlockState.method_26215();
        boolean hasArrived = false;
        if (isTargetAir) {
            if (currentHorizontalPos.method_19771((class_2382)this.targetPos, this.mob.getArrivalThreshold())) {
                hasArrived = true;
            }
        } else if (currentHorizontalPos.method_19771((class_2382)this.targetPos, this.mob.getArrivalThreshold()) && verticalDistance < 1.0) {
            hasArrived = true;
        }
        if (hasArrived) {
            this.shouldRemove = true;
            this.executeNext();
        }
        if (this.pathGenerated) {
            PathfindingUtil.continueVanillaMovement(this.mob, this.targetPos, 1.0);
        }
    }

    @Override
    public void executeNext() {
        this.mob.setShouldExecuteNext(true);
        this.mob.goalFinished();
    }

    @Override
    public void updateEntityReference(BaseCombatEntity newEntity) {
        FormationManager.FormationStatus formationStatus;
        this.mob = newEntity;
        this.mob.setFormationUUID(this.FormationUUID);
        if (this.FormationUUID != null && (formationStatus = FormationManager.getFormationStatus(this.FormationUUID)) != null) {
            formationStatus.getEntities().add(newEntity);
            int currentSize = formationStatus.getEntities().size();
            formationStatus.setFormationSize(currentSize);
        }
    }
}

