/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.entity.utils;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.PathingTaskManager;

public class PathingTaskManagerRegistry {
    private static PathingTaskManagerRegistry instance = null;
    private Map<UUID, PathingTaskManager> playerTaskManagers = new HashMap<UUID, PathingTaskManager>();

    private PathingTaskManagerRegistry() {
    }

    public static PathingTaskManagerRegistry getInstance() {
        if (instance == null) {
            instance = new PathingTaskManagerRegistry();
        }
        return instance;
    }

    public PathingTaskManager getTaskManager(UUID playerUUID) {
        return this.playerTaskManagers.computeIfAbsent(playerUUID, k -> {
            int maxTasksPerTick = ServerModConfig.INSTANCE.getPathfindingTasksPerTick();
            return new PathingTaskManager(maxTasksPerTick);
        });
    }

    public void removeTaskManager(UUID playerUUID) {
        this.playerTaskManagers.remove(playerUUID);
    }

    public void executeAllTasks() {
        for (PathingTaskManager manager : this.playerTaskManagers.values()) {
            manager.executeTasks();
        }
    }

    public void clearTasksForEntities(Collection<BaseCombatEntity> entities) {
        if (entities == null || entities.isEmpty()) {
            return;
        }
        HashMap<UUID, List> ownerToEntities = new HashMap<UUID, List>();
        for (BaseCombatEntity baseCombatEntity : entities) {
            UUID ownerUUID = baseCombatEntity.method_6139();
            ownerToEntities.computeIfAbsent(ownerUUID, k -> new ArrayList()).add(baseCombatEntity);
        }
        for (Map.Entry entry : ownerToEntities.entrySet()) {
            PathingTaskManager manager = this.getTaskManager((UUID)entry.getKey());
            manager.clearTasksForEntities((Collection)entry.getValue());
        }
    }
}

