/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.events;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.minecraft.class_1923;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;

public class BuildingSyncEventHandler {
    private static final Logger LOGGER = LoggerFactory.getLogger(BuildingSyncEventHandler.class);
    private static final Map<UUID, Set<class_1923>> playerSyncedChunks = new HashMap<UUID, Set<class_1923>>();
    private static final Map<UUID, class_1923> playerLastChunkPos = new HashMap<UUID, class_1923>();
    private static final int SYNC_RADIUS = 16;
    private static int tickCounter = 0;
    private static final int CHECK_INTERVAL = 40;

    public static void init() {
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> {
            class_3222 player = handler.method_32311();
            UUID playerId = player.method_5667();
            playerSyncedChunks.remove(playerId);
            playerLastChunkPos.remove(playerId);
            class_1923 playerChunk = new class_1923(player.method_24515());
            playerLastChunkPos.put(playerId, playerChunk);
            HashSet<class_1923> syncedChunks = new HashSet<class_1923>();
            playerSyncedChunks.put(playerId, syncedChunks);
            BuildingSyncEventHandler.syncNearbyChunks(player, playerChunk, syncedChunks);
            LOGGER.debug("Initialized building sync for player {}", (Object)player.method_5477().getString());
        });
        ServerPlayConnectionEvents.DISCONNECT.register((handler, server) -> {
            class_3222 player = handler.method_32311();
            UUID playerId = player.method_5667();
            playerSyncedChunks.remove(playerId);
            playerLastChunkPos.remove(playerId);
            LOGGER.debug("Cleaned up building sync for player {}", (Object)player.method_5477().getString());
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            if (++tickCounter >= 40) {
                tickCounter = 0;
                for (class_3222 player : server.method_3760().method_14571()) {
                    BuildingSyncEventHandler.checkPlayerChunkChange(player);
                }
            }
        });
    }

    private static void checkPlayerChunkChange(class_3222 player) {
        UUID playerId = player.method_5667();
        class_1923 currentChunk = new class_1923(player.method_24515());
        class_1923 lastChunk = playerLastChunkPos.get(playerId);
        if (lastChunk == null) {
            playerLastChunkPos.put(playerId, currentChunk);
            HashSet<class_1923> syncedChunks = new HashSet<class_1923>();
            playerSyncedChunks.put(playerId, syncedChunks);
            BuildingSyncEventHandler.syncNearbyChunks(player, currentChunk, syncedChunks);
            return;
        }
        if (!currentChunk.equals((Object)lastChunk)) {
            playerLastChunkPos.put(playerId, currentChunk);
            Set<class_1923> syncedChunks = playerSyncedChunks.get(playerId);
            if (syncedChunks == null) {
                syncedChunks = new HashSet<class_1923>();
                playerSyncedChunks.put(playerId, syncedChunks);
            }
            int beforeSize = syncedChunks.size();
            BuildingSyncEventHandler.syncNearbyChunks(player, currentChunk, syncedChunks);
            int newChunks = syncedChunks.size() - beforeSize;
            if (newChunks > 0) {
                LOGGER.debug("Synced {} new chunks of building data for player {} at chunk ({}, {})", new Object[]{newChunks, player.method_5477().getString(), currentChunk.field_9181, currentChunk.field_9180});
            }
            BuildingSyncEventHandler.cleanupDistantChunks(currentChunk, syncedChunks);
        }
    }

    private static void syncNearbyChunks(class_3222 player, class_1923 centerChunk, Set<class_1923> syncedChunks) {
        ArrayList<class_1923> chunksToSync = new ArrayList<class_1923>();
        for (int dx = -16; dx <= 16; ++dx) {
            for (int dz = -16; dz <= 16; ++dz) {
                class_1923 chunkPos = new class_1923(centerChunk.field_9181 + dx, centerChunk.field_9180 + dz);
                if (syncedChunks.contains(chunkPos)) continue;
                chunksToSync.add(chunkPos);
                syncedChunks.add(chunkPos);
            }
        }
        int batchSize = 8;
        for (int i = 0; i < chunksToSync.size(); i += batchSize) {
            int endIndex = Math.min(i + batchSize, chunksToSync.size());
            List batch = chunksToSync.subList(i, endIndex);
            for (class_1923 chunkPos : batch) {
                ServerPacketHandler.sendChunkBuildings(player, chunkPos);
            }
        }
    }

    private static void cleanupDistantChunks(class_1923 centerChunk, Set<class_1923> syncedChunks) {
        int cleanupRadius = 32;
        syncedChunks.removeIf(chunk -> {
            int dx = Math.abs(chunk.field_9181 - centerChunk.field_9181);
            int dz = Math.abs(chunk.field_9180 - centerChunk.field_9180);
            return dx > cleanupRadius || dz > cleanupRadius;
        });
    }

    public static void forceResync(class_3222 player) {
        UUID playerId = player.method_5667();
        playerSyncedChunks.remove(playerId);
        playerLastChunkPos.remove(playerId);
        class_1923 playerChunk = new class_1923(player.method_24515());
        playerLastChunkPos.put(playerId, playerChunk);
        HashSet<class_1923> syncedChunks = new HashSet<class_1923>();
        playerSyncedChunks.put(playerId, syncedChunks);
        BuildingSyncEventHandler.syncNearbyChunks(player, playerChunk, syncedChunks);
        LOGGER.info("Force resynced buildings for player {}", (Object)player.method_5477().getString());
    }
}

