/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.class_1923;
import net.minecraft.class_2338;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_6880;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.generation.StructurePosition;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class StructureLocationGenerator {
    private static final Logger LOGGER = LoggerFactory.getLogger(StructureLocationGenerator.class);
    private static final int GRID_SIZE = 64;
    private static final double GENERATION_PROBABILITY = 0.3;
    private final long worldSeed;
    private final class_3218 level;
    private final List<WeightedTemplate> weightedTemplates;
    private final int totalWeight;

    public StructureLocationGenerator(class_3218 level) {
        this.level = level;
        this.worldSeed = level.method_8412();
        ArrayList<WeightedTemplate> templates = new ArrayList<WeightedTemplate>();
        int totalW = 0;
        for (TemplateMetadata metadata : TemplateManager.getInstance().getAllMetadata()) {
            if (!metadata.isGenerationEnabled() || metadata.getGenerationWeight() <= 0) continue;
            templates.add(new WeightedTemplate(metadata.getTemplateId(), metadata, metadata.getGenerationWeight()));
            totalW += metadata.getGenerationWeight();
        }
        this.weightedTemplates = templates;
        this.totalWeight = totalW;
        LOGGER.info("Initialized structure generator with {} templates (total weight: {}, world seed: {})", new Object[]{templates.size(), this.totalWeight, this.worldSeed});
    }

    public StructurePosition getStructureAt(int gridX, int gridZ) {
        int offsetZ;
        int worldZ;
        int worldY;
        if (this.weightedTemplates.isEmpty()) {
            return null;
        }
        Random random = this.createGridRandom(gridX, gridZ);
        if (random.nextDouble() >= 0.3) {
            return null;
        }
        int offsetX = random.nextInt(64);
        int worldX = gridX * 64 + offsetX;
        class_2338 position = new class_2338(worldX, worldY = 0, worldZ = gridZ * 64 + (offsetZ = random.nextInt(64)));
        WeightedTemplate selectedTemplate = this.selectTemplate(random, this.resolveBiomeId(position));
        if (selectedTemplate == null) {
            return null;
        }
        int rotation = random.nextInt(4) * 90;
        boolean mirror = false;
        long generationSeed = random.nextLong();
        return new StructurePosition(position, selectedTemplate.templateId, rotation, mirror, generationSeed);
    }

    public List<StructurePosition> getStructuresInChunkRange(int minChunkX, int minChunkZ, int maxChunkX, int maxChunkZ) {
        ArrayList<StructurePosition> structures = new ArrayList<StructurePosition>();
        int minGridX = this.chunkToGrid(minChunkX);
        int minGridZ = this.chunkToGrid(minChunkZ);
        int maxGridX = this.chunkToGrid(maxChunkX);
        int maxGridZ = this.chunkToGrid(maxChunkZ);
        for (int gridX = minGridX; gridX <= maxGridX; ++gridX) {
            for (int gridZ = minGridZ; gridZ <= maxGridZ; ++gridZ) {
                StructurePosition structure = this.getStructureAt(gridX, gridZ);
                if (structure == null) continue;
                structures.add(structure);
            }
        }
        return structures;
    }

    public List<StructurePosition> getStructuresAroundChunk(int centerChunkX, int centerChunkZ, int chunkRadius) {
        return this.getStructuresInChunkRange(centerChunkX - chunkRadius, centerChunkZ - chunkRadius, centerChunkX + chunkRadius, centerChunkZ + chunkRadius);
    }

    public List<StructurePosition> getStructuresAroundPosition(class_2338 centerPos, int blockRadius) {
        class_1923 centerChunk = new class_1923(centerPos);
        int chunkRadius = blockRadius / 16 + 1;
        return this.getStructuresAroundChunk(centerChunk.field_9181, centerChunk.field_9180, chunkRadius);
    }

    private Random createGridRandom(int gridX, int gridZ) {
        long seed = this.worldSeed;
        seed = seed ^ (long)gridX * 341873128712L + (long)gridZ * 132897987541L ^ 0x5DEECE66DL;
        return new Random(seed);
    }

    private class_2960 resolveBiomeId(class_2338 pos) {
        int sampleY = class_3532.method_15340((int)this.level.method_8615(), (int)this.level.method_31607(), (int)this.level.method_31600());
        class_2338 samplePos = new class_2338(pos.method_10263(), sampleY, pos.method_10260());
        class_6880 biomeHolder = this.level.method_22385().method_22393(samplePos);
        return biomeHolder.method_40230().map(key -> key.method_29177()).orElse(null);
    }

    private WeightedTemplate selectTemplate(Random random, class_2960 biomeId) {
        if (this.weightedTemplates.isEmpty() || this.totalWeight <= 0) {
            return null;
        }
        ArrayList<WeightedTemplate> allowed = new ArrayList<WeightedTemplate>();
        int allowedWeight = 0;
        for (WeightedTemplate template : this.weightedTemplates) {
            if (!template.metadata.matchesBiome(biomeId)) continue;
            allowed.add(template);
            allowedWeight += template.weight;
        }
        if (allowed.isEmpty() || allowedWeight <= 0) {
            return null;
        }
        return this.selectTemplate(random, allowed, allowedWeight);
    }

    private WeightedTemplate selectTemplate(Random random, List<WeightedTemplate> candidates, int weightSum) {
        if (candidates.isEmpty() || weightSum <= 0) {
            return null;
        }
        int randomWeight = random.nextInt(weightSum);
        int currentWeight = 0;
        for (WeightedTemplate template : candidates) {
            if (randomWeight >= (currentWeight += template.weight)) continue;
            return template;
        }
        return candidates.get(candidates.size() - 1);
    }

    private int chunkToGrid(int chunkCoord) {
        int blockCoord = chunkCoord * 16;
        return Math.floorDiv(blockCoord, 64);
    }

    public static int getGridSize() {
        return 64;
    }

    public static double getGenerationProbability() {
        return 0.3;
    }

    public int getEnabledTemplateCount() {
        return this.weightedTemplates.size();
    }

    public int getTotalWeight() {
        return this.totalWeight;
    }

    private static class WeightedTemplate {
        final String templateId;
        final TemplateMetadata metadata;
        final int weight;

        WeightedTemplate(String templateId, TemplateMetadata metadata, int weight) {
            this.templateId = templateId;
            this.metadata = metadata;
            this.weight = weight;
        }
    }
}

