/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.generation;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CopyOnWriteArrayList;
import net.minecraft.class_3218;
import ydmsama.hundred_years_war.main.generation.StructurePositionProvider;
import ydmsama.hundred_years_war.main.generation.StructurePositionProviderFactory;

public final class StructurePositionProviderRegistry {
    private static final CopyOnWriteArrayList<StructurePositionProviderFactory> FACTORIES = new CopyOnWriteArrayList();

    private StructurePositionProviderRegistry() {
    }

    public static void registerFactory(StructurePositionProviderFactory factory) {
        FACTORIES.add(Objects.requireNonNull(factory, "factory"));
    }

    public static void registerProvider(StructurePositionProvider provider) {
        Objects.requireNonNull(provider, "provider");
        StructurePositionProviderRegistry.registerFactory(level -> provider);
    }

    static List<StructurePositionProvider> createProviders(class_3218 level) {
        if (FACTORIES.isEmpty()) {
            return Collections.emptyList();
        }
        ArrayList<StructurePositionProvider> providers = new ArrayList<StructurePositionProvider>(FACTORIES.size());
        for (StructurePositionProviderFactory factory : FACTORIES) {
            StructurePositionProvider provider = factory.create(level);
            if (provider == null) continue;
            providers.add(provider);
        }
        return providers;
    }
}

