/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.handler;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1291;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_238;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class WorshipEffectHandler {
    private static final int EFFECT_DURATION = 200;
    private static final double CHECK_RANGE = 20.0;

    public static void checkPlayerWorshipEffect(class_3222 player) {
        if (!ServerModConfig.INSTANCE.isEnableWorshipMechanism()) {
            return;
        }
        if (player == null || player.method_37908().field_9236) {
            return;
        }
        class_238 searchArea = new class_238(player.method_23317() - 20.0, player.method_23318() - 20.0, player.method_23321() - 20.0, player.method_23317() + 20.0, player.method_23318() + 20.0, player.method_23321() + 20.0);
        List nearbyEntities = player.method_37908().method_8335((class_1297)player, searchArea);
        int controlledEntityCount = 0;
        UUID playerUUID = player.method_5667();
        for (class_1297 entity : nearbyEntities) {
            BaseCombatEntity baseCombatEntity;
            if (!(entity instanceof BaseCombatEntity) || !ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)(baseCombatEntity = (BaseCombatEntity)entity))) continue;
            ++controlledEntityCount;
        }
        int resistanceLevel = WorshipEffectHandler.getResistanceLevel(controlledEntityCount);
        WorshipEffectHandler.applyWorshipEffects(player, resistanceLevel);
    }

    private static int getResistanceLevel(int entityCount) {
        if (entityCount >= 50) {
            return 4;
        }
        if (entityCount >= 20) {
            return 3;
        }
        if (entityCount >= 5) {
            return 2;
        }
        if (entityCount >= 1) {
            return 1;
        }
        return 0;
    }

    private static void applyWorshipEffects(class_3222 player, int level) {
        if (level > 0) {
            WorshipEffectHandler.applyResistanceEffect(player, level);
            WorshipEffectHandler.applyRegenerationEffect(player);
        } else {
            WorshipEffectHandler.removeWorshipEffects(player);
        }
    }

    private static void applyResistanceEffect(class_3222 player, int level) {
        class_1291 resistance = class_1294.field_5907;
        class_1293 currentResistance = player.method_6112(resistance);
        int worshipAmplifier = level - 1;
        boolean shouldApplyEffect = false;
        if (currentResistance == null) {
            shouldApplyEffect = true;
        } else {
            int currentAmplifier = currentResistance.method_5578();
            int remainingDuration = currentResistance.method_5584();
            if (worshipAmplifier >= currentAmplifier && remainingDuration < 200) {
                shouldApplyEffect = true;
            }
        }
        if (shouldApplyEffect) {
            class_1293 worshipResistance = new class_1293(resistance, 200, worshipAmplifier, true, false, false);
            player.method_6092(worshipResistance);
        }
    }

    private static void applyRegenerationEffect(class_3222 player) {
        class_1291 regeneration = class_1294.field_5924;
        class_1293 currentRegeneration = player.method_6112(regeneration);
        int worshipAmplifier = 0;
        boolean shouldApplyEffect = false;
        if (currentRegeneration == null) {
            shouldApplyEffect = true;
        } else {
            int currentAmplifier = currentRegeneration.method_5578();
            int remainingDuration = currentRegeneration.method_5584();
            if (worshipAmplifier >= currentAmplifier && remainingDuration < 200) {
                shouldApplyEffect = true;
            }
        }
        if (shouldApplyEffect) {
            class_1293 worshipRegeneration = new class_1293(regeneration, 200, worshipAmplifier, true, false, false);
            player.method_6092(worshipRegeneration);
        }
    }

    private static void removeWorshipEffects(class_3222 player) {
        class_1293 currentRegeneration;
        class_1293 currentResistance = player.method_6112(class_1294.field_5907);
        if (currentResistance != null && WorshipEffectHandler.isWorshipResistanceEffect(currentResistance)) {
            player.method_6016(class_1294.field_5907);
        }
        if ((currentRegeneration = player.method_6112(class_1294.field_5924)) != null && WorshipEffectHandler.isWorshipRegenerationEffect(currentRegeneration)) {
            player.method_6016(class_1294.field_5924);
        }
    }

    private static boolean isWorshipResistanceEffect(class_1293 effect) {
        return effect.method_5591() && !effect.method_5581() && Math.abs(effect.method_5584() - 200) <= 20;
    }

    private static boolean isWorshipRegenerationEffect(class_1293 effect) {
        return effect.method_5591() && !effect.method_5581() && effect.method_5578() == 0 && Math.abs(effect.method_5584() - 200) <= 20;
    }
}

