/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.item;

import java.lang.reflect.Method;
import java.util.List;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1268;
import net.minecraft.class_1271;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import ydmsama.hundred_years_war.main.entity.utils.BaseCombatSupport;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;

public class BaseScrollItem<T extends class_1309>
extends class_1792 {
    private int equipmentLevel = 1;
    private final class_1299<T> entityType;

    public BaseScrollItem(class_1792.class_1793 properties, class_1299<T> entityType, int equipmentLevel) {
        super(properties);
        this.entityType = entityType;
        this.equipmentLevel = equipmentLevel;
    }

    public void method_7851(class_1799 stack, class_1937 world, List<class_2561> tooltip, class_1836 flag) {
        super.method_7851(stack, world, tooltip, flag);
        String itemName = this.method_7866(stack);
        String descriptionKey = itemName + ".description";
        class_5250 description = class_2561.method_43471((String)descriptionKey);
        if (!description.getString().equals(descriptionKey)) {
            if (world != null && world.field_9236) {
                BaseScrollItem.addWrappedTooltip(tooltip, (class_2561)description);
            } else {
                tooltip.add((class_2561)description);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    private static void addWrappedTooltip(List<class_2561> tooltip, class_2561 component) {
        try {
            Class<?> helperClass = Class.forName("ydmsama.hundred_years_war.client.utils.TooltipHelper");
            Method method = helperClass.getMethod("addToTooltip", List.class, class_2561.class);
            method.invoke(null, tooltip, component);
        }
        catch (Exception e) {
            tooltip.add(component);
        }
    }

    @NotNull
    public class_1271<class_1799> method_7836(class_1937 world, class_1657 player, class_1268 hand) {
        class_3965 hitResult;
        class_1799 stack = player.method_5998(hand);
        if (player.method_5715()) {
            return class_1271.method_22430((Object)stack);
        }
        if (world.field_9236) {
            player.method_23667(hand, true);
        }
        if (!world.field_9236 && (hitResult = BaseScrollItem.method_7872((class_1937)world, (class_1657)player, (class_3959.class_242)class_3959.class_242.field_1348)).method_17783() == class_239.class_240.field_1332) {
            class_2487 entityData = this.getEntityDataFromItem(stack);
            if (this.method_7886(stack)) {
                class_1309 entity = (class_1309)this.entityType.method_5883(world);
                if (entity instanceof BaseCombatSupport) {
                    BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                    entity.method_5749(entityData);
                    boolean friendly = !player.method_7337() || CreativeModeSettings.isSummonFriendly(player);
                    baseCombatSupport.method_6732(friendly ? player.method_5667() : null);
                    if (player.method_7337()) {
                        baseCombatSupport.setRequiresSupply(false);
                    }
                    class_2338 spawnPos = this.getSafeSpawnPosition(world, hitResult.method_17777(), player);
                    entity.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    this.spawnParticles(world, entity.method_23317(), entity.method_23318(), entity.method_23321());
                    world.method_8649((class_1297)entity);
                    baseCombatSupport.setHomePosition(spawnPos);
                    CreativeModeSettings.sendSummonFeedback(player);
                    if (!player.method_7337()) {
                        stack.method_7934(1);
                    }
                    return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
                }
            } else if (player.method_7337() || player.method_31549().field_7477) {
                class_1309 entity = (class_1309)this.entityType.method_5883(world);
                if (entity instanceof BaseCombatSupport) {
                    BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                    class_2338 blockPos = hitResult.method_17777();
                    if (player.method_7337() && CreativeModeSettings.isSummonFriendly(player)) {
                        baseCombatSupport.method_6732(player.method_5667());
                    } else {
                        baseCombatSupport.method_6732(null);
                    }
                    baseCombatSupport.setEquipment(this.getEquipmentLevel());
                    baseCombatSupport.setRequiresSupply(false);
                    class_2338 spawnPos = this.getSafeSpawnPosition(world, blockPos, player);
                    entity.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    this.spawnParticles(world, entity.method_23317(), entity.method_23318(), entity.method_23321());
                    world.method_8649((class_1297)entity);
                    baseCombatSupport.setHomePosition(spawnPos);
                    CreativeModeSettings.sendSummonFeedback(player);
                    return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
                }
            } else {
                class_1309 entity = (class_1309)this.entityType.method_5883(world);
                if (entity instanceof BaseCombatSupport) {
                    BaseCombatSupport baseCombatSupport = (BaseCombatSupport)entity;
                    class_2338 blockPos = hitResult.method_17777();
                    baseCombatSupport.method_6732(player.method_5667());
                    baseCombatSupport.setEquipment(this.getEquipmentLevel());
                    class_2338 spawnPos = this.getSafeSpawnPosition(world, blockPos, player);
                    entity.method_5808((double)spawnPos.method_10263() + 0.5, (double)spawnPos.method_10264(), (double)spawnPos.method_10260() + 0.5, player.method_36454(), player.method_36455());
                    this.spawnParticles(world, entity.method_23317(), entity.method_23318(), entity.method_23321());
                    world.method_8649((class_1297)entity);
                    baseCombatSupport.setHomePosition(spawnPos);
                    CreativeModeSettings.sendSummonFeedback(player);
                    stack.method_7934(1);
                    return class_1271.method_29237((Object)stack, (boolean)world.method_8608());
                }
            }
        }
        return class_1271.method_22430((Object)stack);
    }

    public void saveEntityDataToItem(class_1799 stack, class_2487 entityData) {
        stack.method_7948().method_10566("EntityData", (class_2520)entityData);
    }

    public class_2487 getEntityDataFromItem(class_1799 stack) {
        return stack.method_7948().method_10562("EntityData");
    }

    public boolean method_7886(class_1799 stack) {
        class_2487 tag = stack.method_7969();
        return tag != null && tag.method_10545("EntityData");
    }

    public int getEquipmentLevel() {
        return this.equipmentLevel;
    }

    public void setEquipmentLevel(int equipmentLevel) {
        this.equipmentLevel = equipmentLevel;
    }

    private void spawnParticles(class_1937 world, double x, double y, double z) {
        int particleCount = 40;
        if (world instanceof class_3218) {
            class_3218 serverLevel = (class_3218)world;
            for (int i = 0; i < particleCount; ++i) {
                double offsetX = (world.field_9229.method_43058() - 0.5) * 1.0;
                double offsetY = world.field_9229.method_43058() * 0.5 + 0.5;
                double offsetZ = (world.field_9229.method_43058() - 0.5) * 1.0;
                serverLevel.method_14199((class_2394)class_2398.field_11204, x, y + 0.5, z, 1, offsetX, offsetY, offsetZ, 0.0);
            }
        }
    }

    public class_1299<T> getEntityType() {
        return this.entityType;
    }

    private class_2338 getSafeSpawnPosition(class_1937 world, class_2338 hitPos, class_1657 player) {
        class_2338 spawnPos = hitPos.method_10084();
        if (this.isSafePosition(world, spawnPos)) {
            return spawnPos;
        }
        double radians = Math.toRadians(player.method_36454());
        int offsetX = (int)Math.round(Math.sin(radians));
        int offsetZ = (int)Math.round(-Math.cos(radians));
        for (int i = 1; i <= 3; ++i) {
            class_2338 testPos = hitPos.method_10069(offsetX * i, 0, offsetZ * i);
            for (int y = 0; y <= 2; ++y) {
                class_2338 potentialPos = testPos.method_10086(y);
                if (!this.isSafePosition(world, potentialPos)) continue;
                return potentialPos;
            }
        }
        return player.method_24515();
    }

    private boolean isSafePosition(class_1937 world, class_2338 pos) {
        return world.method_8320(pos).method_26215() && world.method_8320(pos.method_10084()).method_26215();
    }
}

