/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.mixins;

import java.util.UUID;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1496;
import net.minecraft.class_2487;
import net.minecraft.class_5134;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfoReturnable;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.HorseRider;

@Mixin(value={class_1496.class})
public class AbstractHorseMixin {
    private static final UUID RIDER_KNOCKBACK_RESISTANCE_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440011");
    private static final UUID RIDER_SPEED_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440012");
    private static final UUID FORMATION_SPEED_MODIFIER_UUID = UUID.fromString("550e8400-e29b-41d4-a716-446655440001");
    @Unique
    private float hyw$originalMaxHealth = -1.0f;
    @Unique
    private float hyw$originalHealth = -1.0f;
    @Unique
    private boolean hyw$hadPassengerLastTick = false;

    @Inject(method={"getControllingPassenger"}, at={@At(value="HEAD")}, cancellable=true)
    private void onGetControllingPassenger(CallbackInfoReturnable<class_1309> cir) {
        class_1496 horse = (class_1496)this;
        class_1297 firstPassenger = horse.method_31483();
        if (firstPassenger instanceof BaseCombatEntity) {
            BaseCombatEntity baseCombatEntity = (BaseCombatEntity)firstPassenger;
            if (horse.method_6727() && horse.method_6725()) {
                cir.setReturnValue((Object)baseCombatEntity);
            } else {
                cir.setReturnValue(null);
            }
        }
    }

    @Inject(method={"hurt"}, at={@At(value="HEAD")}, cancellable=true)
    private void onHurt(class_1282 damageSource, float amount, CallbackInfoReturnable<Boolean> cir) {
        class_1496 horse = (class_1496)this;
        if (horse.method_37908().field_9236) {
            return;
        }
        class_1297 class_12972 = horse.method_31483();
        if (class_12972 instanceof BaseCombatEntity) {
            BaseCombatEntity rider = (BaseCombatEntity)class_12972;
            if (amount > 0.0f) {
                rider.method_5643(damageSource, amount);
                boolean result = horse.method_5643(damageSource, 0.0f);
                cir.setReturnValue((Object)result);
            }
        }
    }

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    private void onTick(CallbackInfo ci) {
        class_1297 class_12972;
        boolean hasPassengerNow;
        class_1496 horse = (class_1496)this;
        if (horse.method_37908().field_9236) {
            return;
        }
        boolean bl = hasPassengerNow = horse.method_31483() != null;
        if (!hasPassengerNow) {
            if (this.hyw$hadPassengerLastTick && this.hyw$originalMaxHealth > 0.0f && !horse.method_29504() && horse.method_6032() > 0.0f) {
                class_1324 maxHealthAttr = horse.method_5996(class_5134.field_23716);
                if (maxHealthAttr != null) {
                    maxHealthAttr.method_6192((double)this.hyw$originalMaxHealth);
                }
                horse.method_6033(Math.min(this.hyw$originalHealth, this.hyw$originalMaxHealth));
            }
            this.hyw$originalMaxHealth = horse.method_6063();
            this.hyw$originalHealth = horse.method_6032();
        }
        if ((class_12972 = horse.method_31483()) instanceof BaseCombatEntity) {
            class_1322 currentModifier;
            BaseCombatEntity rider = (BaseCombatEntity)class_12972;
            knockbackResistanceAttr = horse.method_5996(class_5134.field_23718);
            if (knockbackResistanceAttr != null && (currentModifier = knockbackResistanceAttr.method_6199(RIDER_KNOCKBACK_RESISTANCE_UUID)) == null) {
                knockbackResistanceAttr.method_26835(new class_1322(RIDER_KNOCKBACK_RESISTANCE_UUID, "BaseCombatEntity rider knockback resistance", 0.8, class_1322.class_1323.field_6328));
            }
            if (rider instanceof HorseRider) {
                HorseRider horseRider = (HorseRider)((Object)rider);
                class_1324 speedAttr = horse.method_5996(class_5134.field_23719);
                if (speedAttr != null) {
                    class_1322 formationModifier = speedAttr.method_6199(FORMATION_SPEED_MODIFIER_UUID);
                    if (formationModifier == null) {
                        double riderSpeed = horseRider.getHorseSpeed();
                        class_1322 currentSpeedModifier = speedAttr.method_6199(RIDER_SPEED_UUID);
                        double speedDifference = riderSpeed - speedAttr.method_6201();
                        if (currentSpeedModifier == null) {
                            speedAttr.method_26835(new class_1322(RIDER_SPEED_UUID, "BaseCombatEntity rider speed", speedDifference, class_1322.class_1323.field_6328));
                        } else if (Math.abs(currentSpeedModifier.method_6186() - speedDifference) > 0.001) {
                            speedAttr.method_6200(RIDER_SPEED_UUID);
                            speedAttr.method_26835(new class_1322(RIDER_SPEED_UUID, "BaseCombatEntity rider speed", speedDifference, class_1322.class_1323.field_6328));
                        }
                    } else {
                        class_1322 currentSpeedModifier = speedAttr.method_6199(RIDER_SPEED_UUID);
                        if (currentSpeedModifier != null) {
                            speedAttr.method_6200(RIDER_SPEED_UUID);
                        }
                    }
                }
            }
        } else {
            class_1322 currentSpeedModifier;
            class_1324 speedAttr;
            class_1322 currentModifier;
            knockbackResistanceAttr = horse.method_5996(class_5134.field_23718);
            if (knockbackResistanceAttr != null && (currentModifier = knockbackResistanceAttr.method_6199(RIDER_KNOCKBACK_RESISTANCE_UUID)) != null) {
                knockbackResistanceAttr.method_6200(RIDER_KNOCKBACK_RESISTANCE_UUID);
            }
            if ((speedAttr = horse.method_5996(class_5134.field_23719)) != null && (currentSpeedModifier = speedAttr.method_6199(RIDER_SPEED_UUID)) != null) {
                speedAttr.method_6200(RIDER_SPEED_UUID);
            }
        }
        this.hyw$hadPassengerLastTick = hasPassengerNow;
    }

    @Inject(method={"addAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onAddAdditionalSaveData(class_2487 compound, CallbackInfo ci) {
        compound.method_10548("hyw_originalMaxHealth", this.hyw$originalMaxHealth);
        compound.method_10548("hyw_originalHealth", this.hyw$originalHealth);
        compound.method_10556("hyw_hadPassengerLastTick", this.hyw$hadPassengerLastTick);
    }

    @Inject(method={"readAdditionalSaveData"}, at={@At(value="TAIL")})
    private void onReadAdditionalSaveData(class_2487 compound, CallbackInfo ci) {
        if (compound.method_10545("hyw_originalMaxHealth")) {
            this.hyw$originalMaxHealth = compound.method_10583("hyw_originalMaxHealth");
        }
        if (compound.method_10545("hyw_originalHealth")) {
            this.hyw$originalHealth = compound.method_10583("hyw_originalHealth");
        }
        if (compound.method_10545("hyw_hadPassengerLastTick")) {
            this.hyw$hadPassengerLastTick = compound.method_10577("hyw_hadPassengerLastTick");
        }
    }
}

