/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network;

import com.google.gson.JsonElement;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1268;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3908;
import net.minecraft.server.MinecraftServer;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.BreedingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstation;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.CraftingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FarmingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.FishingWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.LumberWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.MiningWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportOrderScreenHandler;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationBlockEntity;
import ydmsama.hundred_years_war.main.blocks.workstation.TransportWorkstationScreenHandler;
import ydmsama.hundred_years_war.main.item.TransportOrderItem;
import ydmsama.hundred_years_war.main.network.TransportOrderOpenRequest;
import ydmsama.hundred_years_war.main.network.WorkstationOpenRequest;
import ydmsama.hundred_years_war.main.network.packets.AttackStrategyUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.BombardPositionPacket;
import ydmsama.hundred_years_war.main.network.packets.BreedingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.BuildingToolActionPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearFollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.ClearSelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAddEntityPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffAttackPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffFollowPacket;
import ydmsama.hundred_years_war.main.network.packets.CommandStaffMovePacket;
import ydmsama.hundred_years_war.main.network.packets.CraftingRecipeUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.CreativeSettingsUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.FarmingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FishingWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.FollowTargetPacket;
import ydmsama.hundred_years_war.main.network.packets.FormationSelectionUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.FreecamTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.LumberWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MiningWorkstationRangePacket;
import ydmsama.hundred_years_war.main.network.packets.MoveAttackCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.MoveCommandPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenPlayerSupplyPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenTransportOrderAckPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenTransportOrderSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationAckPacket;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointPacket;
import ydmsama.hundred_years_war.main.network.packets.PatrolPointsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.PlacedBuildingSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PlayerSettingsSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.PlayerSupplyConvertPacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentConfigUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.RelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.SelectionPacket;
import ydmsama.hundred_years_war.main.network.packets.SiegeModeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SpawnPointConfigPacket;
import ydmsama.hundred_years_war.main.network.packets.SquadCreatePacket;
import ydmsama.hundred_years_war.main.network.packets.SquadSelectPacket;
import ydmsama.hundred_years_war.main.network.packets.SupplyRangeTogglePacket;
import ydmsama.hundred_years_war.main.network.packets.SupplyTransferPacket;
import ydmsama.hundred_years_war.main.network.packets.TargetUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TeamApplicationsRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamCreateRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamJoinRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamLeaveRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamManageRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamMembersRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TeamRelationUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.TemplateDataRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TemplateDataResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TemplateListRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.TemplateListResponsePacket;
import ydmsama.hundred_years_war.main.network.packets.TransportActionPacket;
import ydmsama.hundred_years_war.main.network.packets.TransportDataUpdatePacket;
import ydmsama.hundred_years_war.main.network.packets.UnbindTransportOrderPacket;
import ydmsama.hundred_years_war.main.network.packets.UnloadPassengersPacket;
import ydmsama.hundred_years_war.main.network.packets.UpdateTemplatePropertiesPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseDataSyncPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemData;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseItemRequestPacket;
import ydmsama.hundred_years_war.main.network.packets.warehouse.WarehouseSortPacket;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;
import ydmsama.hundred_years_war.main.spawn.SpawnPointScreenHandler;
import ydmsama.hundred_years_war.main.supply.SupplyPointBlockEntity;
import ydmsama.hundred_years_war.main.supply.SupplyPointScreenHandler;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.PlacedBuilding;
import ydmsama.hundred_years_war.main.template.PlacedBuildingRegistry;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;
import ydmsama.hundred_years_war.main.utils.CreativeModeSettings;
import ydmsama.hundred_years_war.main.utils.PlayerSettingsManager;
import ydmsama.hundred_years_war.main.utils.ServerManager;

public class ServerPacketHandler {
    private static final Map<UUID, WorkstationOpenRequest> pendingRequests = new ConcurrentHashMap<UUID, WorkstationOpenRequest>();
    private static final Map<UUID, TransportOrderOpenRequest> pendingTransportOrderRequests = new ConcurrentHashMap<UUID, TransportOrderOpenRequest>();
    private static final ScheduledExecutorService cleanupExecutor = Executors.newSingleThreadScheduledExecutor(r -> {
        Thread t = new Thread(r, "WorkstationRequestCleanup");
        t.setDaemon(true);
        return t;
    });

    public static void registerReceivers() {
        BuildingToolActionPacket.register();
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TemplateDataRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            String templateId = buf.method_19772();
            server.execute(() -> TemplateDataRequestPacket.handlePacket(player, templateId));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TemplateListRequestPacket.ID, (server, player, handler, buf, responseSender) -> server.execute(() -> TemplateListRequestPacket.handle(player)));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UpdateTemplatePropertiesPacket.ID, (server, player, handler, buf, responseSender) -> {
            String templateId = buf.method_19772();
            boolean enableGeneration = buf.readBoolean();
            int generationWeight = buf.readInt();
            int connectionLayerDepth = buf.readInt();
            int minGenerationHeight = buf.readInt();
            int maxGenerationHeight = buf.readInt();
            boolean generateOnSurface = buf.readBoolean();
            int attributeCount = buf.method_10816();
            LinkedHashMap<String, JsonElement> customAttributes = new LinkedHashMap<String, JsonElement>();
            for (int i = 0; i < attributeCount; ++i) {
                String key = buf.method_19772();
                String json = buf.method_19772();
                customAttributes.put(key, UpdateTemplatePropertiesPacket.parseJson(json));
            }
            server.execute(() -> UpdateTemplatePropertiesPacket.handlePacket(player, templateId, enableGeneration, generationWeight, connectionLayerDepth, minGenerationHeight, maxGenerationHeight, generateOnSurface, customAttributes));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SpawnPointConfigPacket.ID, (server, player, handler, buf, responseSender) -> {
            SpawnPointConfigPacket packet = SpawnPointConfigPacket.decode(buf);
            server.execute(() -> SpawnPointConfigPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RelationRequestPacket.RELATION_REQUEST_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            RelationRequestPacket packet = RelationRequestPacket.decode(buf);
            server.execute(() -> RelationRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RelationUpdatePacket.RELATION_UPDATE_PACKET_ID, (server, player, handler, buf, responseSender) -> {
            RelationUpdatePacket packet = RelationUpdatePacket.decode(buf);
            server.execute(() -> RelationUpdatePacket.handleUpdate(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamInfoRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamInfoRequestPacket packet = TeamInfoRequestPacket.decode(buf);
            server.execute(() -> TeamInfoRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamCreateRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamCreateRequestPacket packet = TeamCreateRequestPacket.decode(buf);
            server.execute(() -> TeamCreateRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamJoinRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamJoinRequestPacket packet = TeamJoinRequestPacket.decode(buf);
            server.execute(() -> TeamJoinRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamLeaveRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamLeaveRequestPacket packet = TeamLeaveRequestPacket.decode(buf);
            server.execute(() -> TeamLeaveRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamManageRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamManageRequestPacket packet = TeamManageRequestPacket.decode(buf);
            server.execute(() -> TeamManageRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SelectionPacket.ID, (server, player, handler, buf, responseSender) -> {
            SelectionPacket packet = SelectionPacket.decode(buf);
            server.execute(() -> SelectionPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FormationSelectionUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            FormationSelectionUpdatePacket packet = FormationSelectionUpdatePacket.decode(buf);
            server.execute(() -> FormationSelectionUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)AttackStrategyUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            AttackStrategyUpdatePacket packet = AttackStrategyUpdatePacket.decode(buf);
            server.execute(() -> AttackStrategyUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandPacket packet = CommandPacket.decode(buf);
            server.execute(() -> CommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MoveCommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            MoveCommandPacket packet = MoveCommandPacket.decode(buf);
            server.execute(() -> MoveCommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MoveAttackCommandPacket.ID, (server, player, handler, buf, responseSender) -> {
            MoveAttackCommandPacket packet = MoveAttackCommandPacket.decode(buf);
            server.execute(() -> MoveAttackCommandPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TargetUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            TargetUpdatePacket packet = TargetUpdatePacket.decode(buf);
            server.execute(() -> TargetUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PatrolPointPacket.ID, (server, player, handler, buf, responseSender) -> {
            PatrolPointPacket packet = PatrolPointPacket.decode(buf);
            server.execute(() -> PatrolPointPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FollowTargetPacket.ID, (server, player, handler, buf, responseSender) -> {
            FollowTargetPacket packet = FollowTargetPacket.decode(buf);
            server.execute(() -> FollowTargetPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PatrolPointsRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            PatrolPointsRequestPacket packet = PatrolPointsRequestPacket.decode(buf);
            server.execute(() -> PatrolPointsRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SquadCreatePacket.ID, (server, player, handler, buf, responseSender) -> {
            SquadCreatePacket packet = SquadCreatePacket.decode(buf);
            server.execute(() -> SquadCreatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SquadSelectPacket.ID, (server, player, handler, buf, responseSender) -> {
            SquadSelectPacket packet = SquadSelectPacket.decode(buf);
            server.execute(() -> SquadSelectPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CreativeSettingsUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            CreativeSettingsUpdatePacket packet = CreativeSettingsUpdatePacket.decode(buf);
            server.execute(() -> {
                CreativeSettingsUpdatePacket.handle(player, packet);
                ServerPacketHandler.sendCreativeSettingsSync(player);
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamRelationRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamRelationRequestPacket packet = TeamRelationRequestPacket.decode(buf);
            server.execute(() -> TeamRelationRequestPacket.handle(player, packet.getTeamUUID()));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamRelationUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamRelationUpdatePacket packet = TeamRelationUpdatePacket.decode(buf);
            server.execute(() -> TeamRelationUpdatePacket.handleUpdate(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffAddEntityPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffAddEntityPacket packet = CommandStaffAddEntityPacket.decode(buf);
            server.execute(() -> CommandStaffAddEntityPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffMovePacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffMovePacket packet = CommandStaffMovePacket.decode(buf);
            server.execute(() -> CommandStaffMovePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffFollowPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffFollowPacket packet = CommandStaffFollowPacket.decode(buf);
            server.execute(() -> CommandStaffFollowPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CommandStaffAttackPacket.ID, (server, player, handler, buf, responseSender) -> {
            CommandStaffAttackPacket packet = CommandStaffAttackPacket.decode(buf);
            server.execute(() -> CommandStaffAttackPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamListRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamListRequestPacket packet = TeamListRequestPacket.decode(buf);
            server.execute(() -> TeamListRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamMembersRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamMembersRequestPacket packet = TeamMembersRequestPacket.decode(buf);
            server.execute(() -> TeamMembersRequestPacket.handle(player, packet.getTeamUUID()));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TeamApplicationsRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            TeamApplicationsRequestPacket packet = TeamApplicationsRequestPacket.decode(buf);
            server.execute(() -> TeamApplicationsRequestPacket.handle(player));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SiegeModeTogglePacket.ID, (server, player, handler, buf, responseSender) -> {
            SiegeModeTogglePacket packet = SiegeModeTogglePacket.decode(buf);
            server.execute(() -> SiegeModeTogglePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BombardPositionPacket.ID, (server, player, handler, buf, responseSender) -> {
            BombardPositionPacket packet = BombardPositionPacket.decode(buf);
            server.execute(() -> BombardPositionPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)UnloadPassengersPacket.ID, (server, player, handler, buf, responseSender) -> {
            UnloadPassengersPacket packet = UnloadPassengersPacket.decode(buf);
            server.execute(() -> UnloadPassengersPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RecruitmentDataRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            RecruitmentDataRequestPacket packet = RecruitmentDataRequestPacket.decode(buf);
            server.execute(() -> RecruitmentDataRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)RecruitmentConfigUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            RecruitmentConfigUpdatePacket packet = RecruitmentConfigUpdatePacket.decode(buf);
            server.execute(() -> RecruitmentConfigUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FreecamTogglePacket.ID, (server, player, handler, buf, responseSender) -> {
            FreecamTogglePacket packet = FreecamTogglePacket.decode(buf);
            server.execute(() -> FreecamTogglePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)LumberWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            LumberWorkstationRangePacket packet = LumberWorkstationRangePacket.decode(buf);
            server.execute(() -> LumberWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FarmingWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            FarmingWorkstationRangePacket packet = FarmingWorkstationRangePacket.decode(buf);
            server.execute(() -> FarmingWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)MiningWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            MiningWorkstationRangePacket packet = MiningWorkstationRangePacket.decode(buf);
            server.execute(() -> MiningWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)BreedingWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            BreedingWorkstationRangePacket packet = BreedingWorkstationRangePacket.decode(buf);
            server.execute(() -> BreedingWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)FishingWorkstationRangePacket.ID, (server, player, handler, buf, responseSender) -> {
            FishingWorkstationRangePacket packet = FishingWorkstationRangePacket.decode(buf);
            server.execute(() -> FishingWorkstationRangePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)TransportDataUpdatePacket.ID, (server, player, handler, buf, responseSender) -> TransportDataUpdatePacket.handle(player, buf));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "unbind_transport_order"), (server, player, handler, buf, responseSender) -> server.execute(() -> UnbindTransportOrderPacket.handle(player)));
        ServerPlayNetworking.registerGlobalReceiver((class_2960)CraftingRecipeUpdatePacket.ID, (server, player, handler, buf, responseSender) -> {
            CraftingRecipeUpdatePacket packet = CraftingRecipeUpdatePacket.decode(buf);
            server.execute(() -> CraftingRecipeUpdatePacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "transport_action"), (server, player, handler, buf, responseSender) -> {
            boolean isMainHand = buf.readBoolean();
            server.execute(() -> TransportActionPacket.handle(player, isMainHand));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "open_crafting_inventory"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> CraftingWorkstation.openInventoryScreen(player, pos));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "open_crafting_recipe"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> CraftingWorkstation.openRecipeScreen(player, pos));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OpenWorkstationAckPacket.ID, (server, player, handler, buf, responseSender) -> {
            OpenWorkstationAckPacket packet = OpenWorkstationAckPacket.decode(buf);
            server.execute(() -> ServerPacketHandler.handleWorkstationAck(packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OpenTransportOrderAckPacket.ID, (server, player, handler, buf, responseSender) -> {
            OpenTransportOrderAckPacket packet = OpenTransportOrderAckPacket.decode(buf);
            server.execute(() -> ServerPacketHandler.handleTransportOrderAck(packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)WarehouseItemRequestPacket.ID, (server, player, handler, buf, responseSender) -> {
            WarehouseItemRequestPacket packet = WarehouseItemRequestPacket.decode(buf);
            server.execute(() -> WarehouseItemRequestPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)WarehouseSortPacket.ID, (server, player, handler, buf, responseSender) -> {
            WarehouseSortPacket packet = WarehouseSortPacket.decode(buf);
            server.execute(() -> WarehouseSortPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "warehouse_item_deposit"), (server, player, handler, buf, responseSender) -> {
            class_2338 warehousePos = buf.method_10811();
            server.execute(() -> {
                class_1799 cursorStack;
                WarehouseControlBlockEntity warehouse;
                class_2586 blockEntity = player.method_37908().method_8321(warehousePos);
                if (blockEntity instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((class_1657)player) && !(cursorStack = player.field_7512.method_34255()).method_7960()) {
                    class_1799 remaining = warehouse.tryAddItem(cursorStack);
                    player.field_7512.method_34254(remaining);
                    warehouse.syncToClient(player);
                    player.field_7512.method_7623();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "warehouse_range_update"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            int left = buf.readInt();
            int right = buf.readInt();
            int up = buf.readInt();
            int down = buf.readInt();
            boolean showRange = buf.readBoolean();
            server.execute(() -> {
                WarehouseControlBlockEntity warehouse;
                class_2586 blockEntity = player.method_37908().method_8321(pos);
                if (blockEntity instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((class_1657)player)) {
                    warehouse.setWorkRangeLeft(left);
                    warehouse.setWorkRangeRight(right);
                    warehouse.setWorkRangeUp(up);
                    warehouse.setWorkRangeDown(down);
                    warehouse.setShowRange(showRange);
                    warehouse.method_5431();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)new class_2960("hundred_years_war", "warehouse_toggle_range"), (server, player, handler, buf, responseSender) -> {
            class_2338 pos = buf.method_10811();
            server.execute(() -> {
                WarehouseControlBlockEntity warehouse;
                class_2586 blockEntity = player.method_37908().method_8321(pos);
                if (blockEntity instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((class_1657)player)) {
                    warehouse.setShowRange(!warehouse.isShowRange());
                    warehouse.method_5431();
                }
            });
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SupplyTransferPacket.ID, (server, player, handler, buf, responseSender) -> {
            SupplyTransferPacket packet = SupplyTransferPacket.decode(buf);
            server.execute(() -> SupplyTransferPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)PlayerSupplyConvertPacket.ID, (server, player, handler, buf, responseSender) -> {
            PlayerSupplyConvertPacket packet = PlayerSupplyConvertPacket.decode(buf);
            server.execute(() -> PlayerSupplyConvertPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)OpenPlayerSupplyPacket.ID, (server, player, handler, buf, responseSender) -> {
            OpenPlayerSupplyPacket packet = OpenPlayerSupplyPacket.decode(buf);
            server.execute(() -> OpenPlayerSupplyPacket.handle(player, packet));
        });
        ServerPlayNetworking.registerGlobalReceiver((class_2960)SupplyRangeTogglePacket.ID, (server, player, handler, buf, responseSender) -> {
            SupplyRangeTogglePacket packet = SupplyRangeTogglePacket.decode(buf);
            server.execute(() -> SupplyRangeTogglePacket.handle(player, packet));
        });
    }

    public static void sendCreativeSettingsSync(class_3222 player) {
        CreativeModeSettings.Settings settings = CreativeModeSettings.getSettings((class_1657)player);
        CreativeSettingsSyncPacket packet = new CreativeSettingsSyncPacket(settings.isSummonFriendly(), settings.isControlAllUnits());
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)CreativeSettingsSyncPacket.ID, (class_2540)buf);
    }

    public static void sendPlayerSettingsSync(class_3222 player, PlayerSettingsManager.PlayerSettings settings) {
        PlayerSettingsSyncPacket packet = new PlayerSettingsSyncPacket(settings.getCurrentFormation(), settings.getLastNonNoneFormation(), settings.getRecruitmentSelection());
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PlayerSettingsSyncPacket.ID, (class_2540)buf);
    }

    public static void sendClearFollowTargetToAll(UUID entityUUID) {
        MinecraftServer server = ServerManager.getServer();
        if (server != null) {
            ClearFollowTargetPacket packet = new ClearFollowTargetPacket(entityUUID);
            class_2540 buf = PacketByteBufs.create();
            packet.encode(buf);
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ClearFollowTargetPacket.ID, (class_2540)buf);
            }
        }
    }

    public static void sendClearSelectionToAll(UUID entityUUID) {
        MinecraftServer server = ServerManager.getServer();
        if (server != null) {
            ClearSelectionPacket packet = new ClearSelectionPacket(entityUUID);
            class_2540 buf = PacketByteBufs.create();
            packet.encode(buf);
            for (class_3222 player : server.method_3760().method_14571()) {
                ServerPlayNetworking.send((class_3222)player, (class_2960)ClearSelectionPacket.ID, (class_2540)buf);
            }
        }
    }

    public static void sendOpenTransportOrderSync(class_3222 player, class_1268 hand, class_1799 stack) {
        TransportOrderOpenRequest request = new TransportOrderOpenRequest(player, hand, stack);
        pendingTransportOrderRequests.put(request.getRequestId(), request);
        OpenTransportOrderSyncPacket packet = new OpenTransportOrderSyncPacket(request.getRequestId(), stack);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OpenTransportOrderSyncPacket.ID, (class_2540)buf);
        cleanupExecutor.schedule(() -> {
            TransportOrderOpenRequest req = pendingTransportOrderRequests.get(request.getRequestId());
            if (req != null && req.isExpired()) {
                pendingTransportOrderRequests.remove(request.getRequestId());
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private static void handleTransportOrderAck(OpenTransportOrderAckPacket packet) {
        UUID requestId = packet.getRequestId();
        TransportOrderOpenRequest request = pendingTransportOrderRequests.remove(requestId);
        if (request == null || request.isExpired()) {
            return;
        }
        ServerPacketHandler.openTransportOrderMenu(request);
    }

    private static void openTransportOrderMenu(TransportOrderOpenRequest request) {
        class_3222 player = request.getPlayer();
        final class_1799 stack = player.method_5998(request.getHand());
        if (stack.method_7960() || !(stack.method_7909() instanceof TransportOrderItem)) {
            return;
        }
        class_3908 provider = new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)"screen.hundred_years_war.transport_order");
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 playerEntity) {
                return new TransportOrderScreenHandler(syncId, playerInventory, stack);
            }
        };
        player.method_17355(provider);
    }

    public static void sendOpenWorkstationSync(class_3222 player, class_2338 pos, OpenWorkstationSyncPacket.WorkstationType type) {
        WorkstationOpenRequest request = new WorkstationOpenRequest(player, pos, type);
        pendingRequests.put(request.getRequestId(), request);
        OpenWorkstationSyncPacket packet = new OpenWorkstationSyncPacket(request.getRequestId(), pos, type);
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OpenWorkstationSyncPacket.ID, (class_2540)buf);
        cleanupExecutor.schedule(() -> {
            WorkstationOpenRequest req = pendingRequests.get(request.getRequestId());
            if (req != null && req.isExpired()) {
                pendingRequests.remove(request.getRequestId());
            }
        }, 10L, TimeUnit.SECONDS);
    }

    private static void handleWorkstationAck(OpenWorkstationAckPacket packet) {
        UUID requestId = packet.getRequestId();
        WorkstationOpenRequest request = pendingRequests.remove(requestId);
        if (request == null || request.isExpired()) {
            return;
        }
        ServerPacketHandler.openWorkstationMenu(request.getPlayer(), request.getPos(), request.getType());
    }

    private static void openWorkstationMenu(class_3222 player, class_2338 pos, OpenWorkstationSyncPacket.WorkstationType type) {
        class_3908 menuProvider;
        class_1937 level = player.method_37908();
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity == null) {
            return;
        }
        switch (type) {
            case FARMING: {
                if (!(blockEntity instanceof FarmingWorkstationBlockEntity)) {
                    return;
                }
                FarmingWorkstationBlockEntity farming = (FarmingWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.farming_workstation", (syncId, inventory, p) -> new FarmingWorkstationScreenHandler(syncId, inventory, farming));
                break;
            }
            case MINING: {
                if (!(blockEntity instanceof MiningWorkstationBlockEntity)) {
                    return;
                }
                MiningWorkstationBlockEntity mining = (MiningWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.mining_workstation", (syncId, inventory, p) -> new MiningWorkstationScreenHandler(syncId, inventory, mining));
                break;
            }
            case TRANSPORT: {
                if (!(blockEntity instanceof TransportWorkstationBlockEntity)) {
                    return;
                }
                TransportWorkstationBlockEntity transport = (TransportWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.transport_workstation", (syncId, inventory, p) -> new TransportWorkstationScreenHandler(syncId, inventory, transport));
                break;
            }
            case FISHING: {
                if (!(blockEntity instanceof FishingWorkstationBlockEntity)) {
                    return;
                }
                FishingWorkstationBlockEntity fishing = (FishingWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.fishing_workstation", (syncId, inventory, p) -> new FishingWorkstationScreenHandler(syncId, inventory, fishing));
                break;
            }
            case LUMBER: {
                if (!(blockEntity instanceof LumberWorkstationBlockEntity)) {
                    return;
                }
                LumberWorkstationBlockEntity lumber = (LumberWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.lumber_workstation", (syncId, inventory, p) -> new LumberWorkstationScreenHandler(syncId, inventory, lumber));
                break;
            }
            case CRAFTING: {
                if (!(blockEntity instanceof CraftingWorkstationBlockEntity)) {
                    return;
                }
                CraftingWorkstationBlockEntity crafting = (CraftingWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.crafting_workstation", (syncId, inventory, p) -> new CraftingWorkstationScreenHandler(syncId, inventory, crafting));
                break;
            }
            case BREEDING: {
                if (!(blockEntity instanceof BreedingWorkstationBlockEntity)) {
                    return;
                }
                BreedingWorkstationBlockEntity breeding = (BreedingWorkstationBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.breeding_workstation", (syncId, inventory, p) -> new BreedingWorkstationScreenHandler(syncId, inventory, breeding));
                break;
            }
            case WAREHOUSE: {
                if (!(blockEntity instanceof WarehouseControlBlockEntity)) {
                    return;
                }
                WarehouseControlBlockEntity warehouse = (WarehouseControlBlockEntity)blockEntity;
                warehouse.syncAllDataToClient(player);
                menuProvider = warehouse;
                break;
            }
            case SUPPLY_POINT: {
                if (!(blockEntity instanceof SupplyPointBlockEntity)) {
                    return;
                }
                SupplyPointBlockEntity supplyPoint = (SupplyPointBlockEntity)blockEntity;
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.supply_point", (syncId, inventory, p) -> new SupplyPointScreenHandler(syncId, inventory, supplyPoint));
                break;
            }
            case SPAWN_POINT: {
                if (!(blockEntity instanceof SpawnPointBlockEntity)) {
                    return;
                }
                SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)blockEntity;
                spawnPoint.sync();
                menuProvider = ServerPacketHandler.createMenuProvider("hundred_years_war.spawn_point", (syncId, inventory, p) -> new SpawnPointScreenHandler(syncId, inventory, p, pos));
                break;
            }
            default: {
                return;
            }
        }
        player.method_17355(menuProvider);
    }

    private static class_3908 createMenuProvider(final String translationKey, final MenuFactory factory) {
        return new class_3908(){

            public class_2561 method_5476() {
                return class_2561.method_43471((String)translationKey);
            }

            public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
                return factory.create(syncId, playerInventory, player);
            }
        };
    }

    public static void sendChunkBuildings(class_3222 player, class_1923 chunkPos) {
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(player.method_51469());
        List<PlacedBuilding> buildings = registry.getBuildingsInChunk(chunkPos);
        if (!buildings.isEmpty()) {
            class_2540 buf = PlacedBuildingSyncPacket.createChunkPacket(chunkPos, buildings);
            ServerPlayNetworking.send((class_3222)player, (class_2960)PlacedBuildingSyncPacket.ID, (class_2540)buf);
        }
    }

    public static void sendNearbyBuildings(class_3222 player, class_2338 center, int radius) {
        PlacedBuildingRegistry registry = PlacedBuildingRegistry.get(player.method_51469());
        List<PlacedBuilding> buildings = registry.getBuildingsInArea(center, radius);
        if (!buildings.isEmpty()) {
            class_2540 buf = PlacedBuildingSyncPacket.createAreaPacket(buildings);
            ServerPlayNetworking.send((class_3222)player, (class_2960)PlacedBuildingSyncPacket.ID, (class_2540)buf);
        }
    }

    public static void sendBuildingUpdate(class_3222 player, PlacedBuilding building, boolean isRemoval) {
        class_2540 buf = PlacedBuildingSyncPacket.createUpdatePacket(building, isRemoval);
        ServerPlayNetworking.send((class_3222)player, (class_2960)PlacedBuildingSyncPacket.ID, (class_2540)buf);
    }

    public static void broadcastBuildingUpdate(class_3218 level, PlacedBuilding building, boolean isRemoval) {
        for (class_3222 player : level.method_18456()) {
            ServerPacketHandler.sendBuildingUpdate(player, building, isRemoval);
        }
    }

    public static void sendTemplateData(class_3222 player, String templateId, HywStructureTemplate template) {
        class_2540 buf = PacketByteBufs.create();
        TemplateDataResponsePacket.encode(buf, templateId, template);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TemplateDataResponsePacket.ID, (class_2540)buf);
    }

    public static void sendWarehouseDataSync(class_3222 player, class_2338 blockPos, List<WarehouseItemData> itemDataList, int totalCapacity, int usedCapacity, String sortType, boolean sortAscending) {
        WarehouseDataSyncPacket packet = new WarehouseDataSyncPacket(blockPos, itemDataList, totalCapacity, usedCapacity, sortType, sortAscending);
        class_2540 buf = PacketByteBufs.create();
        WarehouseDataSyncPacket.encode(packet, buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)WarehouseDataSyncPacket.ID, (class_2540)buf);
    }

    public static void sendTemplateList(class_3222 player, Collection<TemplateMetadata> metadataCollection) {
        class_2540 buf = PacketByteBufs.create();
        TemplateListResponsePacket.encode(buf, metadataCollection);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TemplateListResponsePacket.ID, (class_2540)buf);
    }

    public static void sendToPlayer(OpenWorkstationSyncPacket packet, class_3222 player) {
        class_2540 buf = PacketByteBufs.create();
        packet.encode(buf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)OpenWorkstationSyncPacket.ID, (class_2540)buf);
    }

    @FunctionalInterface
    private static interface MenuFactory {
        public class_1703 create(int var1, class_1661 var2, class_1657 var3);
    }
}

