/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.utils.AttackStrategy;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.ServerRelationHelper;

public class AttackStrategyUpdatePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "attack_strategy_update");
    private final String strategyId;

    public AttackStrategyUpdatePacket(String strategyId) {
        this.strategyId = strategyId;
    }

    public void encode(class_2540 buf) {
        buf.method_10814(this.strategyId);
    }

    public static AttackStrategyUpdatePacket decode(class_2540 buf) {
        return new AttackStrategyUpdatePacket(buf.method_19772());
    }

    public static void handle(class_3222 player, AttackStrategyUpdatePacket packet) {
        AttackStrategy strategy = AttackStrategy.fromId(packet.strategyId);
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        HashSet<BaseCombatEntity> targets = new HashSet<BaseCombatEntity>();
        selection.refreshEntities();
        targets.addAll(selection.getEntities());
        AttackStrategyUpdatePacket.addCommandStaffEntities(player, targets);
        for (BaseCombatEntity entity : targets) {
            entity.setAttackStrategy(strategy);
        }
    }

    private static void addCommandStaffEntities(class_3222 player, Set<BaseCombatEntity> targets) {
        for (class_1799 staff : AttackStrategyUpdatePacket.getHeldCommandStaff(player)) {
            class_2487 nbt = staff.method_7969();
            if (nbt == null || !nbt.method_10573("TeamEntityUUIDs", 9)) continue;
            class_2499 uuidList = nbt.method_10554("TeamEntityUUIDs", 8);
            for (int i = 0; i < uuidList.size(); ++i) {
                try {
                    BaseCombatEntity combatEntity;
                    UUID entityUUID = UUID.fromString(uuidList.method_10608(i));
                    class_1297 entity = player.method_51469().method_14190(entityUUID);
                    if (!(entity instanceof BaseCombatEntity) || !(combatEntity = (BaseCombatEntity)entity).method_5805() || !ServerRelationHelper.hasControlOver((class_1657)player, (class_1297)combatEntity)) continue;
                    targets.add(combatEntity);
                    continue;
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
            }
        }
    }

    private static List<class_1799> getHeldCommandStaff(class_3222 player) {
        ArrayList<class_1799> staffs = new ArrayList<class_1799>();
        class_1799 mainHand = player.method_6047();
        class_1799 offHand = player.method_6079();
        if (mainHand.method_7909() instanceof CommandStaffItem) {
            staffs.add(mainHand);
        }
        if (offHand.method_7909() instanceof CommandStaffItem) {
            staffs.add(offHand);
        }
        return staffs;
    }
}

