/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_243;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.entities.siege.PositionAttackable;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;

public class BombardPositionPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "bombard_position");
    private final class_243 position;
    private final boolean cancel;
    private final boolean queueMode;

    public BombardPositionPacket(class_243 position, boolean cancel, boolean queueMode) {
        this.position = position;
        this.cancel = cancel;
        this.queueMode = queueMode;
    }

    public class_243 getPosition() {
        return this.position;
    }

    public boolean isCancel() {
        return this.cancel;
    }

    public boolean isQueueMode() {
        return this.queueMode;
    }

    public void encode(class_2540 buf) {
        if (this.position != null) {
            buf.writeDouble(this.position.field_1352);
            buf.writeDouble(this.position.field_1351);
            buf.writeDouble(this.position.field_1350);
        } else {
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
            buf.writeDouble(0.0);
        }
        buf.writeBoolean(this.cancel);
        buf.writeBoolean(this.queueMode);
    }

    public static BombardPositionPacket decode(class_2540 buf) {
        double x = buf.readDouble();
        double y = buf.readDouble();
        double z = buf.readDouble();
        boolean cancel = buf.readBoolean();
        boolean queueMode = buf.readBoolean();
        class_243 position = cancel ? null : new class_243(x, y, z);
        return new BombardPositionPacket(position, cancel, queueMode);
    }

    public static void handle(class_3222 player, BombardPositionPacket packet) {
        SelectionSystem.Selection selection = SelectionSystem.getSelection(player);
        if (selection != null) {
            List<UUID> entityUUIDs = selection.getEntityUUIDs();
            for (UUID uuid : entityUUIDs) {
                BaseCombatEntity combatEntity;
                class_1297 entity = SelectionSystem.getEntityByUUIDWithinRadius(player, uuid, 200);
                if (!(entity instanceof PositionAttackable)) continue;
                PositionAttackable positionAttackable = (PositionAttackable)entity;
                if (!packet.queueMode && entity instanceof BaseCombatEntity) {
                    combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearCommandedGoals();
                }
                if (entity instanceof BaseCombatEntity) {
                    combatEntity = (BaseCombatEntity)entity;
                    combatEntity.clearPatrolPoints();
                }
                if (packet.isCancel()) {
                    positionAttackable.setPositionTarget(null);
                    continue;
                }
                positionAttackable.setPositionTarget(packet.getPosition());
            }
        }
    }
}

