/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.BaseCombatEntity;
import ydmsama.hundred_years_war.main.entity.goals.TargetAttackGoal;
import ydmsama.hundred_years_war.main.item.CommandStaffItem;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;

public class CommandStaffAttackPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "command_staff_attack_packet");
    private final UUID staffUUID;
    private final UUID targetEntityUUID;

    public CommandStaffAttackPacket(UUID staffUUID, UUID targetEntityUUID) {
        this.staffUUID = staffUUID;
        this.targetEntityUUID = targetEntityUUID;
    }

    public CommandStaffAttackPacket(class_2540 buf) {
        this.staffUUID = buf.method_10790();
        this.targetEntityUUID = buf.method_10790();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.staffUUID);
        buf.method_10797(this.targetEntityUUID);
    }

    public static CommandStaffAttackPacket decode(class_2540 buf) {
        return new CommandStaffAttackPacket(buf);
    }

    public static void handle(class_3222 player, CommandStaffAttackPacket packet) {
        class_3218 world = (class_3218)((EntityAccessor)player).getLevel();
        class_1799 itemStack = CommandStaffAttackPacket.findCommandStaffItem(player, packet.staffUUID);
        class_1297 targetEntity = world.method_14190(packet.targetEntityUUID);
        if (!itemStack.method_7960() && targetEntity instanceof class_1309) {
            class_1309 targetLiving = (class_1309)targetEntity;
            class_2487 nbt = itemStack.method_7948();
            nbt.method_10551("TargetBlockPos");
            nbt.method_10551("AttackMoveBlockPos");
            nbt.method_25927("AttackTargetEntity", packet.targetEntityUUID);
            itemStack.method_7980(nbt);
            if (nbt.method_10573("TeamEntityUUIDs", 9)) {
                class_2499 uuidList = nbt.method_10554("TeamEntityUUIDs", 8);
                for (int i = 0; i < uuidList.size(); ++i) {
                    String uuidString = uuidList.method_10608(i);
                    try {
                        UUID entityUUID = UUID.fromString(uuidString);
                        class_1297 entity = world.method_14190(entityUUID);
                        if (!(entity instanceof BaseCombatEntity)) continue;
                        BaseCombatEntity combatEntity = (BaseCombatEntity)entity;
                        TargetAttackGoal attackGoal = new TargetAttackGoal(combatEntity, 1.0, combatEntity.getAttackReach(), targetLiving);
                        combatEntity.clearCommandedGoals();
                        combatEntity.addCustomGoal(1, attackGoal);
                        continue;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
        }
    }

    private static class_1799 findCommandStaffItem(class_3222 player, UUID staffUUID) {
        class_2487 tag;
        class_1799 mainHandItem = player.method_6047();
        if (!mainHandItem.method_7960() && mainHandItem.method_7909() instanceof CommandStaffItem && (tag = mainHandItem.method_7969()) != null && tag.method_25928("ItemUUID") && tag.method_25926("ItemUUID").equals(staffUUID)) {
            return mainHandItem;
        }
        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
            class_2487 tag2;
            class_1799 stack = player.method_31548().method_5438(i);
            if (stack.method_7960() || !(stack.method_7909() instanceof CommandStaffItem) || (tag2 = stack.method_7969()) == null || !tag2.method_25928("ItemUUID") || !tag2.method_25926("ItemUUID").equals(staffUUID)) continue;
            return stack;
        }
        return class_1799.field_8037;
    }
}

