/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_1657;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.network.packets.RecruitmentDataResponsePacket;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentCategory;
import ydmsama.hundred_years_war.main.recruitment.RecruitmentConfigManager;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class RecruitmentDataRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "recruitment_data_request");
    private final String categoryId;

    public RecruitmentDataRequestPacket(String categoryId) {
        this.categoryId = categoryId;
    }

    public RecruitmentDataRequestPacket() {
        this.categoryId = null;
    }

    public void encode(class_2540 buf) {
        buf.writeBoolean(this.categoryId != null);
        if (this.categoryId != null) {
            buf.method_10814(this.categoryId);
        }
    }

    public static RecruitmentDataRequestPacket decode(class_2540 buf) {
        boolean hasCategory = buf.readBoolean();
        if (hasCategory) {
            String categoryId = buf.method_19772();
            return new RecruitmentDataRequestPacket(categoryId);
        }
        return new RecruitmentDataRequestPacket();
    }

    public static void handle(class_3222 player, RecruitmentDataRequestPacket packet) {
        if (packet.categoryId != null) {
            List<RecruitmentConfig.UnitTypeConfig> unitTypes;
            RecruitmentCategory category = RecruitmentCategory.fromId(packet.categoryId);
            if (category != null) {
                unitTypes = RecruitmentConfigManager.getAvailableUnitTypes((class_1657)player, category);
            } else {
                unitTypes = new ArrayList<RecruitmentConfig.UnitTypeConfig>();
                System.err.println("\u672a\u627e\u5230\u62db\u52df\u7c7b\u522b: " + packet.categoryId);
            }
            RecruitmentDataResponsePacket response = new RecruitmentDataResponsePacket(packet.categoryId, unitTypes);
            class_2540 buf = PacketByteBufs.create();
            response.encode(buf);
            ServerPlayNetworking.send((class_3222)player, (class_2960)RecruitmentDataResponsePacket.ID, (class_2540)buf);
            System.out.println("\u5411\u73a9\u5bb6 " + player.method_5477().getString() + " \u53d1\u9001\u62db\u52df\u6570\u636e\uff0c\u7c7b\u522b: " + packet.categoryId + "\uff0c\u5175\u79cd\u6570\u91cf: " + unitTypes.size());
        } else {
            for (RecruitmentCategory category : RecruitmentConfigManager.getAllCategories()) {
                List<RecruitmentConfig.UnitTypeConfig> unitTypes = RecruitmentConfigManager.getAvailableUnitTypes((class_1657)player, category);
                RecruitmentDataResponsePacket response = new RecruitmentDataResponsePacket(category.getId(), unitTypes);
                class_2540 buf = PacketByteBufs.create();
                response.encode(buf);
                ServerPlayNetworking.send((class_3222)player, (class_2960)RecruitmentDataResponsePacket.ID, (class_2540)buf);
                System.out.println("\u5411\u73a9\u5bb6 " + player.method_5477().getString() + " \u53d1\u9001\u62db\u52df\u6570\u636e\uff0c\u7c7b\u522b: " + category.getId() + "\uff0c\u5175\u79cd\u6570\u91cf: " + unitTypes.size());
            }
        }
    }

    public String getCategoryId() {
        return this.categoryId;
    }
}

