/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1297;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.entity.entities.puppets.IPuppet;
import ydmsama.hundred_years_war.main.mixins.EntityAccessor;
import ydmsama.hundred_years_war.main.selection.SelectionSystem;
import ydmsama.hundred_years_war.main.utils.PuppetStateHandler;

public class SquadCreatePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "squad_create_packet");
    private final int number;

    public SquadCreatePacket(int number) {
        this.number = number;
    }

    public int getNumber() {
        return this.number;
    }

    public static SquadCreatePacket decode(class_2540 buf) {
        int number = buf.readInt();
        return new SquadCreatePacket(number);
    }

    public void encode(class_2540 buf) {
        buf.writeInt(this.number);
    }

    public static void handle(class_3222 player, SquadCreatePacket packet) {
        int number = packet.getNumber();
        SelectionSystem.Selection currentSelection = SelectionSystem.getSelection(player);
        if (currentSelection != null) {
            SelectionSystem.getSquads().computeIfAbsent(player.method_5667(), k -> new ArrayList());
            List<SelectionSystem.Squad> playerSquads = SelectionSystem.getSquads().get(player.method_5667());
            while (playerSquads.size() <= number) {
                playerSquads.add(null);
            }
            List<UUID> entityUUIDs = currentSelection.getEntityUUIDs();
            SelectionSystem.Squad squad = new SelectionSystem.Squad(entityUUIDs);
            playerSquads.set(number, squad);
            if (SquadCreatePacket.containsPuppetEntity(player, entityUUIDs)) {
                PuppetStateHandler.updatePuppetSquadState(player.method_5667(), number, entityUUIDs);
            } else {
                PuppetStateHandler.clearPuppetSquadState(player.method_5667(), number);
            }
        }
    }

    private static boolean containsPuppetEntity(class_3222 player, List<UUID> entityUUIDs) {
        class_3218 serverWorld = (class_3218)((EntityAccessor)player).getLevel();
        for (UUID entityUUID : entityUUIDs) {
            class_1297 entity = serverWorld.method_14190(entityUUID);
            if (!(entity instanceof IPuppet)) continue;
            IPuppet puppet = (IPuppet)entity;
            if (!player.method_5667().equals(puppet.method_6139())) continue;
            return true;
        }
        return false;
    }
}

