/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.network.packets.TeamInfoRequestPacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamLeaveRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_leave");
    private final UUID teamUUID;

    public TeamLeaveRequestPacket(UUID teamUUID) {
        this.teamUUID = teamUUID;
    }

    public TeamLeaveRequestPacket(class_2540 buf) {
        this.teamUUID = buf.method_10790();
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
    }

    public static TeamLeaveRequestPacket decode(class_2540 buf) {
        return new TeamLeaveRequestPacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public static void handle(class_3222 player, TeamLeaveRequestPacket packet) {
        UUID playerUUID = player.method_5667();
        UUID teamUUID = packet.getTeamUUID();
        TeamRelationData teamData = RelationSystem.getTeamRelationData(teamUUID);
        if (teamData == null) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.team_not_found"));
            return;
        }
        if (!teamData.isMember(playerUUID)) {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.not_in_team"));
            return;
        }
        boolean isOwner = teamData.getMemberType(playerUUID) == TeamRelationData.MemberType.OWNER;
        String teamName = teamData.getTeamName();
        int memberCount = teamData.getAllMembers().size();
        boolean success = RelationSystem.leaveTeam(playerUUID, teamUUID);
        if (success) {
            if (isOwner) {
                if (memberCount == 1) {
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.disbanded_team", (Object[])new Object[]{teamName}));
                } else {
                    player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.left_team_as_owner", (Object[])new Object[]{teamName}));
                    for (UUID memberUUID : teamData.getAllMembers().keySet()) {
                        class_3222 member;
                        if (memberUUID.equals(playerUUID) || (member = player.method_5682().method_3760().method_14602(memberUUID)) == null) continue;
                        member.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.owner_left", (Object[])new Object[]{player.method_5477().getString()}));
                    }
                }
            } else {
                player.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.left_team", (Object[])new Object[]{teamName}));
                for (UUID memberUUID : teamData.getAllMembers().keySet()) {
                    class_3222 member = player.method_5682().method_3760().method_14602(memberUUID);
                    if (member == null) continue;
                    member.method_43496((class_2561)class_2561.method_43469((String)"message.hundred_years_war.member_left", (Object[])new Object[]{player.method_5477().getString()}));
                }
            }
        } else {
            player.method_43496((class_2561)class_2561.method_43471((String)"message.hundred_years_war.leave_failed"));
        }
        TeamInfoRequestPacket.handle(player);
    }
}

