/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.fabricmc.fabric.api.networking.v1.PacketByteBufs;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.network.packets.TeamListResponsePacket;
import ydmsama.hundred_years_war.main.utils.RelationSystem;
import ydmsama.hundred_years_war.main.utils.TeamRelationData;

public class TeamListRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_list_request");

    public TeamListRequestPacket() {
    }

    public TeamListRequestPacket(class_2540 buf) {
    }

    public void encode(class_2540 buf) {
    }

    public static TeamListRequestPacket decode(class_2540 buf) {
        return new TeamListRequestPacket(buf);
    }

    public static void handle(class_3222 player) {
        TeamListResponsePacket responsePacket = new TeamListResponsePacket();
        Map<UUID, TeamRelationData> allTeams = RelationSystem.getAllTeams();
        UUID playerTeamUUID = RelationSystem.getPlayerTeamUUID(player.method_5667());
        for (Map.Entry<UUID, TeamRelationData> entry : allTeams.entrySet()) {
            UUID teamUUID = entry.getKey();
            TeamRelationData teamData = entry.getValue();
            UUID ownerUUID = null;
            for (Map.Entry<UUID, TeamRelationData.MemberType> memberEntry : teamData.getAllMembers().entrySet()) {
                if (memberEntry.getValue() != TeamRelationData.MemberType.OWNER) continue;
                ownerUUID = memberEntry.getKey();
                break;
            }
            String ownerName = ownerUUID != null ? Optional.ofNullable(player.method_5682().method_3760().method_14602(ownerUUID)).map(p -> p.method_5477().getString()).orElse("Unknown") : "Unknown";
            int memberCount = teamData.getAllMembers().size();
            RelationSystem.RelationType relation = RelationSystem.getPlayerRelationWithTeam(player.method_5667(), teamUUID);
            responsePacket.addTeam(teamUUID, teamData.getTeamName(), memberCount, ownerName, relation);
        }
        class_2540 responseBuf = PacketByteBufs.create();
        responsePacket.encode(responseBuf);
        ServerPlayNetworking.send((class_3222)player, (class_2960)TeamListResponsePacket.ID, (class_2540)responseBuf);
    }
}

