/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2540;
import net.minecraft.class_2960;

public class TeamMembersResponsePacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "team_members_response");
    private final UUID teamUUID;
    private final String teamName;
    private final List<Member> members;

    public TeamMembersResponsePacket(UUID teamUUID, String teamName, List<Member> members) {
        this.teamUUID = teamUUID;
        this.teamName = teamName;
        this.members = members;
    }

    public TeamMembersResponsePacket(class_2540 buf) {
        this.teamUUID = buf.method_10790();
        this.teamName = buf.method_19772();
        int size = buf.readInt();
        this.members = new ArrayList<Member>(size);
        for (int i = 0; i < size; ++i) {
            String playerName = buf.method_19772();
            UUID playerUUID = buf.method_10790();
            Member.Role role = Member.Role.values()[buf.readByte()];
            long joinTime = buf.readLong();
            this.members.add(new Member(playerName, playerUUID, role, joinTime));
        }
    }

    public void encode(class_2540 buf) {
        buf.method_10797(this.teamUUID);
        buf.method_10814(this.teamName);
        buf.writeInt(this.members.size());
        for (Member member : this.members) {
            buf.method_10814(member.getPlayerName());
            buf.method_10797(member.getPlayerUUID());
            buf.writeByte(member.getRole().ordinal());
            buf.writeLong(member.getJoinTime());
        }
    }

    public static TeamMembersResponsePacket decode(class_2540 buf) {
        return new TeamMembersResponsePacket(buf);
    }

    public UUID getTeamUUID() {
        return this.teamUUID;
    }

    public String getTeamName() {
        return this.teamName;
    }

    public List<Member> getMembers() {
        return this.members;
    }

    public static class Member {
        private final String playerName;
        private final UUID playerUUID;
        private final Role role;
        private final long joinTime;

        public Member(String playerName, UUID playerUUID, Role role, long joinTime) {
            this.playerName = playerName;
            this.playerUUID = playerUUID;
            this.role = role;
            this.joinTime = joinTime;
        }

        public String getPlayerName() {
            return this.playerName;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public Role getRole() {
            return this.role;
        }

        public long getJoinTime() {
            return this.joinTime;
        }

        public static enum Role {
            OWNER,
            ADMIN,
            MEMBER;

        }
    }
}

