/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets;

import com.google.gson.JsonElement;
import com.google.gson.JsonParser;
import com.google.gson.JsonPrimitive;
import com.google.gson.JsonSyntaxException;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.template.TemplateManager;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;

public class UpdateTemplatePropertiesPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "update_template_properties");

    public static void handlePacket(class_3222 player, String templateId, boolean enableGeneration, int generationWeight, int connectionLayerDepth, int minGenerationHeight, int maxGenerationHeight, boolean generateOnSurface, Map<String, JsonElement> customAttributes) {
        System.out.println("[DEBUG] Received template properties update for: " + templateId);
        System.out.println("[DEBUG] Values: enableGen=" + enableGeneration + ", weight=" + generationWeight + ", depth=" + connectionLayerDepth + ", minHeight=" + minGenerationHeight + ", maxHeight=" + maxGenerationHeight + ", onSurface=" + generateOnSurface);
        TemplateManager templateManager = TemplateManager.getInstance();
        if (!templateManager.isInitialized()) {
            System.out.println("[DEBUG] Server TemplateManager not initialized, initializing now...");
            templateManager.initialize(player.method_5682());
        }
        System.out.println("[DEBUG] Available template IDs on server: " + templateManager.getAllTemplateIds());
        TemplateMetadata metadata = templateManager.getMetadata(templateId);
        if (metadata == null) {
            System.out.println("[DEBUG] Template metadata not found for ID: " + templateId);
            System.out.println("[DEBUG] Trying to rescan templates...");
            templateManager.rescanTemplates();
            metadata = templateManager.getMetadata(templateId);
            if (metadata == null) {
                player.method_7353((class_2561)class_2561.method_43470((String)("Template not found: " + templateId)).method_27692(class_124.field_1061), true);
                return;
            }
        }
        System.out.println("[DEBUG] Found template metadata: " + metadata.getName());
        metadata.setGenerationEnabled(enableGeneration);
        metadata.setGenerationWeight(generationWeight);
        metadata.setConnectionLayerDepth(connectionLayerDepth);
        metadata.setMinGenerationHeight(minGenerationHeight);
        metadata.setMaxGenerationHeight(maxGenerationHeight);
        metadata.setGenerateOnSurface(generateOnSurface);
        metadata.setCustomAttributes(customAttributes);
        metadata.ensureCommonAttributes();
        boolean success = templateManager.saveMetadataToFile(templateId, metadata);
        System.out.println("[DEBUG] Save result: " + success);
        if (success) {
            player.method_7353((class_2561)class_2561.method_43469((String)"gui.hundred_years_war.template_properties.saved", (Object[])new Object[]{metadata.getName()}).method_27692(class_124.field_1060), true);
        } else {
            player.method_7353((class_2561)class_2561.method_43470((String)"Failed to save template properties").method_27692(class_124.field_1061), true);
        }
    }

    public static JsonElement parseJson(String json) {
        try {
            return JsonParser.parseString((String)json);
        }
        catch (JsonSyntaxException e) {
            return new JsonPrimitive(json);
        }
    }
}

