/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.network.packets.warehouse;

import net.minecraft.class_1657;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2540;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlBlockEntity;
import ydmsama.hundred_years_war.main.blocks.warehouse.WarehouseControlScreenHandler;

public class WarehouseItemRequestPacket {
    public static final class_2960 ID = new class_2960("hundred_years_war", "warehouse_item_request");
    private final class_2338 blockPos;
    private final class_1799 requestItem;
    private final int actualCount;
    private final boolean shiftClick;
    private final boolean rightClick;

    public WarehouseItemRequestPacket(class_2338 blockPos, class_1799 requestItem, boolean shiftClick, boolean rightClick) {
        this.blockPos = blockPos;
        this.requestItem = requestItem.method_7972();
        this.actualCount = requestItem.method_7947();
        this.requestItem.method_7939(1);
        this.shiftClick = shiftClick;
        this.rightClick = rightClick;
    }

    public static void encode(WarehouseItemRequestPacket packet, class_2540 buf) {
        buf.method_10807(packet.blockPos);
        buf.method_10793(packet.requestItem);
        buf.method_10804(packet.actualCount);
        buf.writeBoolean(packet.shiftClick);
        buf.writeBoolean(packet.rightClick);
    }

    public static WarehouseItemRequestPacket decode(class_2540 buf) {
        class_2338 pos = buf.method_10811();
        class_1799 item = buf.method_10819();
        int actualCount = buf.method_10816();
        item.method_7939(actualCount);
        boolean shiftClick = buf.readBoolean();
        boolean rightClick = buf.readBoolean();
        return new WarehouseItemRequestPacket(pos, item, shiftClick, rightClick);
    }

    public static void handle(class_3222 player, WarehouseItemRequestPacket packet) {
        WarehouseControlBlockEntity warehouse;
        class_2586 blockEntity = player.method_37908().method_8321(packet.blockPos);
        if (blockEntity instanceof WarehouseControlBlockEntity && (warehouse = (WarehouseControlBlockEntity)blockEntity).stillValid((class_1657)player)) {
            class_1799 requestItem = packet.getRequestItem();
            boolean rightClick = packet.rightClick;
            boolean shiftClick = packet.shiftClick;
            class_1799 cursorStack = player.field_7512.method_34255();
            if (!cursorStack.method_7960()) {
                class_1799 remaining = warehouse.tryAddItem(cursorStack);
                player.field_7512.method_34254(remaining);
            } else {
                int available = warehouse.getItemCount(requestItem);
                int requestCount = rightClick ? Math.min((available + 1) / 2, requestItem.method_7914()) : Math.min(available, requestItem.method_7914());
                class_1799 extractRequest = requestItem.method_7972();
                extractRequest.method_7939(requestCount);
                class_1799 extracted = warehouse.tryExtractItem(extractRequest);
                if (!extracted.method_7960()) {
                    class_1703 class_17032;
                    if (shiftClick && (class_17032 = player.field_7512) instanceof WarehouseControlScreenHandler) {
                        WarehouseControlScreenHandler screenHandler = (WarehouseControlScreenHandler)class_17032;
                        if (!screenHandler.moveItemStackToPublic(extracted, 0, 36, false)) {
                            warehouse.tryAddItem(extracted);
                        }
                    } else {
                        player.field_7512.method_34254(extracted);
                    }
                }
            }
            warehouse.syncToClient(player);
            player.field_7512.method_7623();
        }
    }

    public class_2338 getBlockPos() {
        return this.blockPos;
    }

    public class_1799 getRequestItem() {
        class_1799 result = this.requestItem.method_7972();
        result.method_7939(this.actualCount);
        return result;
    }

    public boolean isShiftClick() {
        return this.shiftClick;
    }

    public boolean isRightClick() {
        return this.rightClick;
    }
}

