/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.recruitment;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.recruitment.data.RecruitmentConfig;

public class RecruitmentConditionChecker {
    private static final Map<String, Boolean> globalConditions = new HashMap<String, Boolean>();

    public static boolean checkConditions(class_1657 player, RecruitmentConfig.ArmyLevelConfig armyLevel) {
        List<String> conditions = armyLevel.getConditions();
        if (conditions == null || conditions.isEmpty()) {
            return true;
        }
        for (String condition : conditions) {
            if (RecruitmentConditionChecker.checkSingleCondition(player, condition)) continue;
            return false;
        }
        return true;
    }

    private static boolean checkSingleCondition(class_1657 player, String condition) {
        if ("allow_level_4_army_summoning".equals(condition)) {
            return ServerModConfig.INSTANCE.isAllowLevel4ArmySummoning();
        }
        if ("allow_necromancy_summoning".equals(condition)) {
            return ServerModConfig.INSTANCE.isAllowNecromancySummoning();
        }
        if (globalConditions.containsKey(condition)) {
            return globalConditions.get(condition);
        }
        if (condition.startsWith("exp_required_")) {
            try {
                int requiredExp = Integer.parseInt(condition.substring("exp_required_".length()));
                int playerExp = RecruitmentConditionChecker.getTotalExperience(player);
                return playerExp >= requiredExp;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        if (condition.startsWith("player_level_")) {
            try {
                int requiredLevel = Integer.parseInt(condition.substring("player_level_".length()));
                return player.field_7520 >= requiredLevel;
            }
            catch (NumberFormatException e) {
                return false;
            }
        }
        return false;
    }

    public static void setGlobalCondition(String condition, boolean value) {
        globalConditions.put(condition, value);
    }

    public static boolean getGlobalCondition(String condition) {
        return globalConditions.getOrDefault(condition, false);
    }

    private static int getTotalExperience(class_1657 player) {
        int currentExp = (int)(player.field_7510 * (float)player.method_7349()) + RecruitmentConditionChecker.getTotalExperienceForLevel(player.field_7520);
        return currentExp;
    }

    private static int getTotalExperienceForLevel(int level) {
        if (level < 0) {
            return 0;
        }
        if (level <= 16) {
            return level * level + 6 * level;
        }
        if (level <= 31) {
            return (int)(2.5 * (double)level * (double)level - 40.5 * (double)level + 360.0);
        }
        return (int)(4.5 * (double)level * (double)level - 162.5 * (double)level + 2220.0);
    }
}

