/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.spawn;

import java.util.List;
import java.util.Locale;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1747;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2237;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2464;
import net.minecraft.class_2487;
import net.minecraft.class_2498;
import net.minecraft.class_2499;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_259;
import net.minecraft.class_2591;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3726;
import net.minecraft.class_3727;
import net.minecraft.class_3965;
import net.minecraft.class_4970;
import net.minecraft.class_5558;
import net.minecraft.class_7923;
import org.jetbrains.annotations.Nullable;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.item.BuildingToolItem;
import ydmsama.hundred_years_war.main.network.ServerPacketHandler;
import ydmsama.hundred_years_war.main.network.packets.OpenWorkstationSyncPacket;
import ydmsama.hundred_years_war.main.spawn.SpawnPointBlockEntity;

public class SpawnPointBlock
extends class_2237 {
    private static final class_265 FULL_BLOCK_SHAPE = class_2248.method_9541((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)2.0, (double)16.0);

    public SpawnPointBlock() {
        super(class_4970.class_2251.method_9637().method_9634().method_22488().method_51371().method_9618().method_9632(0.0f).method_9626(class_2498.field_11543).method_42327());
    }

    public class_2464 method_9604(class_2680 state) {
        return class_2464.field_11455;
    }

    public class_265 method_9530(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shouldDisplay(context) ? FULL_BLOCK_SHAPE : class_259.method_1073();
    }

    public class_265 method_26159(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return this.shouldDisplay(context) ? FULL_BLOCK_SHAPE : class_259.method_1073();
    }

    public class_265 method_9549(class_2680 state, class_1922 level, class_2338 pos, class_3726 context) {
        return class_259.method_1073();
    }

    public class_1269 method_9534(class_2680 state, class_1937 level, class_2338 pos, class_1657 player, class_1268 hand, class_3965 hit) {
        if (!level.field_9236 && player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            class_2586 be = level.method_8321(pos);
            if (be instanceof SpawnPointBlockEntity) {
                SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)be;
                spawnPoint.sync();
                ServerPacketHandler.sendOpenWorkstationSync(serverPlayer, pos, OpenWorkstationSyncPacket.WorkstationType.SPAWN_POINT);
            }
        }
        return class_1269.method_29236((boolean)level.field_9236);
    }

    public class_2586 method_10123(class_2338 pos, class_2680 state) {
        return new SpawnPointBlockEntity(pos, state);
    }

    public <T extends class_2586> class_5558<T> method_31645(class_1937 level, class_2680 state, class_2591<T> type) {
        if (!level.field_9236) {
            return SpawnPointBlock.method_31618(type, ModBlockEntities.SPAWN_POINT, (lvl, blockPos, blockState, blockEntity) -> blockEntity.serverTick());
        }
        return null;
    }

    private boolean shouldDisplay(class_3726 context) {
        class_3727 entityContext;
        class_1297 class_12972;
        if (context instanceof class_3727 && (class_12972 = (entityContext = (class_3727)context).method_32480()) instanceof class_1309) {
            class_1657 player;
            class_1309 living = (class_1309)class_12972;
            if (living instanceof class_1657 && (player = (class_1657)living).method_7337()) {
                return true;
            }
            return this.isHighlightStack(living.method_6047()) || this.isHighlightStack(living.method_6079());
        }
        return false;
    }

    private boolean isHighlightStack(class_1799 stack) {
        if (stack.method_7960()) {
            return false;
        }
        return stack.method_31574(this.method_8389()) || stack.method_7909() instanceof BuildingToolItem;
    }

    public void method_9536(class_2680 state, class_1937 level, class_2338 pos, class_2680 newState, boolean isMoving) {
        if (!state.method_27852(newState.method_26204())) {
            // empty if block
        }
        super.method_9536(state, level, pos, newState, isMoving);
    }

    public class_1799 method_9574(class_1922 level, class_2338 pos, class_2680 state) {
        class_1799 stack = super.method_9574(level, pos, state);
        class_2586 blockEntity = level.method_8321(pos);
        if (blockEntity instanceof SpawnPointBlockEntity) {
            SpawnPointBlockEntity spawnPoint = (SpawnPointBlockEntity)blockEntity;
            spawnPoint.method_38240(stack);
        }
        return stack;
    }

    public void method_9568(class_1799 stack, @Nullable class_1922 level, List<class_2561> tooltip, class_1836 flag) {
        long resetInterval;
        super.method_9568(stack, level, tooltip, flag);
        class_2487 tag = class_1747.method_38072((class_1799)stack);
        if (tag == null || tag.method_33133()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.hundred_years_war.spawn_point.no_data").method_27692(class_124.field_1080));
            return;
        }
        tooltip.add((class_2561)class_2561.method_43471((String)"item.hundred_years_war.spawn_point.header").method_27692(class_124.field_1065));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.activation_distance", (Object[])new Object[]{SpawnPointBlock.formatDouble(tag.method_10574("ActivationDistance"))}).method_27692(class_124.field_1080));
        tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.range", (Object[])new Object[]{SpawnPointBlock.formatDouble(tag.method_10574("HorizontalRange")), SpawnPointBlock.formatDouble(tag.method_10574("VerticalRange"))}).method_27692(class_124.field_1080));
        int perSpawn = tag.method_10550("PerSpawn");
        tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.per_spawn", (Object[])new Object[]{perSpawn}).method_27692(class_124.field_1080));
        if (tag.method_10577("Infinite")) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.hundred_years_war.spawn_point.infinite").method_27692(class_124.field_1075));
        } else {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.remaining", (Object[])new Object[]{tag.method_10550("Remaining")}).method_27692(class_124.field_1080));
        }
        int maxActive = tag.method_10550("MaxActive");
        if (maxActive > 0) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.max_active", (Object[])new Object[]{maxActive}).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.interval", (Object[])new Object[]{tag.method_10550("MinInterval"), tag.method_10550("MaxInterval")}).method_27692(class_124.field_1080));
        if (tag.method_10577("PeriodicReset") && (resetInterval = tag.method_10537("ResetInterval")) > 0L) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.periodic_reset", (Object[])new Object[]{resetInterval}).method_27692(class_124.field_1080));
        }
        tooltip.add((class_2561)class_2561.method_43471((String)(tag.method_10577("Paused") ? "item.hundred_years_war.spawn_point.state.paused" : "item.hundred_years_war.spawn_point.state.running")).method_27692(class_124.field_1080));
        class_2499 entries = tag.method_10554("SpawnEntries", 10);
        if (entries.isEmpty()) {
            tooltip.add((class_2561)class_2561.method_43471((String)"item.hundred_years_war.spawn_point.entries_empty").method_27692(class_124.field_1061));
            return;
        }
        tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.entries", (Object[])new Object[]{entries.size()}).method_27692(class_124.field_1065));
        int displayCount = Math.min(entries.size(), 3);
        for (int i = 0; i < displayCount; ++i) {
            class_2487 entry = entries.method_10602(i);
            class_2960 entityId = new class_2960(entry.method_10558("id"));
            int weight = entry.method_10550("weight");
            class_2561 name = class_7923.field_41177.method_17966(entityId).map(class_1299::method_5897).orElse((class_2561)class_2561.method_43470((String)entityId.toString()));
            tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.entry", (Object[])new Object[]{name, weight}).method_27692(class_124.field_1063));
        }
        if (entries.size() > displayCount) {
            tooltip.add((class_2561)class_2561.method_43469((String)"item.hundred_years_war.spawn_point.entry_more", (Object[])new Object[]{entries.size() - displayCount}).method_27692(class_124.field_1063));
        }
    }

    private static String formatDouble(double value) {
        return String.format(Locale.ROOT, "%.1f", value);
    }
}

