/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import java.util.UUID;
import net.minecraft.class_1263;
import net.minecraft.class_1277;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1735;
import net.minecraft.class_1799;
import net.minecraft.class_3913;
import net.minecraft.class_3914;
import net.minecraft.class_3917;
import net.minecraft.class_3919;
import ydmsama.hundred_years_war.main.supply.SupplyDataEncoding;
import ydmsama.hundred_years_war.main.supply.SupplyManager;

public class PlayerSupplyScreenHandler
extends class_1703 {
    public static final class_3917<PlayerSupplyScreenHandler> TYPE = new class_3917(PlayerSupplyScreenHandler::new, null);
    private final class_1277 foodContainer;
    private final class_3913 containerData;
    private final UUID playerUUID;
    private static final int DAILY_CONSUMPTION_SLOT = 3;
    private class_3914 containerAccess = class_3914.field_17304;

    public PlayerSupplyScreenHandler(int syncId, class_1661 playerInventory) {
        super(TYPE, syncId);
        this.playerUUID = playerInventory.field_7546.method_5667();
        this.foodContainer = new class_1277(9);
        this.containerData = new class_3919(4);
        this.updateContainerData(playerInventory.field_7546);
        this.method_17360(this.containerData);
        for (int i = 0; i < 9; ++i) {
            this.method_7621(new class_1735((class_1263)this.foodContainer, i, 8 + i * 18, 35){

                public boolean method_7680(class_1799 stack) {
                    return stack.method_19267();
                }
            });
        }
        for (int row = 0; row < 3; ++row) {
            for (int col = 0; col < 9; ++col) {
                this.method_7621(new class_1735((class_1263)playerInventory, col + row * 9 + 9, 8 + col * 18, 120 + row * 18));
            }
        }
        for (int col = 0; col < 9; ++col) {
            this.method_7621(new class_1735((class_1263)playerInventory, col, 8 + col * 18, 178));
        }
    }

    private void updateContainerData(class_1657 player) {
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(player.method_5667());
        if (source != null) {
            this.containerData.method_17391(0, (int)source.getSupplyValue());
            this.containerData.method_17391(1, (int)source.getMaxSupplyValue());
            this.containerData.method_17391(2, source.getSuppliedEntities().size());
            this.containerData.method_17391(3, SupplyDataEncoding.encode(SupplyManager.getDailyConsumption(player.method_5667())));
        } else {
            this.containerData.method_17391(0, 0);
            this.containerData.method_17391(1, 1000);
            this.containerData.method_17391(2, 0);
            this.containerData.method_17391(3, 0);
        }
    }

    public void method_7623() {
        super.method_7623();
        for (int i = 0; i < this.field_7761.size(); ++i) {
            if (!(((class_1735)this.field_7761.get((int)i)).field_7871 instanceof class_1661)) continue;
            class_1661 inv = (class_1661)((class_1735)this.field_7761.get((int)i)).field_7871;
            this.updateContainerData(inv.field_7546);
            break;
        }
    }

    public void convertFood() {
        int i;
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.playerUUID);
        if (source == null) {
            SupplyManager.registerSupplySource(this.playerUUID, SupplyManager.SupplySourceType.PLAYER, 1000.0);
            source = SupplyManager.getSupplySource(this.playerUUID);
        }
        if (source == null) {
            return;
        }
        double remainingCapacity = Math.max(0.0, source.getMaxSupplyValue() - source.getSupplyValue());
        if (remainingCapacity <= 0.0) {
            return;
        }
        double totalSupply = 0.0;
        double EPSILON = 1.0E-6;
        boolean inventoryChanged = false;
        for (i = 0; i < this.foodContainer.method_5439() && !(remainingCapacity <= 0.0); ++i) {
            int maxConvertible;
            int nutrition;
            double supplyPerItem;
            class_1799 stack = this.foodContainer.method_5438(i);
            if (stack.method_7960() || !stack.method_19267() || (supplyPerItem = SupplyManager.convertFoodToSupply(nutrition = stack.method_7909().method_19264().method_19230())) <= 0.0 || (maxConvertible = (int)Math.min((double)stack.method_7947(), Math.floor((remainingCapacity + 1.0E-6) / supplyPerItem))) <= 0) continue;
            double convertedSupply = supplyPerItem * (double)maxConvertible;
            totalSupply += convertedSupply;
            if ((remainingCapacity -= convertedSupply) < 1.0E-6) {
                remainingCapacity = 0.0;
            }
            inventoryChanged = true;
            if (maxConvertible == stack.method_7947()) {
                this.foodContainer.method_5447(i, class_1799.field_8037);
                continue;
            }
            stack.method_7934(maxConvertible);
            this.foodContainer.method_5447(i, stack);
        }
        if (totalSupply > 0.0) {
            if (inventoryChanged) {
                this.foodContainer.method_5431();
            }
            source.addSupply(totalSupply);
            for (i = 0; i < this.field_7761.size(); ++i) {
                if (!(((class_1735)this.field_7761.get((int)i)).field_7871 instanceof class_1661)) continue;
                class_1661 inv = (class_1661)((class_1735)this.field_7761.get((int)i)).field_7871;
                this.updateContainerData(inv.field_7546);
                break;
            }
            this.method_7623();
        }
    }

    public class_1799 method_7601(class_1657 player, int index) {
        class_1799 result = class_1799.field_8037;
        class_1735 slot = (class_1735)this.field_7761.get(index);
        if (slot != null && slot.method_7681()) {
            class_1799 slotStack = slot.method_7677();
            result = slotStack.method_7972();
            if (index < 9) {
                if (!this.method_7616(slotStack, 9, 45, true)) {
                    return class_1799.field_8037;
                }
            } else if (slotStack.method_19267()) {
                if (!this.method_7616(slotStack, 0, 9, false)) {
                    return class_1799.field_8037;
                }
            } else {
                return class_1799.field_8037;
            }
            if (slotStack.method_7960()) {
                slot.method_7673(class_1799.field_8037);
            } else {
                slot.method_7668();
            }
            if (slotStack.method_7947() == result.method_7947()) {
                return class_1799.field_8037;
            }
            slot.method_7667(player, slotStack);
        }
        return result;
    }

    public boolean method_7597(class_1657 player) {
        return true;
    }

    public void method_7595(class_1657 player) {
        super.method_7595(player);
        if (!player.method_37908().field_9236) {
            for (int i = 0; i < this.foodContainer.method_5439(); ++i) {
                class_1799 stack = this.foodContainer.method_5438(i);
                if (stack.method_7960()) continue;
                player.method_7328(stack, false);
            }
        }
    }

    public double getStoredSupply() {
        return this.containerData.method_17390(0);
    }

    public double getMaxStoredSupply() {
        return this.containerData.method_17390(1);
    }

    public int getSuppliedEntityCount() {
        return this.containerData.method_17390(2);
    }

    public double getDailyConsumption() {
        return SupplyDataEncoding.decode(this.containerData.method_17390(3));
    }

    public boolean isDailyConsumptionClamped() {
        return SupplyDataEncoding.isClamped(this.containerData.method_17390(3));
    }

    public double getDailyConsumptionDisplayCap() {
        return SupplyDataEncoding.getClampValue();
    }

    public void setContainerAccess(class_3914 access) {
        this.containerAccess = access;
    }
}

