/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.supply;

import java.util.UUID;
import net.minecraft.class_1262;
import net.minecraft.class_1263;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_238;
import net.minecraft.class_2487;
import net.minecraft.class_2586;
import net.minecraft.class_2622;
import net.minecraft.class_2680;
import ydmsama.hundred_years_war.main.blocks.ModBlockEntities;
import ydmsama.hundred_years_war.main.supply.SupplyManager;
import ydmsama.hundred_years_war.main.utils.RelationSystem;

public class SupplyPointBlockEntity
extends class_2586
implements class_1263 {
    private static final int CONTAINER_SIZE = 9;
    private class_2371<class_1799> items = class_2371.method_10213((int)9, (Object)class_1799.field_8037);
    private UUID blockEntityId = UUID.randomUUID();
    private double storedSupply = 0.0;
    private double maxStoredSupply = 1000.0;
    private int conversionProgress = 0;
    private static final int CONVERSION_RATE = 10;
    private double supplyToTransfer = 0.0;
    private boolean showRange = false;
    private UUID ownerUuid;
    private String ownerName = "";

    public SupplyPointBlockEntity(class_2338 pos, class_2680 blockState) {
        super(ModBlockEntities.SUPPLY_POINT, pos, blockState);
        SupplyManager.registerSupplySource(this.blockEntityId, SupplyManager.SupplySourceType.SUPPLY_POINT, this.maxStoredSupply, pos);
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
        }
    }

    public void setOwner(class_1657 player) {
        if (player != null) {
            this.setOwner(player.method_5667(), player.method_7334().getName());
        }
    }

    public void setOwner(UUID ownerUuid, String ownerName) {
        this.ownerUuid = ownerUuid;
        this.ownerName = ownerName != null ? ownerName : "";
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            SupplyManager.setSupplySourceOwner(this.blockEntityId, ownerUuid);
            SupplyManager.registerSupplySource(this.blockEntityId, SupplyManager.SupplySourceType.SUPPLY_POINT, this.maxStoredSupply, this.method_11016());
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public UUID getOwnerUuid() {
        return this.ownerUuid;
    }

    public String getOwnerName() {
        return this.ownerName;
    }

    public boolean canPlayerAccess(class_1657 player) {
        if (player == null) {
            return false;
        }
        if (this.ownerUuid == null) {
            return true;
        }
        UUID playerUuid = player.method_5667();
        if (this.ownerUuid.equals(playerUuid)) {
            return true;
        }
        RelationSystem.RelationType forward = RelationSystem.getRelation(this.ownerUuid, playerUuid);
        RelationSystem.RelationType backward = RelationSystem.getRelation(playerUuid, this.ownerUuid);
        if (forward == RelationSystem.RelationType.HOSTILE || backward == RelationSystem.RelationType.HOSTILE) {
            return false;
        }
        return forward == RelationSystem.RelationType.FRIENDLY || forward == RelationSystem.RelationType.CONTROL || backward == RelationSystem.RelationType.FRIENDLY || backward == RelationSystem.RelationType.CONTROL;
    }

    public void tick() {
        double actualSupply;
        if (this.field_11863 == null || this.field_11863.field_9236) {
            return;
        }
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null && Math.abs((actualSupply = source.getSupplyValue()) - this.storedSupply) > 0.001) {
            this.storedSupply = actualSupply;
            this.method_5431();
        }
        ++this.conversionProgress;
        if (this.conversionProgress >= 20) {
            this.conversionProgress = 0;
            this.convertFoodToSupply();
        }
    }

    private void convertFoodToSupply() {
        int foodConverted = 0;
        for (int i = 0; i < this.items.size() && foodConverted < 10; ++i) {
            int foodValue;
            double supplyValue;
            class_1799 stack = (class_1799)this.items.get(i);
            if (stack.method_7960() || !stack.method_19267() || !(this.storedSupply + (supplyValue = SupplyManager.convertFoodToSupply(foodValue = stack.method_7909().method_19264().method_19230())) <= this.maxStoredSupply)) continue;
            stack.method_7934(1);
            this.storedSupply += supplyValue;
            ++foodConverted;
            this.method_5431();
            SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
            if (source == null) continue;
            source.setSupplyValue(this.storedSupply);
        }
    }

    public void depositSupply(double amount) {
        this.storedSupply = Math.min(this.storedSupply + amount, this.maxStoredSupply);
        this.method_5431();
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
        }
    }

    public double withdrawSupply(double amount) {
        double withdrawn = Math.min(amount, this.storedSupply);
        this.storedSupply -= withdrawn;
        this.method_5431();
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
        }
        return withdrawn;
    }

    protected void method_11007(class_2487 tag) {
        super.method_11007(tag);
        class_1262.method_5426((class_2487)tag, this.items);
        tag.method_25927("BlockEntityId", this.blockEntityId);
        tag.method_10549("StoredSupply", this.storedSupply);
        tag.method_10549("MaxStoredSupply", this.maxStoredSupply);
        tag.method_10569("ConversionProgress", this.conversionProgress);
        tag.method_10549("SupplyToTransfer", this.supplyToTransfer);
        tag.method_10556("ShowRange", this.showRange);
        if (this.ownerUuid != null) {
            tag.method_25927("OwnerUUID", this.ownerUuid);
        }
        if (!this.ownerName.isEmpty()) {
            tag.method_10582("OwnerName", this.ownerName);
        }
    }

    public void method_11014(class_2487 tag) {
        super.method_11014(tag);
        this.items = class_2371.method_10213((int)this.method_5439(), (Object)class_1799.field_8037);
        class_1262.method_5429((class_2487)tag, this.items);
        if (tag.method_10545("BlockEntityId")) {
            UUID loadedId = tag.method_25926("BlockEntityId");
            SupplyManager.unregisterSupplySource(this.blockEntityId);
            this.blockEntityId = loadedId;
            SupplyManager.registerSupplySource(loadedId, SupplyManager.SupplySourceType.SUPPLY_POINT, this.maxStoredSupply, this.method_11016());
        }
        this.storedSupply = tag.method_10574("StoredSupply");
        this.maxStoredSupply = tag.method_10574("MaxStoredSupply");
        this.conversionProgress = tag.method_10550("ConversionProgress");
        this.supplyToTransfer = tag.method_10574("SupplyToTransfer");
        this.showRange = tag.method_10577("ShowRange");
        this.ownerUuid = tag.method_10545("OwnerUUID") ? tag.method_25926("OwnerUUID") : null;
        this.ownerName = tag.method_10545("OwnerName") ? tag.method_10558("OwnerName") : "";
        SupplyManager.SupplySource source = SupplyManager.getSupplySource(this.blockEntityId);
        if (source != null) {
            source.setSupplyValue(this.storedSupply);
            source.setBlockPos(this.method_11016());
            if (this.ownerUuid != null) {
                source.setOwnerId(this.ownerUuid);
            }
        }
    }

    public void method_11012() {
        super.method_11012();
        SupplyManager.unregisterSupplySource(this.blockEntityId);
    }

    public class_2487 method_16887() {
        class_2487 tag = super.method_16887();
        this.method_11007(tag);
        return tag;
    }

    public class_2622 getUpdatePacket() {
        return class_2622.method_38585((class_2586)this);
    }

    public int method_5439() {
        return 9;
    }

    public boolean method_5442() {
        for (class_1799 stack : this.items) {
            if (stack.method_7960()) continue;
            return false;
        }
        return true;
    }

    public class_1799 method_5438(int slot) {
        return (class_1799)this.items.get(slot);
    }

    public class_1799 method_5434(int slot, int amount) {
        class_1799 result = class_1262.method_5430(this.items, (int)slot, (int)amount);
        if (!result.method_7960()) {
            this.method_5431();
        }
        return result;
    }

    public class_1799 method_5441(int slot) {
        return class_1262.method_5428(this.items, (int)slot);
    }

    public void method_5447(int slot, class_1799 stack) {
        this.items.set(slot, (Object)stack);
        if (stack.method_7947() > this.method_5444()) {
            stack.method_7939(this.method_5444());
        }
        this.method_5431();
    }

    public boolean method_5443(class_1657 player) {
        if (this.field_11863.method_8321(this.field_11867) != this) {
            return false;
        }
        return player.method_5649((double)this.field_11867.method_10263() + 0.5, (double)this.field_11867.method_10264() + 0.5, (double)this.field_11867.method_10260() + 0.5) <= 64.0;
    }

    public void method_5448() {
        this.items.clear();
        this.method_5431();
    }

    public UUID getBlockEntityId() {
        return this.blockEntityId;
    }

    public double getStoredSupply() {
        return this.storedSupply;
    }

    public double getMaxStoredSupply() {
        return this.maxStoredSupply;
    }

    public double getDailyConsumption() {
        return SupplyManager.getDailyConsumption(this.blockEntityId);
    }

    public void setSupplyToTransfer(double amount) {
        this.supplyToTransfer = amount;
    }

    public double getSupplyToTransfer() {
        return this.supplyToTransfer;
    }

    public boolean isShowRange() {
        return this.showRange;
    }

    public void setShowRange(boolean showRange) {
        this.showRange = showRange;
        this.method_5431();
        if (this.field_11863 != null && !this.field_11863.field_9236) {
            this.field_11863.method_8413(this.method_11016(), this.method_11010(), this.method_11010(), 3);
        }
    }

    public class_238 getSupplyArea() {
        int range = 50;
        class_2338 pos = this.method_11016();
        return new class_238((double)(pos.method_10263() - range), (double)(pos.method_10264() - range), (double)(pos.method_10260() - range), (double)(pos.method_10263() + range + 1), (double)(pos.method_10264() + range + 1), (double)(pos.method_10260() + range + 1));
    }
}

