/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template;

import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.net.URL;
import java.nio.file.CopyOption;
import java.nio.file.FileSystem;
import java.nio.file.FileSystemNotFoundException;
import java.nio.file.FileSystems;
import java.nio.file.FileVisitOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_2338;
import net.minecraft.class_2680;
import net.minecraft.class_5218;
import net.minecraft.server.MinecraftServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ydmsama.hundred_years_war.main.template.HywStructureTemplate;
import ydmsama.hundred_years_war.main.template.TemplateMetadata;
import ydmsama.hundred_years_war.main.template.TemplateSerializer;

public class TemplateManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(TemplateManager.class);
    private static final String TEMPLATE_DIR = "hundredyearswar/templates";
    private static final String TEMPLATE_EXTENSION = ".hywt";
    private static final int MAX_CACHE_SIZE = 20;
    private static final String CONFIG_TEMPLATES_DIR = "config/hundredyearswar/templates";
    private static final String RESOURCES_TEMPLATES_DIR = "assets/hundred_years_war/templates";
    private static TemplateManager instance;
    private final Map<String, TemplateMetadata> metadataIndex = new ConcurrentHashMap<String, TemplateMetadata>();
    private final Map<String, Path> fileIndex = new ConcurrentHashMap<String, Path>();
    private final LinkedHashMap<String, HywStructureTemplate> templateCache = new LinkedHashMap<String, HywStructureTemplate>(16, 0.75f, true){

        @Override
        protected boolean removeEldestEntry(Map.Entry<String, HywStructureTemplate> eldest) {
            return this.size() > 20;
        }
    };
    private final Map<String, Set<String>> categoryIndex = new ConcurrentHashMap<String, Set<String>>();
    private final Map<String, Set<String>> authorIndex = new ConcurrentHashMap<String, Set<String>>();
    private Path userTemplateDirectory;
    private Path legacyTemplateDirectory;
    private boolean initialized = false;

    private static void logInfo(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.info(message, args);
        }
    }

    private static void logWarn(String message, Object ... args) {
        if (LOGGER.isDebugEnabled()) {
            LOGGER.warn(message, args);
        }
    }

    private TemplateManager() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static TemplateManager getInstance() {
        if (instance != null) return instance;
        Class<TemplateManager> clazz = TemplateManager.class;
        synchronized (TemplateManager.class) {
            if (instance != null) return instance;
            instance = new TemplateManager();
            // ** MonitorExit[var0] (shouldn't be in output)
            return instance;
        }
    }

    public void initializeClient() {
        if (this.initialized) {
            return;
        }
        try {
            this.userTemplateDirectory = this.resolveConfigTemplatesDir();
            this.legacyTemplateDirectory = Path.of(CONFIG_TEMPLATES_DIR, new String[0]).toAbsolutePath();
            Files.createDirectories(this.userTemplateDirectory, new FileAttribute[0]);
            if (!Files.exists(this.legacyTemplateDirectory, new LinkOption[0])) {
                Files.createDirectories(this.legacyTemplateDirectory, new FileAttribute[0]);
            }
            this.scanTemplates();
            this.initialized = true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialize template manager (client)", (Throwable)e);
        }
    }

    public void initialize(MinecraftServer server) {
        if (this.initialized) {
            return;
        }
        try {
            this.userTemplateDirectory = this.resolveConfigTemplatesDir();
            this.legacyTemplateDirectory = Path.of(CONFIG_TEMPLATES_DIR, new String[0]).toAbsolutePath();
            Files.createDirectories(this.userTemplateDirectory, new FileAttribute[0]);
            if (!Files.exists(this.legacyTemplateDirectory, new LinkOption[0])) {
                Files.createDirectories(this.legacyTemplateDirectory, new FileAttribute[0]);
            }
            this.migrateOldTemplates(server);
            this.scanTemplates();
            this.initialized = true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to initialize template manager", (Throwable)e);
        }
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public Set<String> getAllTemplateIds() {
        return new HashSet<String>(this.metadataIndex.keySet());
    }

    public void rescanTemplates() {
        this.userTemplateDirectory = this.resolveConfigTemplatesDir();
        this.legacyTemplateDirectory = Path.of(CONFIG_TEMPLATES_DIR, new String[0]).toAbsolutePath();
        try {
            Files.createDirectories(this.userTemplateDirectory, new FileAttribute[0]);
            if (!Files.exists(this.legacyTemplateDirectory, new LinkOption[0])) {
                Files.createDirectories(this.legacyTemplateDirectory, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            LOGGER.error("Failed to prepare template directories during rescan", (Throwable)e);
        }
        this.metadataIndex.clear();
        this.fileIndex.clear();
        this.categoryIndex.clear();
        this.authorIndex.clear();
        this.scanTemplates();
    }

    private void migrateOldTemplates(MinecraftServer server) {
        block8: {
            try {
                Path worldPath = server.method_27050(class_5218.field_24188);
                Path oldTemplateDir = worldPath.resolve(TEMPLATE_DIR);
                if (!Files.exists(oldTemplateDir, new LinkOption[0])) break block8;
                try (Stream<Path> paths = Files.walk(oldTemplateDir, new FileVisitOption[0]);){
                    paths.filter((? super T x$0) -> Files.isRegularFile(x$0, new LinkOption[0])).filter((? super T path) -> path.toString().endsWith(TEMPLATE_EXTENSION)).forEach(oldPath -> {
                        try {
                            Path relativePath = oldTemplateDir.relativize((Path)oldPath);
                            Path newPath = this.userTemplateDirectory.resolve(relativePath);
                            Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                            if (!Files.exists(newPath, new LinkOption[0])) {
                                Files.copy(oldPath, newPath, new CopyOption[0]);
                            }
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    });
                }
            }
            catch (Exception e) {
                TemplateManager.logWarn("Error during template migration: {}", e.getMessage());
            }
        }
    }

    private void scanTemplates() {
        this.scanDirectory(this.userTemplateDirectory, false);
        if (this.legacyTemplateDirectory != null && !this.legacyTemplateDirectory.equals(this.userTemplateDirectory)) {
            this.scanDirectory(this.legacyTemplateDirectory, false);
        }
        this.scanBundledTemplates();
    }

    private void scanBundledTemplates() {
        boolean scanned = false;
        Path devResourcePath = Path.of("src/main/resources", RESOURCES_TEMPLATES_DIR);
        URL resourceUrl = this.getClass().getClassLoader().getResource(RESOURCES_TEMPLATES_DIR);
        if (resourceUrl != null) {
            try {
                String protocol = resourceUrl.getProtocol();
                if ("jar".equalsIgnoreCase(protocol)) {
                    scanned = this.scanJarResource(resourceUrl);
                } else if ("file".equalsIgnoreCase(protocol)) {
                    Path resourcePath = Path.of(resourceUrl.toURI());
                    if (Files.exists(resourcePath, new LinkOption[0])) {
                        this.scanDirectory(resourcePath, true);
                        scanned = true;
                    }
                } else {
                    TemplateManager.logWarn("Unsupported protocol {} while scanning bundled templates", protocol);
                }
            }
            catch (Exception e) {
                TemplateManager.logWarn("Failed to scan bundled templates: {}", e.getMessage());
            }
        }
        if (!scanned && Files.exists(devResourcePath, new LinkOption[0])) {
            this.scanDirectory(devResourcePath, true);
        }
    }

    private boolean scanJarResource(URL resourceUrl) throws Exception {
        Path resourcePath;
        FileSystem fileSystem;
        URI resourceUri = resourceUrl.toURI();
        String uriString = resourceUri.toString();
        int separator = uriString.indexOf(33);
        if (separator < 0) {
            TemplateManager.logWarn("Invalid JAR URI for resource templates: {}", uriString);
            return false;
        }
        URI jarUri = URI.create(uriString.substring(0, separator));
        String entryPath = uriString.substring(separator + 1);
        if (entryPath.startsWith("/")) {
            entryPath = entryPath.substring(1);
        }
        try {
            fileSystem = FileSystems.getFileSystem(jarUri);
        }
        catch (FileSystemNotFoundException e) {
            fileSystem = FileSystems.newFileSystem(jarUri, Collections.emptyMap());
        }
        Path path = resourcePath = entryPath.isEmpty() ? fileSystem.getPath("/", new String[0]) : fileSystem.getPath(entryPath, new String[0]);
        if (resourcePath != null && Files.exists(resourcePath, new LinkOption[0])) {
            this.scanDirectory(resourcePath, true);
            return true;
        }
        TemplateManager.logWarn("Template path {} not found inside {}", entryPath, jarUri);
        return false;
    }

    private void scanDirectory(Path directory, boolean isResource) {
        if (!Files.exists(directory, new LinkOption[0])) {
            return;
        }
        try (Stream<Path> paths = Files.walk(directory, new FileVisitOption[0]);){
            paths.filter((? super T x$0) -> Files.isRegularFile(x$0, new LinkOption[0])).filter((? super T path) -> path.toString().endsWith(TEMPLATE_EXTENSION)).forEach(path -> this.indexTemplate((Path)path, directory, isResource));
        }
        catch (IOException e) {
            LOGGER.error("Error scanning directory: {}", (Object)directory, (Object)e);
        }
    }

    private void indexTemplate(Path templatePath, Path baseDirectory, boolean isResource) {
        try {
            TemplateMetadata metadata = TemplateSerializer.deserializeMetadata(templatePath);
            Path relativePath = baseDirectory.relativize(templatePath);
            Object templateId = relativePath.toString().replace(TEMPLATE_EXTENSION, "").replace(File.separator, "/");
            if (isResource) {
                templateId = "resource/" + (String)templateId;
            }
            metadata.setTemplateId((String)templateId);
            metadata.ensureCommonAttributes();
            this.metadataIndex.put((String)templateId, metadata);
            this.fileIndex.put((String)templateId, templatePath);
            String category = metadata.getCategory() != null ? metadata.getCategory() : "\u672a\u5206\u7c7b";
            String author = metadata.getAuthor() != null ? metadata.getAuthor() : "Unknown";
            this.categoryIndex.computeIfAbsent(category, k -> new HashSet()).add(templateId);
            this.authorIndex.computeIfAbsent(author, k -> new HashSet()).add(templateId);
        }
        catch (IOException e) {
            TemplateManager.logWarn("Failed to index template: {}", templatePath, e);
        }
    }

    private void indexTemplate(Path templatePath) {
        this.indexTemplate(templatePath, this.userTemplateDirectory, false);
    }

    private Path resolveConfigTemplatesDir() {
        return FabricLoader.getInstance().getConfigDir().resolve("hundredyearswar").resolve("templates");
    }

    public TemplateMetadata getMetadata(String templateId) {
        return this.metadataIndex.get(templateId);
    }

    public Collection<TemplateMetadata> getAllMetadata() {
        return Collections.unmodifiableCollection(this.metadataIndex.values());
    }

    public List<TemplateMetadata> getByCategory(String category) {
        Set<String> ids = this.categoryIndex.get(category);
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(this.metadataIndex::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<TemplateMetadata> getByAuthor(String author) {
        Set<String> ids = this.authorIndex.get(author);
        if (ids == null) {
            return Collections.emptyList();
        }
        return ids.stream().map(this.metadataIndex::get).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<TemplateMetadata> search(String query) {
        String lowerQuery = query.toLowerCase();
        return this.metadataIndex.values().stream().filter((? super T metadata) -> metadata.getName().toLowerCase().contains(lowerQuery) || metadata.getDescription().toLowerCase().contains(lowerQuery) || metadata.getCategory().toLowerCase().contains(lowerQuery)).collect(Collectors.toList());
    }

    public List<TemplateMetadata> filter(FilterCriteria criteria) {
        Stream<TemplateMetadata> stream = this.metadataIndex.values().stream();
        if (criteria.category != null) {
            stream = stream.filter((? super T m) -> m.getCategory().equals(criteria.category));
        }
        if (criteria.author != null) {
            stream = stream.filter((? super T m) -> m.getAuthor().equals(criteria.author));
        }
        if (criteria.minSize != null) {
            stream = stream.filter((? super T m) -> {
                int volume = m.getSize().method_10263() * m.getSize().method_10264() * m.getSize().method_10260();
                return volume >= criteria.minSize;
            });
        }
        if (criteria.maxSize != null) {
            stream = stream.filter((? super T m) -> {
                int volume = m.getSize().method_10263() * m.getSize().method_10264() * m.getSize().method_10260();
                return volume <= criteria.maxSize;
            });
        }
        if (criteria.minBlocks != null) {
            stream = stream.filter((? super T m) -> m.getTotalBlocks() >= criteria.minBlocks);
        }
        if (criteria.maxBlocks != null) {
            stream = stream.filter((? super T m) -> m.getTotalBlocks() <= criteria.maxBlocks);
        }
        return stream.collect(Collectors.toList());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public HywStructureTemplate loadTemplate(String templateId) {
        LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
        synchronized (linkedHashMap) {
            HywStructureTemplate cached = this.templateCache.get(templateId);
            if (cached != null) {
                return cached;
            }
        }
        Path templatePath = this.fileIndex.get(templateId);
        if (templatePath == null || Files.notExists(templatePath, new LinkOption[0])) {
            this.rescanTemplates();
            templatePath = this.fileIndex.get(templateId);
            if (templatePath == null || Files.notExists(templatePath, new LinkOption[0])) {
                return null;
            }
        }
        try {
            HywStructureTemplate template = TemplateSerializer.deserializeFull(templatePath);
            LinkedHashMap<String, HywStructureTemplate> linkedHashMap2 = this.templateCache;
            synchronized (linkedHashMap2) {
                this.templateCache.put(templateId, template);
            }
            return template;
        }
        catch (IOException e) {
            LOGGER.error("Failed to load template: {}", (Object)templateId, (Object)e);
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveTemplate(HywStructureTemplate template, String templateId) {
        try {
            String category = template.getCategory();
            Path saveDirectory = this.userTemplateDirectory;
            Object fullTemplateId = templateId;
            if (category != null && !category.isEmpty() && !category.equals("\u672a\u5206\u7c7b")) {
                String[] folders = category.split("[/\\\\]+");
                StringBuilder pathBuilder = new StringBuilder();
                for (String folder : folders) {
                    if ((folder = folder.replaceAll("[<>:\"|?*]", "_").trim()).isEmpty()) continue;
                    saveDirectory = saveDirectory.resolve(folder);
                    if (pathBuilder.length() > 0) {
                        pathBuilder.append("/");
                    }
                    pathBuilder.append(folder);
                }
                if (pathBuilder.length() > 0) {
                    fullTemplateId = pathBuilder.toString() + "/" + templateId;
                }
            }
            Files.createDirectories(saveDirectory, new FileAttribute[0]);
            Path templatePath = saveDirectory.resolve(templateId + TEMPLATE_EXTENSION);
            TemplateSerializer.serialize(template, templatePath);
            long fileSize = Files.size(templatePath);
            TemplateMetadata metadata = new TemplateMetadata(template.getName(), template.getCategory(), template.getDescription(), template.getSize(), template.getEntrance(), template.getAuthor(), template.getCreatedTime(), template.getTotalBlocks(), template.getBlockCount(), templatePath.getFileName().toString(), fileSize);
            metadata.setTemplateId((String)fullTemplateId);
            metadata.setGenerationEnabled(template.isGenerationEnabled());
            metadata.setGenerationWeight(template.getGenerationWeight());
            metadata.setConnectionLayerDepth(template.getConnectionLayerDepth());
            metadata.setMinGenerationHeight(template.getMinGenerationHeight());
            metadata.setMaxGenerationHeight(template.getMaxGenerationHeight());
            metadata.setGenerateOnSurface(template.isGenerateOnSurface());
            metadata.setCustomAttributes(template.getCustomAttributes());
            metadata.ensureCommonAttributes();
            this.metadataIndex.put((String)fullTemplateId, metadata);
            this.fileIndex.put((String)fullTemplateId, templatePath);
            this.categoryIndex.computeIfAbsent(template.getCategory(), k -> new HashSet()).add(fullTemplateId);
            this.authorIndex.computeIfAbsent(template.getAuthor(), k -> new HashSet()).add(fullTemplateId);
            LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
            synchronized (linkedHashMap) {
                this.templateCache.put((String)fullTemplateId, template);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to save template: {}", (Object)templateId, (Object)e);
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean deleteTemplate(String templateId) {
        if (this.isResourceTemplate(templateId)) {
            TemplateManager.logWarn("Attempted to delete bundled resource template: {}", templateId);
            return false;
        }
        Path templatePath = this.fileIndex.get(templateId);
        if (templatePath == null) {
            return false;
        }
        try {
            Files.deleteIfExists(templatePath);
            TemplateMetadata metadata = this.metadataIndex.remove(templateId);
            this.fileIndex.remove(templateId);
            if (metadata != null) {
                Set<String> authorTemplates;
                Set<String> categoryTemplates = this.categoryIndex.get(metadata.getCategory());
                if (categoryTemplates != null) {
                    categoryTemplates.remove(templateId);
                    if (categoryTemplates.isEmpty()) {
                        this.categoryIndex.remove(metadata.getCategory());
                    }
                }
                if ((authorTemplates = this.authorIndex.get(metadata.getAuthor())) != null) {
                    authorTemplates.remove(templateId);
                    if (authorTemplates.isEmpty()) {
                        this.authorIndex.remove(metadata.getAuthor());
                    }
                }
            }
            LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
            synchronized (linkedHashMap) {
                this.templateCache.remove(templateId);
            }
            return true;
        }
        catch (IOException e) {
            LOGGER.error("Failed to delete template: {}", (Object)templateId, (Object)e);
            return false;
        }
    }

    public Set<String> getAllCategories() {
        return Collections.unmodifiableSet(this.categoryIndex.keySet());
    }

    public Set<String> getAllAuthors() {
        return Collections.unmodifiableSet(this.authorIndex.keySet());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CacheStats getCacheStats() {
        LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
        synchronized (linkedHashMap) {
            return new CacheStats(this.templateCache.size(), 20, this.metadataIndex.size());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clearCache() {
        LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
        synchronized (linkedHashMap) {
            this.templateCache.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void rescan() {
        this.metadataIndex.clear();
        this.fileIndex.clear();
        this.categoryIndex.clear();
        this.authorIndex.clear();
        LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
        synchronized (linkedHashMap) {
            this.templateCache.clear();
        }
        this.scanTemplates();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void replaceMetadataFromServer(Collection<TemplateMetadata> metadataList) {
        this.metadataIndex.clear();
        this.fileIndex.clear();
        this.categoryIndex.clear();
        this.authorIndex.clear();
        LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
        synchronized (linkedHashMap) {
            this.templateCache.clear();
        }
        if (metadataList == null) {
            return;
        }
        for (TemplateMetadata metadata : metadataList) {
            if (metadata == null || metadata.getTemplateId() == null) continue;
            metadata.ensureCommonAttributes();
            this.metadataIndex.put(metadata.getTemplateId(), metadata);
            String category = metadata.getCategory() != null ? metadata.getCategory() : "\u672a\u5206\u7c7b";
            String author = metadata.getAuthor() != null ? metadata.getAuthor() : "Unknown";
            this.categoryIndex.computeIfAbsent(category, k -> new HashSet()).add(metadata.getTemplateId());
            this.authorIndex.computeIfAbsent(author, k -> new HashSet()).add(metadata.getTemplateId());
        }
    }

    public void clearClientMetadata() {
        this.replaceMetadataFromServer(Collections.emptyList());
    }

    public boolean isResourceTemplate(String templateId) {
        return templateId != null && templateId.startsWith("resource/");
    }

    public Path getUserTemplateDirectory() {
        return this.userTemplateDirectory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean saveMetadataToFile(String templateId, TemplateMetadata metadata) {
        if (this.isResourceTemplate(templateId)) {
            LOGGER.error("Cannot modify bundled resource template metadata: {}", (Object)templateId);
            return false;
        }
        Path templatePath = this.fileIndex.get(templateId);
        if (templatePath == null) {
            LOGGER.error("Template file not found in fileIndex for ID: {}", (Object)templateId);
            return false;
        }
        if (Files.notExists(templatePath, new LinkOption[0])) {
            LOGGER.error("Template file does not exist: {}", (Object)templatePath);
            return false;
        }
        try {
            HywStructureTemplate template = this.loadTemplate(templateId);
            if (template == null) {
                LOGGER.error("Failed to load template: {}", (Object)templateId);
                return false;
            }
            metadata.ensureCommonAttributes();
            HywStructureTemplate.Builder builder = new HywStructureTemplate.Builder(template.getName(), template.getSize());
            builder.setCategory(template.getCategory()).setDescription(template.getDescription()).setEntrance(template.getEntrance()).setAuthor(template.getAuthor()).setCreatedTime(template.getCreatedTime()).setPlayerYaw(template.getPlayerYaw()).setIncludeEntities(template.includesEntities()).setIncludeBlockData(template.includesBlockData()).setHasMirrorVersion(template.hasMirrorVersion()).setEnableGeneration(metadata.isGenerationEnabled()).setGenerationWeight(metadata.getGenerationWeight()).setConnectionLayerDepth(metadata.getConnectionLayerDepth()).setMinGenerationHeight(metadata.getMinGenerationHeight()).setMaxGenerationHeight(metadata.getMaxGenerationHeight()).setGenerateOnSurface(metadata.isGenerateOnSurface()).putAllAttributes(metadata.getCustomAttributes());
            for (Map.Entry<HywStructureTemplate.ChunkPos, HywStructureTemplate.TemplateChunk> entry : template.getChunks().entrySet()) {
                HywStructureTemplate.ChunkPos chunkPos = entry.getKey();
                HywStructureTemplate.TemplateChunk chunk = entry.getValue();
                for (int x = 0; x < 16; ++x) {
                    for (int y = 0; y < 16; ++y) {
                        for (int z = 0; z < 16; ++z) {
                            class_2680 state = chunk.getBlock(x, y, z);
                            if (state == null || state.method_26215()) continue;
                            class_2338 worldPos = new class_2338(chunkPos.x * 16 + x, chunkPos.y * 16 + y, chunkPos.z * 16 + z);
                            builder.addBlock(worldPos, state, chunk.getTileData(x, y, z));
                        }
                    }
                }
            }
            if (template.getEntities() != null) {
                for (HywStructureTemplate.EntityData entity : template.getEntities()) {
                    builder.addEntity(entity.entityType, entity.relativePos, entity.nbt);
                }
            }
            HywStructureTemplate updatedTemplate = builder.build();
            TemplateSerializer.serialize(updatedTemplate, templatePath);
            this.metadataIndex.put(templateId, metadata);
            LinkedHashMap<String, HywStructureTemplate> linkedHashMap = this.templateCache;
            synchronized (linkedHashMap) {
                this.templateCache.remove(templateId);
            }
            return true;
        }
        catch (Exception e) {
            LOGGER.error("Failed to save template metadata for: {}", (Object)templateId, (Object)e);
            return false;
        }
    }

    public static class FilterCriteria {
        public String category;
        public String author;
        public Integer minSize;
        public Integer maxSize;
        public Integer minBlocks;
        public Integer maxBlocks;

        public FilterCriteria category(String category) {
            this.category = category;
            return this;
        }

        public FilterCriteria author(String author) {
            this.author = author;
            return this;
        }

        public FilterCriteria minSize(int minSize) {
            this.minSize = minSize;
            return this;
        }

        public FilterCriteria maxSize(int maxSize) {
            this.maxSize = maxSize;
            return this;
        }

        public FilterCriteria minBlocks(int minBlocks) {
            this.minBlocks = minBlocks;
            return this;
        }

        public FilterCriteria maxBlocks(int maxBlocks) {
            this.maxBlocks = maxBlocks;
            return this;
        }
    }

    public static class CacheStats {
        public final int cachedTemplates;
        public final int maxCacheSize;
        public final int totalTemplates;

        public CacheStats(int cachedTemplates, int maxCacheSize, int totalTemplates) {
            this.cachedTemplates = cachedTemplates;
            this.maxCacheSize = maxCacheSize;
            this.totalTemplates = totalTemplates;
        }

        public float getCacheUtilization() {
            return this.maxCacheSize > 0 ? (float)this.cachedTemplates / (float)this.maxCacheSize : 0.0f;
        }

        public float getCacheHitRate() {
            return this.totalTemplates > 0 ? (float)this.cachedTemplates / (float)this.totalTemplates : 0.0f;
        }
    }
}

