/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.template.attribute;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonNull;
import com.google.gson.JsonPrimitive;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Objects;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeDefinition;
import ydmsama.hundred_years_war.main.template.attribute.TemplateAttributeType;
import ydmsama.hundred_years_war.main.template.attribute.TemplateTags;

public final class TemplateAttributes {
    private static final Map<String, TemplateAttributeDefinition> DEFINITIONS;

    private TemplateAttributes() {
    }

    private static void add(Map<String, TemplateAttributeDefinition> map, TemplateAttributeDefinition definition) {
        map.put(definition.getKey(), definition);
    }

    public static Map<String, TemplateAttributeDefinition> definitions() {
        return DEFINITIONS;
    }

    public static TemplateAttributeDefinition getDefinition(String key) {
        return DEFINITIONS.get(key);
    }

    public static JsonElement normaliseValue(String key, JsonElement value) {
        TemplateAttributeDefinition def = DEFINITIONS.get(key);
        if (def != null) {
            JsonElement normalised = def.normalise(value);
            if (def.getType() == TemplateAttributeType.TAGS) {
                return TemplateAttributes.filterKnownTags(normalised);
            }
            return normalised;
        }
        return TemplateAttributes.clone(value);
    }

    public static void ensureDefaults(Map<String, JsonElement> target) {
        String key;
        if (target == null) {
            return;
        }
        LinkedHashMap<String, JsonElement> ordered = new LinkedHashMap<String, JsonElement>();
        for (Map.Entry<String, TemplateAttributeDefinition> entry : DEFINITIONS.entrySet()) {
            key = entry.getKey();
            TemplateAttributeDefinition def = entry.getValue();
            if (target.containsKey(key)) {
                ordered.put(key, def.normalise(target.get(key)));
                continue;
            }
            if (!def.isRequired()) continue;
            ordered.put(key, def.createDefaultValue());
        }
        for (Map.Entry<String, TemplateAttributeDefinition> entry : target.entrySet()) {
            key = entry.getKey();
            if (ordered.containsKey(key)) continue;
            ordered.put(key, TemplateAttributes.clone((JsonElement)entry.getValue()));
        }
        target.clear();
        target.putAll(ordered);
    }

    public static Map<String, JsonElement> createDefaultValues() {
        LinkedHashMap<String, JsonElement> defaults = new LinkedHashMap<String, JsonElement>();
        DEFINITIONS.forEach((key, definition) -> {
            if (definition.isRequired()) {
                defaults.put((String)key, definition.createDefaultValue());
            }
        });
        return defaults;
    }

    public static JsonElement createDefaultValue(String key) {
        TemplateAttributeDefinition def = DEFINITIONS.get(key);
        return def == null ? JsonNull.INSTANCE : def.createDefaultValue();
    }

    private static JsonElement clone(JsonElement element) {
        if (element == null) {
            return JsonNull.INSTANCE;
        }
        return element.deepCopy();
    }

    private static JsonElement filterKnownTags(JsonElement element) {
        if (element == null || element.isJsonNull() || !element.isJsonArray()) {
            return new JsonArray();
        }
        JsonArray source = element.getAsJsonArray();
        JsonArray filtered = new JsonArray();
        LinkedHashSet seen = new LinkedHashSet();
        source.forEach(item -> {
            String id;
            if (item != null && item.isJsonPrimitive() && item.getAsJsonPrimitive().isString() && TemplateTags.isKnownTag(id = item.getAsString()) && seen.add(id)) {
                filtered.add(id);
            }
        });
        return filtered;
    }

    public static double getDoubleOrDefault(Map<String, JsonElement> map, String key, double fallback) {
        Objects.requireNonNull(map, "map");
        JsonElement element = map.get(key);
        if (element == null || element.isJsonNull()) {
            return fallback;
        }
        TemplateAttributeDefinition definition = TemplateAttributes.getDefinition(key);
        if (definition != null && definition.getType() == TemplateAttributeType.DOUBLE) {
            return element.getAsDouble();
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsDouble();
        }
        return fallback;
    }

    public static int getIntOrDefault(Map<String, JsonElement> map, String key, int fallback) {
        Objects.requireNonNull(map, "map");
        JsonElement element = map.get(key);
        if (element == null || element.isJsonNull()) {
            return fallback;
        }
        TemplateAttributeDefinition definition = TemplateAttributes.getDefinition(key);
        if (definition != null && definition.getType() == TemplateAttributeType.INTEGER) {
            return element.getAsInt();
        }
        if (element.isJsonPrimitive() && element.getAsJsonPrimitive().isNumber()) {
            return element.getAsInt();
        }
        return fallback;
    }

    static {
        LinkedHashMap<String, TemplateAttributeDefinition> defs = new LinkedHashMap<String, TemplateAttributeDefinition>();
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("enable_generation", TemplateAttributeType.BOOLEAN, (JsonElement)new JsonPrimitive(Boolean.valueOf(false)), false));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("generation_weight", TemplateAttributeType.INTEGER, (JsonElement)new JsonPrimitive((Number)1), false, 1.0, 9999999.0));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("connection_layer_depth", TemplateAttributeType.INTEGER, (JsonElement)new JsonPrimitive((Number)10), false, 1.0, 255.0));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("min_generation_height", TemplateAttributeType.INTEGER, (JsonElement)new JsonPrimitive((Number)-64), false, -64.0, 320.0));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("max_generation_height", TemplateAttributeType.INTEGER, (JsonElement)new JsonPrimitive((Number)320), false, -64.0, 320.0));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("generate_on_surface", TemplateAttributeType.BOOLEAN, (JsonElement)new JsonPrimitive(Boolean.valueOf(true)), false));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("require_pregen", TemplateAttributeType.BOOLEAN, (JsonElement)new JsonPrimitive(Boolean.valueOf(false)), true));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("generate_underwater", TemplateAttributeType.BOOLEAN, (JsonElement)new JsonPrimitive(Boolean.valueOf(false)), true));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("generate_on_water_surface", TemplateAttributeType.BOOLEAN, (JsonElement)new JsonPrimitive(Boolean.valueOf(false)), true));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("author", TemplateAttributeType.STRING, (JsonElement)new JsonPrimitive(""), false));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("min_burial_rate", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, 1.0));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("max_burial_rate", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)1.0), false, 0.0, 1.0));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("biome_blacklist", TemplateAttributeType.STRING_LIST, (JsonElement)new JsonArray(), true));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("use_whitelist", TemplateAttributeType.BOOLEAN, (JsonElement)new JsonPrimitive(Boolean.valueOf(false)), true));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("building_tags", TemplateAttributeType.TAGS, (JsonElement)new JsonArray(), true));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("race", TemplateAttributeType.STRING_LIST, (JsonElement)new JsonArray(), false));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("settlement_type", TemplateAttributeType.STRING_LIST, (JsonElement)new JsonArray(), false));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("settlement_weight", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)1.0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("point_requirement", TemplateAttributeType.INTEGER, (JsonElement)new JsonPrimitive((Number)0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("development_requirement", TemplateAttributeType.INTEGER, (JsonElement)new JsonPrimitive((Number)0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("economic_building_development_income", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("economic_building_development_capacity", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("technology_building_research_income", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("technology_building_research_capacity", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("military_building_military_income", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, null));
        TemplateAttributes.add(defs, new TemplateAttributeDefinition("military_building_military_capacity", TemplateAttributeType.DOUBLE, (JsonElement)new JsonPrimitive((Number)0.0), false, 0.0, null));
        DEFINITIONS = Collections.unmodifiableMap(defs);
    }
}

