/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.reflect.TypeToken;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;
import net.minecraft.class_7923;
import org.slf4j.Logger;
import ydmsama.hundred_years_war.main.utils.HywLogger;

public class ExpBlacklistManager {
    private static List<String> expBlacklist = new ArrayList<String>();
    private static final Logger LOGGER = HywLogger.LOGGER;

    public static void loadExpBlacklist() {
        File expBlacklistFile;
        File configDir = new File("config/hundredyearswar");
        if (!configDir.exists()) {
            configDir.mkdirs();
            LOGGER.info("Created directory: config/hundredyearswar");
        }
        if (!(expBlacklistFile = new File("config/hundredyearswar/exp_blacklist.json5")).exists()) {
            LOGGER.info("exp_blacklist.json5 not found, creating default experience blacklist");
            ExpBlacklistManager.createDefaultExpBlacklist(expBlacklistFile);
        } else {
            LOGGER.info("Found existing exp_blacklist.json5");
        }
        try (FileReader reader = new FileReader(expBlacklistFile);){
            int length;
            StringBuilder content = new StringBuilder();
            char[] buffer = new char[1024];
            while ((length = reader.read(buffer)) != -1) {
                content.append(buffer, 0, length);
            }
            String jsonContent = content.toString().replaceAll("//.*", "");
            Gson gson = new GsonBuilder().setPrettyPrinting().create();
            expBlacklist = (List)gson.fromJson(jsonContent, new TypeToken<List<String>>(){}.getType());
            LOGGER.info("Loaded experience blacklist: {}", expBlacklist);
        }
        catch (IOException e) {
            LOGGER.error("Failed to load exp_blacklist.json5: {}", (Object)e.getMessage(), (Object)e);
            expBlacklist = new ArrayList<String>();
        }
    }

    private static void createDefaultExpBlacklist(File expBlacklistFile) {
        try {
            ArrayList<String> defaultBlacklist = new ArrayList<String>();
            defaultBlacklist.add("minecraft:silverfish");
            try (FileWriter writer = new FileWriter(expBlacklistFile);){
                writer.write("// Experience blacklist - these entities won't grant experience when killed by units\n");
                writer.write("// Format: \"namespace:entity_id\"\n");
                writer.write("// Example: \"minecraft:silverfish\" for silverfish\n");
                writer.write("[\n");
                for (int i = 0; i < defaultBlacklist.size(); ++i) {
                    writer.write("  \"" + (String)defaultBlacklist.get(i) + "\"");
                    if (i < defaultBlacklist.size() - 1) {
                        writer.write(",");
                    }
                    writer.write("\n");
                }
                writer.write("]\n");
            }
            expBlacklist = defaultBlacklist;
            LOGGER.info("Created default experience blacklist: {}", defaultBlacklist);
        }
        catch (IOException e) {
            LOGGER.error("Failed to create default experience blacklist", (Throwable)e);
            expBlacklist = new ArrayList<String>();
        }
    }

    public static boolean isInExpBlacklist(class_1309 entity) {
        if (entity == null) {
            return false;
        }
        String entityIdString = class_7923.field_41177.method_10221((Object)entity.method_5864()).toString();
        return expBlacklist.contains(entityIdString);
    }

    public static List<String> getExpBlacklist() {
        return new ArrayList<String>(expBlacklist);
    }

    public static void addToBlacklist(String entityId) {
        if (!expBlacklist.contains(entityId)) {
            expBlacklist.add(entityId);
        }
    }

    public static void removeFromBlacklist(String entityId) {
        expBlacklist.remove(entityId);
    }
}

