/*
 * Decompiled with CFR 0.152.
 */
package ydmsama.hundred_years_war.main.utils;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.HashSet;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2487;
import net.minecraft.class_2507;
import net.minecraft.class_3222;
import org.slf4j.Logger;
import ydmsama.hundred_years_war.main.config.ServerModConfig;
import ydmsama.hundred_years_war.main.registry.HywItemRegistry;
import ydmsama.hundred_years_war.main.utils.HywLogger;

public class FirstJoinHandler {
    private static final Logger LOGGER = HywLogger.LOGGER;
    private static final Set<UUID> firstJoinPlayers = new HashSet<UUID>();

    public static void handlePlayerFirstJoin(class_3222 player) {
        if (!ServerModConfig.INSTANCE.isEnableFirstJoinManual()) {
            return;
        }
        UUID playerUUID = player.method_5667();
        if (firstJoinPlayers.add(playerUUID)) {
            class_1799 manual = new class_1799((class_1935)HywItemRegistry.CONQUERORS_MANUAL);
            if (!player.method_31548().method_7394(manual)) {
                player.method_7328(manual, false);
            }
        }
    }

    public static void loadFirstJoinData(Path worldPath) {
        block9: {
            try {
                FirstJoinHandler.clearFirstJoinData();
                File file = worldPath.resolve("first_join_players.dat").toFile();
                if (!file.exists()) break block9;
                try (FileInputStream fis = new FileInputStream(file);){
                    class_2487 tag = class_2507.method_10629((InputStream)fis);
                    if (tag.method_10545("players")) {
                        int[] uuidArray = tag.method_10561("players");
                        for (int i = 0; i < uuidArray.length; i += 4) {
                            if (i + 3 >= uuidArray.length) continue;
                            long mostSig = (long)uuidArray[i] << 32 | (long)uuidArray[i + 1] & 0xFFFFFFFFL;
                            long leastSig = (long)uuidArray[i + 2] << 32 | (long)uuidArray[i + 3] & 0xFFFFFFFFL;
                            UUID uuid = new UUID(mostSig, leastSig);
                            firstJoinPlayers.add(uuid);
                        }
                    }
                }
                LOGGER.info("Loaded {} first-join player records", (Object)firstJoinPlayers.size());
            }
            catch (IOException e) {
                LOGGER.error("Failed to load first-join player data: {}", (Object)e.getMessage(), (Object)e);
            }
        }
    }

    public static void saveFirstJoinData(Path worldPath) {
        try {
            File file = worldPath.resolve("first_join_players.dat").toFile();
            class_2487 tag = new class_2487();
            int[] uuidArray = new int[firstJoinPlayers.size() * 4];
            int index = 0;
            for (UUID uuid : firstJoinPlayers) {
                long mostSig = uuid.getMostSignificantBits();
                long leastSig = uuid.getLeastSignificantBits();
                uuidArray[index++] = (int)(mostSig >> 32);
                uuidArray[index++] = (int)mostSig;
                uuidArray[index++] = (int)(leastSig >> 32);
                uuidArray[index++] = (int)leastSig;
            }
            tag.method_10539("players", uuidArray);
            try (FileOutputStream fos = new FileOutputStream(file);){
                class_2507.method_10634((class_2487)tag, (OutputStream)fos);
            }
            LOGGER.info("Saved {} first-join player records", (Object)firstJoinPlayers.size());
        }
        catch (IOException e) {
            LOGGER.error("Failed to save first-join player data: {}", (Object)e.getMessage(), (Object)e);
        }
    }

    public static void clearFirstJoinData() {
        firstJoinPlayers.clear();
    }

    public static int getFirstJoinPlayerCount() {
        return firstJoinPlayers.size();
    }
}

